/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.param.example;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.flow.param.builder.ParamDefinitionBuilder;
import kd.ai.gai.core.flow.param.builder.ParamValueBuilder;
import kd.ai.gai.core.flow.param.define.ArrayParamDefinition;
import kd.ai.gai.core.flow.param.define.BasicParamDefinition;
import kd.ai.gai.core.flow.param.define.ObjectParamDefinition;

public class ParamValueBuilderExample {
    public static void main(String[] args) {
        ParamValueBuilderExample.basicParamExample();
        ParamValueBuilderExample.objectExample();
        ParamValueBuilderExample.arrayExample();
        ParamValueBuilderExample.nestedStructureExample();
        ParamValueBuilderExample.dynamicBuildingExample();
    }

    public static void basicParamExample() {
        System.out.println("=== \u57fa\u672c\u7c7b\u578b\u53c2\u6570\u793a\u4f8b ===");
        BasicParamDefinition stringDef = ParamDefinitionBuilder.string("message").description("\u6d88\u606f\u5185\u5bb9").required(true).build();
        Object stringValue = ParamValueBuilder.forDefinition(stringDef).setValue("Hello Lambda World!").build();
        System.out.println("\u5b57\u7b26\u4e32\u53c2\u6570: " + stringValue);
        BasicParamDefinition integerDef = ParamDefinitionBuilder.integer("count").description("\u8ba1\u6570").required(true).build();
        Object integerValue = ParamValueBuilder.forDefinition(integerDef).setValue(42).build();
        System.out.println("\u6574\u6570\u53c2\u6570: " + integerValue);
        Object convertedValue = ParamValueBuilder.forDefinition(integerDef).setValue("100").build();
        System.out.println("\u8f6c\u6362\u540e\u7684\u6574\u6570: " + convertedValue + " (" + convertedValue.getClass().getSimpleName() + ")");
    }

    public static void objectExample() {
        System.out.println("\n=== \u5bf9\u8c61\u53c2\u6570\u793a\u4f8b ===");
        ObjectParamDefinition addressDef = ParamDefinitionBuilder.object("address").property(ParamDefinitionBuilder.string("street").required(true).build()).property(ParamDefinitionBuilder.string("city").required(true).build()).property(ParamDefinitionBuilder.string("zipCode").build()).build();
        ObjectParamDefinition userDef = ParamDefinitionBuilder.object("user").property(ParamDefinitionBuilder.string("name").required(true).build()).property(ParamDefinitionBuilder.integer("age").build()).property(ParamDefinitionBuilder.string("email").build()).property(addressDef).build();
        Object userValue = ParamValueBuilder.forDefinition(userDef).setValue("name", "John Doe").setValue("age", 30).setValue("email", "john@example.com").object("address", address -> address.setValue("street", "123 Main St").setValue("city", "Anytown").setValue("zipCode", "12345")).build();
        System.out.println("\u7528\u6237\u5bf9\u8c61: " + userValue);
        Map user = (Map)userValue;
        System.out.println("\u7528\u6237\u540d: " + user.get("name"));
        Map address2 = (Map)user.get("address");
        System.out.println("\u5730\u5740: " + address2.get("street") + ", " + address2.get("city"));
    }

    public static void arrayExample() {
        System.out.println("\n=== \u6570\u7ec4\u53c2\u6570\u793a\u4f8b ===");
        ArrayParamDefinition tagsArrayDef = ParamDefinitionBuilder.stringArray("tags").description("\u6807\u7b7e\u5217\u8868").build();
        Object tagsValue = ParamValueBuilder.forDefinition(tagsArrayDef).array(items -> items.item("java").item("spring").item("database")).build();
        System.out.println("\u6807\u7b7e\u6570\u7ec4: " + tagsValue);
        List<String> technologies = Arrays.asList("cloud", "microservice", "docker", "kubernetes");
        Object techsValue = ParamValueBuilder.forDefinition(tagsArrayDef).array(items -> items.items(technologies)).build();
        System.out.println("\u6280\u672f\u6807\u7b7e\u6570\u7ec4: " + techsValue);
    }

    public static void nestedStructureExample() {
        System.out.println("\n=== \u5d4c\u5957\u7ed3\u6784\u793a\u4f8b ===");
        ObjectParamDefinition contactDef = ParamDefinitionBuilder.object("contact").property(ParamDefinitionBuilder.string("type").required(true).build()).property(ParamDefinitionBuilder.string("value").required(true).build()).build();
        ArrayParamDefinition contactsArrayDef = ParamDefinitionBuilder.array("contacts", contactDef).description("\u8054\u7cfb\u65b9\u5f0f\u5217\u8868").build();
        ObjectParamDefinition projectDef = ParamDefinitionBuilder.object("project").property(ParamDefinitionBuilder.string("name").required(true).build()).property(ParamDefinitionBuilder.string("description").build()).property(ParamDefinitionBuilder.date("startDate").required(true).build()).build();
        ArrayParamDefinition projectsArrayDef = ParamDefinitionBuilder.array("projects", projectDef).description("\u9879\u76ee\u5217\u8868").build();
        ObjectParamDefinition profileDef = ParamDefinitionBuilder.object("profile").property(ParamDefinitionBuilder.string("id").required(true).build()).property(ParamDefinitionBuilder.string("name").required(true).build()).property(ParamDefinitionBuilder.string("title").build()).property(ParamDefinitionBuilder.integer("experience").build()).property(ParamDefinitionBuilder.stringArray("skills").build()).property(contactsArrayDef).property(projectsArrayDef).build();
        Object profileValue = ParamValueBuilder.forDefinition(profileDef).setValue("id", "EMP-12345").setValue("name", "Jane Smith").setValue("title", "Senior Developer").setValue("experience", 8).array("skills", items -> items.items(Arrays.asList("Java", "Spring", "React", "Docker"))).array("contacts", items -> items.object(contact -> contact.setValue("type", "email").setValue("value", "jane@example.com")).object(contact -> contact.setValue("type", "phone").setValue("value", "123-456-7890")).object(contact -> contact.setValue("type", "linkedin").setValue("value", "linkedin.com/in/janesmith"))).array("projects", items -> items.object(project -> project.setValue("name", "\u5fae\u670d\u52a1\u8f6c\u578b").setValue("description", "\u5c06\u5355\u4f53\u5e94\u7528\u8fc1\u79fb\u5230\u5fae\u670d\u52a1\u67b6\u6784").setValue("startDate", new Date(System.currentTimeMillis() - 15552000000L))).object(project -> project.setValue("name", "DevOps\u5b9e\u65bd").setValue("description", "\u5b9e\u65bd\u81ea\u52a8\u5316CI/CD\u6d41\u7a0b").setValue("startDate", new Date(System.currentTimeMillis() - 7776000000L)))).build();
        System.out.println("\u4eba\u5458\u8d44\u6599\u5bf9\u8c61\u6784\u5efa\u6210\u529f!");
        Map profile = (Map)profileValue;
        System.out.println("\u59d3\u540d: " + profile.get("name"));
        System.out.println("\u804c\u4f4d: " + profile.get("title"));
        List skills = (List)profile.get("skills");
        System.out.println("\u6280\u80fd: " + String.join((CharSequence)", ", skills));
        List contacts = (List)profile.get("contacts");
        System.out.println("\u8054\u7cfb\u65b9\u5f0f\u6570\u91cf: " + contacts.size());
        for (Map contact : contacts) {
            System.out.println("- " + contact.get("type") + ": " + contact.get("value"));
        }
        List projects = (List)profile.get("projects");
        System.out.println("\u9879\u76ee\u6570\u91cf: " + projects.size());
        for (Map project : projects) {
            System.out.println("- " + project.get("name") + ": " + project.get("description"));
        }
    }

    public static void dynamicBuildingExample() {
        System.out.println("\n=== \u52a8\u6001\u6784\u5efa\u793a\u4f8b ===");
        ObjectParamDefinition productDef = ParamDefinitionBuilder.object("product").property(ParamDefinitionBuilder.string("id").required(true).build()).property(ParamDefinitionBuilder.string("name").required(true).build()).property(ParamDefinitionBuilder.ffloat("price").required(true).build()).property(ParamDefinitionBuilder.integer("stock").build()).property(ParamDefinitionBuilder.stringArray("categories").build()).build();
        ObjectParamDefinition catalogDef = ParamDefinitionBuilder.object("catalog").property(ParamDefinitionBuilder.string("id").required(true).build()).property(ParamDefinitionBuilder.string("name").required(true).build()).property(ParamDefinitionBuilder.date("lastUpdated").required(true).build()).property(ParamDefinitionBuilder.array("products", productDef).build()).build();
        List<ProductData> productsData = Arrays.asList(new ProductData("P-001", "\u7b14\u8bb0\u672c\u7535\u8111", 5999.99, 15, Arrays.asList("\u7535\u5b50\u4ea7\u54c1", "\u7535\u8111")), new ProductData("P-002", "\u65e0\u7ebf\u9f20\u6807", 129.99, 50, Arrays.asList("\u7535\u8111\u914d\u4ef6", "\u5916\u8bbe")), new ProductData("P-003", "\u663e\u793a\u5668", 1299.0, 10, Arrays.asList("\u7535\u5b50\u4ea7\u54c1", "\u7535\u8111\u914d\u4ef6")), new ProductData("P-004", "\u673a\u68b0\u952e\u76d8", 399.0, 30, Arrays.asList("\u7535\u8111\u914d\u4ef6", "\u5916\u8bbe")), new ProductData("P-005", "\u79fb\u52a8\u786c\u76d8", 499.0, 20, Arrays.asList("\u5b58\u50a8\u8bbe\u5907", "\u7535\u8111\u914d\u4ef6")));
        Object catalogValue = ParamValueBuilder.forDefinition(catalogDef).setValue("id", "CAT-2025-01").setValue("name", "\u7535\u5b50\u4ea7\u54c1\u76ee\u5f55").setValue("lastUpdated", new Date()).array("products", items -> {
            for (ProductData data : productsData) {
                if (data.stock < 20) continue;
                items.object(product -> product.setValue("id", data.id).setValue("name", data.name).setValue("price", data.price).setValue("stock", data.stock).array("categories", categories -> categories.items(data.categories)));
            }
        }).build();
        System.out.println("\u52a8\u6001\u6784\u5efa\u7684\u76ee\u5f55\u5bf9\u8c61\u6210\u529f!");
        Map catalog = (Map)catalogValue;
        System.out.println("\u76ee\u5f55ID: " + catalog.get("id"));
        System.out.println("\u76ee\u5f55\u540d\u79f0: " + catalog.get("name"));
        System.out.println("\u6700\u540e\u66f4\u65b0: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(catalog.get("lastUpdated")));
        List products = (List)catalog.get("products");
        System.out.println("\u7b5b\u9009\u540e\u4ea7\u54c1\u6570\u91cf: " + products.size());
        for (Map product : products) {
            System.out.println("- " + product.get("name") + ": \u00a5" + product.get("price") + ", \u5e93\u5b58: " + product.get("stock"));
            List categories = (List)product.get("categories");
            System.out.println("  \u5206\u7c7b: " + String.join((CharSequence)", ", categories));
        }
    }

    static class ProductData {
        String id;
        String name;
        double price;
        int stock;
        List<String> categories;

        public ProductData(String id, String name, double price, int stock, List<String> categories) {
            this.id = id;
            this.name = name;
            this.price = price;
            this.stock = stock;
            this.categories = categories;
        }
    }
}

