/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.param.execution;

import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.Node;
import kd.ai.gai.core.flow.build.NodeVariableItem;
import kd.ai.gai.core.flow.build.VariableBuilderFactory;
import kd.ai.gai.core.flow.build.attribute.FlowAttribute;
import kd.ai.gai.core.flow.build.attribute.NodeAttribute;
import kd.ai.gai.core.flow.param.define.NodeParamPath;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.dimension.ParamDirection;
import kd.ai.gai.core.flow.param.execution.IParamManager;
import kd.ai.gai.core.flow.param.helper.ParamValueHelper;
import kd.ai.gai.flow.flow.core.Execution;
import kd.ai.gai.flow.flow.core.Variable;

public class VariableManager
implements IParamManager {
    @Override
    public void initParamValue(Execution e, Variable variable, ParamDefinition paramDefinition) {
        if (paramDefinition == null) {
            e.set(variable.getName(), variable.getInitValue());
            return;
        }
        Object value = null;
        if (paramDefinition.isConstant()) {
            value = paramDefinition.getConstantValue();
        } else if (paramDefinition.isReference()) {
            value = this.getParamValueByPath(e, paramDefinition.getReferencePath());
        }
        e.set(variable.getName(), value);
    }

    @Override
    public void setParamValue(Execution e, int nodeId, String paramName, ParamDirection paramDirection, Object value) {
        e.set(VariableBuilderFactory.getVariableId(nodeId, paramName, paramDirection), value);
    }

    @Override
    public void setParamValue(Execution e, Node node, ParamDefinition paramDefinition, Object value) {
        NodeVariableItem nodeVariableItem = new NodeVariableItem(node, paramDefinition);
        e.set(VariableBuilderFactory.getVariableId(nodeVariableItem), value);
    }

    @Override
    public Object getParamValue(Execution e, Node node, ParamDefinition paramDefinition) {
        NodeVariableItem nodeVariableItem = new NodeVariableItem(node, paramDefinition);
        return e.get(VariableBuilderFactory.getVariableId(nodeVariableItem));
    }

    @Override
    public Object getParamValue(Execution e, int nodeId, String paramName, ParamDirection paramDirection) {
        return e.get(VariableBuilderFactory.getVariableId(nodeId, paramName, paramDirection));
    }

    @Override
    public void setParamValueByPath(Execution e, NodeParamPath nodeParamPath, Object value) {
        Action curExecuteAction = this.getCurrentExecuteAction(e);
        ParamDirection paramDirection = VariableBuilderFactory.getDirection(curExecuteAction, nodeParamPath.getNodeIdAtInt());
        e.set(VariableBuilderFactory.getVariableId(Integer.parseInt(nodeParamPath.getNodeId()), nodeParamPath.getOutputParamName(), paramDirection), value);
    }

    @Override
    public Object getParamValueByPath(Execution e, NodeParamPath nodeParamPath) {
        String refNodeId = nodeParamPath.getNodeId();
        String refParamName = nodeParamPath.getOutputParamName();
        Action curExecuteAction = this.getCurrentExecuteAction(e);
        ParamDirection paramDirection = VariableBuilderFactory.getDirection(curExecuteAction, nodeParamPath.getNodeIdAtInt());
        Object refRootValue = e.get(VariableBuilderFactory.getVariableId(Integer.parseInt(refNodeId), refParamName, paramDirection));
        return ParamValueHelper.resolveValue(refRootValue, nodeParamPath);
    }

    @Override
    public Variable findVariable(Execution e, Node node, ParamDefinition paramDefinition) {
        NodeVariableItem nodeVariableItem = new NodeVariableItem(node, paramDefinition);
        String variableId = VariableBuilderFactory.getVariableId(nodeVariableItem);
        return e.find(variableId);
    }

    private Flow getFlow(Execution e) {
        Object oGaiFlow = e.getDefine().getFlow().getAttribute(FlowAttribute.GAI_FLOW.name());
        if (oGaiFlow != null) {
            return (Flow)oGaiFlow;
        }
        return null;
    }

    private Action getCurrentExecuteAction(Execution e) {
        Flow gaiFlow = this.getFlow(e);
        if (gaiFlow == null) {
            return null;
        }
        int currentActionId = (Integer)e.getDefine().getAttribute(NodeAttribute.NODE_ID.name());
        Object isExecutingCondition = e.getProperty("EXECUTING_CONDITION");
        if (isExecutingCondition != null && ((Boolean)isExecutingCondition).booleanValue()) {
            currentActionId = (Integer)e.getProperty("EXECUTING_CONDITION_TONODE_ID");
        }
        return gaiFlow.findActionById(currentActionId);
    }
}

