/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.param.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.ai.gai.core.flow.param.define.NodeParamPath;
import org.apache.commons.lang3.StringUtils;

public class ParamPathHelper {
    private static final Pattern FULL_PATH_PATTERN = Pattern.compile("([\\w-]+)\\.(system(?:\\.[\\w-]+)*|[\\w-]+(?:\\[index\\])?|\\{\\{index\\}\\})(.*)");

    public static String generateFullPath(String nodeId, String paramName, List<String> pathSegments) {
        if (nodeId == null || nodeId.isEmpty()) {
            throw new IllegalArgumentException("\u8282\u70b9ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (paramName == null || paramName.isEmpty()) {
            throw new IllegalArgumentException("\u53c2\u6570\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StringBuilder path = new StringBuilder(nodeId).append(".").append(paramName);
        if (pathSegments != null && !pathSegments.isEmpty()) {
            for (String segment : pathSegments) {
                if ("*".equals(segment)) {
                    path.append("[*]");
                    continue;
                }
                if (segment.startsWith("*.")) {
                    String property = segment.substring(2);
                    path.append("[*].").append(property);
                    continue;
                }
                if (segment.matches("\\d+")) {
                    path.append("[").append(segment).append("]");
                    continue;
                }
                path.append(".").append(segment);
            }
        }
        return path.toString();
    }

    public static String generatePathSegments(List<String> pathSegments) {
        if (pathSegments == null || pathSegments.isEmpty()) {
            return "";
        }
        StringBuilder path = new StringBuilder();
        for (String segment : pathSegments) {
            if ("*".equals(segment)) {
                path.append("[*]");
                continue;
            }
            if (segment.startsWith("*.")) {
                String property = segment.substring(2);
                path.append("[*].").append(property);
                continue;
            }
            if (segment.matches("\\d+")) {
                path.append("[").append(segment).append("]");
                continue;
            }
            path.append(".").append(segment);
        }
        return path.toString();
    }

    public static NodeParamPath parseFullPath(String path) {
        return ParamPathHelper.parseFullPath(FULL_PATH_PATTERN, path);
    }

    public static NodeParamPath parseFullPath(Pattern patten, String path) {
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("\u53c2\u6570\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (path.length() > 2000) {
            throw new IllegalArgumentException("\u53c2\u6570\u8def\u5f84\u957f\u5ea6\u8d85\u51fa\u9650\u5236");
        }
        Matcher matcher = patten.matcher(path);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684\u8def\u5f84\u683c\u5f0f: " + path);
        }
        String nodeId = matcher.group(1);
        String paramName = matcher.group(2);
        String propertyPathStr = matcher.group(3);
        ArrayList<String> propertySegments = propertyPathStr != null && !propertyPathStr.isEmpty() ? ParamPathHelper.parsePropertyPath(propertyPathStr) : new ArrayList<String>();
        return new NodeParamPath(nodeId, paramName, propertySegments);
    }

    public static List<String> parsePropertyPath(String pathStr) {
        ArrayList<String> segments = new ArrayList<String>(1);
        if (StringUtils.isBlank((CharSequence)pathStr)) {
            return segments;
        }
        Pattern pattern = Pattern.compile("\\.([^.\\[\\]]+)|\\[(\\d+)\\]|\\[\\*\\](?:\\.([^.\\[\\]]+))?");
        Matcher matcher = pattern.matcher(pathStr);
        while (matcher.find()) {
            String propertyName = matcher.group(1);
            String arrayIndex = matcher.group(2);
            String wildcardProp = matcher.group(3);
            if (propertyName != null) {
                segments.add(propertyName);
                continue;
            }
            if (arrayIndex != null) {
                segments.add(arrayIndex);
                continue;
            }
            if (wildcardProp != null) {
                segments.add("*." + wildcardProp);
                continue;
            }
            segments.add("*");
        }
        return segments;
    }

    public static String toString(NodeParamPath paramPath) {
        if (paramPath == null) {
            return "";
        }
        return ParamPathHelper.generateFullPath(paramPath.getNodeId(), paramPath.getOutputParamName(), paramPath.getPropertyPath());
    }
}

