/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.param.helper;

import java.util.List;
import kd.ai.gai.core.flow.param.define.ArrayParamDefinition;
import kd.ai.gai.core.flow.param.define.BasicParamDefinition;
import kd.ai.gai.core.flow.param.define.FormatDateParamDefinition;
import kd.ai.gai.core.flow.param.define.NodeParamPath;
import kd.ai.gai.core.flow.param.define.ObjectParamDefinition;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.dimension.ParamDirection;
import kd.ai.gai.core.flow.param.dimension.ParamSource;
import kd.ai.gai.core.flow.param.dimension.ParamVisibility;

public class ParamReferenceHelper {
    public static ParamDefinition resolveReference(String paramName, ParamDefinition sourceParamDef, NodeParamPath referencePath) {
        ParamDefinition resolvedDef = ParamReferenceHelper.resolveDefinition(paramName, sourceParamDef, referencePath.getPropertyPath());
        resolvedDef.setReferencePath(referencePath);
        ParamReferenceHelper.setSourceRecursively(resolvedDef);
        resolvedDef.setDirection(ParamDirection.INPUT);
        resolvedDef.setVisibility(ParamVisibility.PRIVATE);
        return resolvedDef;
    }

    private static void setSourceRecursively(ParamDefinition def) {
        ArrayParamDefinition arrayDef;
        def.setSource(ParamSource.REFERENCE);
        if (def instanceof ObjectParamDefinition) {
            ObjectParamDefinition objDef = (ObjectParamDefinition)def;
            for (ParamDefinition property : objDef.getProperties()) {
                ParamReferenceHelper.setSourceRecursively(property);
            }
        } else if (def instanceof ArrayParamDefinition && (arrayDef = (ArrayParamDefinition)def).getItemDefinition() != null) {
            ParamReferenceHelper.setSourceRecursively(arrayDef.getItemDefinition());
        }
    }

    private static ParamDefinition resolveDefinition(String paramName, ParamDefinition sourceDef, List<String> propertyPath) {
        if (propertyPath == null || propertyPath.isEmpty()) {
            return ParamReferenceHelper.cloneDefinition(paramName, sourceDef);
        }
        String segment = propertyPath.get(0);
        List<String> remainingPath = propertyPath.subList(1, propertyPath.size());
        if (segment.matches("\\d+") || "*".equals(segment) || segment.startsWith("*.")) {
            return ParamReferenceHelper.resolveArraySegment(paramName, sourceDef, segment, remainingPath);
        }
        return ParamReferenceHelper.resolveObjectProperty(paramName, sourceDef, segment, remainingPath);
    }

    private static ParamDefinition resolveArraySegment(String paramName, ParamDefinition sourceDef, String segment, List<String> remainingPath) {
        if (!(sourceDef instanceof ArrayParamDefinition)) {
            throw new IllegalArgumentException("\u8def\u5f84\u6bb5[" + segment + "]\u6307\u5b9a\u4e86\u6570\u7ec4\u8bbf\u95ee\uff0c\u4f46\u6e90\u5b9a\u4e49\u4e0d\u662f\u6570\u7ec4\u7c7b\u578b");
        }
        ArrayParamDefinition arrayDef = (ArrayParamDefinition)sourceDef;
        ParamDefinition itemDef = arrayDef.getItemDefinition();
        if ("*".equals(segment)) {
            if (remainingPath.isEmpty()) {
                return ParamReferenceHelper.cloneArrayDefinition(paramName, arrayDef);
            }
            ParamDefinition resolvedItemDef = ParamReferenceHelper.resolveDefinition("item", itemDef, remainingPath);
            return new ArrayParamDefinition(paramName, resolvedItemDef);
        }
        if (segment.startsWith("*.")) {
            String property = segment.substring(2);
            if (!(itemDef instanceof ObjectParamDefinition)) {
                throw new IllegalArgumentException("\u901a\u914d\u7b26\u5c5e\u6027[" + segment + "]\u8981\u6c42\u6570\u7ec4\u9879\u4e3a\u5bf9\u8c61\u7c7b\u578b");
            }
            ObjectParamDefinition objItemDef = (ObjectParamDefinition)itemDef;
            ParamDefinition propDef = objItemDef.getProperty(property);
            if (propDef == null) {
                throw new IllegalArgumentException("\u627e\u4e0d\u5230\u5c5e\u6027[" + property + "]\u5728\u6570\u7ec4\u9879\u5b9a\u4e49\u4e2d");
            }
            if (remainingPath.isEmpty()) {
                return new ArrayParamDefinition(paramName, ParamReferenceHelper.cloneDefinition("item", propDef));
            }
            ParamDefinition resolvedPropDef = ParamReferenceHelper.resolveDefinition("item", propDef, remainingPath);
            return new ArrayParamDefinition(paramName, resolvedPropDef);
        }
        int index = Integer.parseInt(segment);
        if (remainingPath.isEmpty()) {
            return ParamReferenceHelper.cloneDefinition(paramName, itemDef);
        }
        return ParamReferenceHelper.resolveDefinition(paramName, itemDef, remainingPath);
    }

    private static ParamDefinition resolveObjectProperty(String paramName, ParamDefinition sourceDef, String propertyName, List<String> remainingPath) {
        if (!(sourceDef instanceof ObjectParamDefinition)) {
            throw new IllegalArgumentException("\u8def\u5f84\u6bb5[" + propertyName + "]\u6307\u5b9a\u4e86\u5c5e\u6027\u8bbf\u95ee\uff0c\u4f46\u6e90\u5b9a\u4e49\u4e0d\u662f\u5bf9\u8c61\u7c7b\u578b");
        }
        ObjectParamDefinition objDef = (ObjectParamDefinition)sourceDef;
        ParamDefinition propDef = objDef.getProperty(propertyName);
        if (propDef == null) {
            throw new IllegalArgumentException("\u627e\u4e0d\u5230\u5c5e\u6027[" + propertyName + "]\u5728\u5bf9\u8c61\u5b9a\u4e49\u4e2d");
        }
        if (remainingPath.isEmpty()) {
            return ParamReferenceHelper.cloneDefinition(paramName, propDef);
        }
        return ParamReferenceHelper.resolveDefinition(paramName, propDef, remainingPath);
    }

    public static ParamDefinition cloneDefinition(String paramName, ParamDefinition source) {
        if (source instanceof FormatDateParamDefinition) {
            return ParamReferenceHelper.cloneFormatDateDefinition(paramName, (FormatDateParamDefinition)source);
        }
        if (source instanceof BasicParamDefinition) {
            return ParamReferenceHelper.cloneBasicDefinition(paramName, (BasicParamDefinition)source);
        }
        if (source instanceof ObjectParamDefinition) {
            return ParamReferenceHelper.cloneObjectDefinition(paramName, (ObjectParamDefinition)source);
        }
        if (source instanceof ArrayParamDefinition) {
            return ParamReferenceHelper.cloneArrayDefinition(paramName, (ArrayParamDefinition)source);
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u53c2\u6570\u5b9a\u4e49\u7c7b\u578b: " + source.getClass().getName());
    }

    private static FormatDateParamDefinition cloneFormatDateDefinition(String paramName, FormatDateParamDefinition source) {
        FormatDateParamDefinition clone = new FormatDateParamDefinition(paramName, source.getFormat());
        ParamReferenceHelper.copyCommonProperties(source, clone);
        return clone;
    }

    private static BasicParamDefinition cloneBasicDefinition(String paramName, BasicParamDefinition source) {
        BasicParamDefinition clone = new BasicParamDefinition(paramName, source.getType());
        ParamReferenceHelper.copyCommonProperties(source, clone);
        return clone;
    }

    private static ObjectParamDefinition cloneObjectDefinition(String paramName, ObjectParamDefinition source) {
        ObjectParamDefinition clone = new ObjectParamDefinition(paramName);
        ParamReferenceHelper.copyCommonProperties(source, clone);
        for (ParamDefinition property : source.getProperties()) {
            ParamDefinition propClone = ParamReferenceHelper.cloneDefinition(property.getName(), property);
            clone.addProperty(propClone);
        }
        return clone;
    }

    private static ArrayParamDefinition cloneArrayDefinition(String paramName, ArrayParamDefinition source) {
        ParamDefinition itemClone = ParamReferenceHelper.cloneDefinition(source.getItemDefinition().getName(), source.getItemDefinition());
        ArrayParamDefinition clone = new ArrayParamDefinition(paramName, itemClone);
        ParamReferenceHelper.copyCommonProperties(source, clone);
        return clone;
    }

    private static void copyCommonProperties(ParamDefinition source, ParamDefinition target) {
        target.setDescription(source.getDescription());
        target.setRequired(source.isRequired());
        target.setDirection(source.getDirection());
        target.setVisibility(source.getVisibility());
    }
}

