/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.param.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.flow.param.define.NodeParamPath;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.helper.ParamPathHelper;

public class ParamValueHelper {
    public static Object getReferencedValue(Object rootValue, ParamDefinition paramDef) {
        if (paramDef == null || !paramDef.isReference()) {
            return null;
        }
        NodeParamPath referencePath = paramDef.getReferencePath();
        if (referencePath == null) {
            throw new IllegalStateException("\u5f15\u7528\u7c7b\u578b\u53c2\u6570 " + paramDef.getName() + " \u7f3a\u5c11\u5f15\u7528\u8def\u5f84");
        }
        return ParamValueHelper.resolveValue(rootValue, referencePath);
    }

    public static Object resolveValue(Object rootValue, NodeParamPath paramPath) {
        if (rootValue == null || paramPath == null) {
            return null;
        }
        List<String> propertyPath = paramPath.getPropertyPath();
        if (propertyPath != null && !propertyPath.isEmpty()) {
            return ParamValueHelper.resolvePropertyPath(rootValue, propertyPath);
        }
        return rootValue;
    }

    public static Object resolveValue(Object rootValue, String pathString) {
        NodeParamPath paramPath = ParamPathHelper.parseFullPath(pathString);
        return ParamValueHelper.resolveValue(rootValue, paramPath);
    }

    public static Object resolvePropertyPath(Object rootValue, List<String> propertyPath) {
        if (rootValue == null || propertyPath == null || propertyPath.isEmpty()) {
            return rootValue;
        }
        Object current = rootValue;
        for (int i = 0; i < propertyPath.size(); ++i) {
            if (current == null) {
                return null;
            }
            String segment = propertyPath.get(i);
            if ("*".equals(segment) || segment.startsWith("*.")) {
                if (!(current instanceof List)) {
                    throw new IllegalArgumentException("\u65e0\u6cd5\u5728\u975e\u6570\u7ec4\u7c7b\u578b\u4e0a\u4f7f\u7528\u901a\u914d\u7b26: " + current.getClass().getName());
                }
                List sourceList = (List)current;
                if ("*".equals(segment) && i == propertyPath.size() - 1) {
                    return sourceList;
                }
                String subProperty = null;
                if (segment.startsWith("*.")) {
                    subProperty = segment.substring(2);
                }
                List<String> remainingPath = propertyPath.subList(i + 1, propertyPath.size());
                ArrayList<Object> resultList = new ArrayList<Object>();
                for (Object item : sourceList) {
                    if (item == null) continue;
                    if (subProperty != null) {
                        if (item instanceof Map) {
                            item = ((Map)item).get(subProperty);
                        } else {
                            throw new IllegalArgumentException("\u65e0\u6cd5\u5728\u975e\u5bf9\u8c61\u7c7b\u578b\u4e0a\u8bbf\u95ee\u5b50\u5c5e\u6027: " + item.getClass().getName());
                        }
                    }
                    if (!remainingPath.isEmpty()) {
                        Object subResult = ParamValueHelper.resolvePropertyPath(item, remainingPath);
                        if (subResult == null) continue;
                        resultList.add(subResult);
                        continue;
                    }
                    resultList.add(item);
                }
                return resultList;
            }
            if (segment.matches("\\d+")) {
                int index = Integer.parseInt(segment);
                if (current instanceof List) {
                    List list = (List)current;
                    if (index >= list.size()) {
                        return null;
                    }
                    current = list.get(index);
                    continue;
                }
                throw new IllegalArgumentException("\u65e0\u6cd5\u7528\u7d22\u5f15\u8bbf\u95ee\u975e\u6570\u7ec4\u7c7b\u578b: " + current.getClass().getName());
            }
            if (current instanceof Map) {
                Map map = (Map)current;
                current = map.get(segment);
                continue;
            }
            throw new IllegalArgumentException("\u65e0\u6cd5\u8bbf\u95ee\u975e\u5bf9\u8c61\u7c7b\u578b\u7684\u5c5e\u6027: " + current.getClass().getName());
        }
        return current;
    }
}

