/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.param.legacy;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.AskUserAction;
import kd.ai.gai.core.engine.flow.CodeAction;
import kd.ai.gai.core.engine.flow.End;
import kd.ai.gai.core.engine.flow.JavaPluginAction;
import kd.ai.gai.core.engine.flow.LLMAction;
import kd.ai.gai.core.engine.flow.LoopAction;
import kd.ai.gai.core.engine.flow.MessageAction;
import kd.ai.gai.core.engine.flow.ParallelAction;
import kd.ai.gai.core.engine.flow.RepoAction;
import kd.ai.gai.core.engine.flow.RepoReplyAction;
import kd.ai.gai.core.engine.flow.Start;
import kd.ai.gai.core.engine.flow.ToolAction;
import kd.ai.gai.core.engine.flow.Var;
import kd.ai.gai.core.engine.flow.VarMapper;
import kd.ai.gai.core.enuz.ProcessNodeType;
import kd.ai.gai.core.enuz.field.type.VarFieldType;
import kd.ai.gai.core.flow.build.VariableBuilderFactory;
import kd.ai.gai.core.flow.param.define.ArrayParamDefinition;
import kd.ai.gai.core.flow.param.define.BasicParamDefinition;
import kd.ai.gai.core.flow.param.define.NodeParamPath;
import kd.ai.gai.core.flow.param.define.ObjectParamDefinition;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.dimension.ParamDirection;
import kd.ai.gai.core.flow.param.dimension.ParamType;
import kd.ai.gai.core.flow.param.dimension.ParamVisibility;
import kd.ai.gai.core.flow.param.legacy.impl.MigrateAskUserAction;
import kd.ai.gai.core.flow.param.legacy.impl.MigrateCodeAction;
import kd.ai.gai.core.flow.param.legacy.impl.MigrateEnd;
import kd.ai.gai.core.flow.param.legacy.impl.MigrateJavaPluginAction;
import kd.ai.gai.core.flow.param.legacy.impl.MigrateLLMAction;
import kd.ai.gai.core.flow.param.legacy.impl.MigrateLoopAction;
import kd.ai.gai.core.flow.param.legacy.impl.MigrateMessageAction;
import kd.ai.gai.core.flow.param.legacy.impl.MigrateParallelAction;
import kd.ai.gai.core.flow.param.legacy.impl.MigrateRepoAction;
import kd.ai.gai.core.flow.param.legacy.impl.MigrateRepoReplyAction;
import kd.ai.gai.core.flow.param.legacy.impl.MigrateStart;
import kd.ai.gai.core.flow.param.legacy.impl.MigrateToolAction;
import kd.bos.dataentity.utils.StringUtils;

public class LegacyMigrationHelper {
    public static ParamDefinition convert(Var var, VarMapper varMapper) {
        ParamDefinition paramDefinition = LegacyMigrationHelper.convertVar(var);
        if (varMapper == null) {
            return paramDefinition;
        }
        NodeParamPath path = new NodeParamPath();
        path.setNodeId(String.valueOf(varMapper.getOutNodeId()));
        path.setOutputParamName(varMapper.getOutVarName());
        paramDefinition.setReferencePath(path);
        if (VarFieldType.STRING.getType().equals(var.getType())) {
            paramDefinition.setHeterogeneousReference(true);
        }
        return paramDefinition;
    }

    public static ParamDefinition convertVar(Var var) {
        ParamDefinition paramDef;
        VarFieldType oldType = var.getVarFieldType();
        ParamType newType = LegacyMigrationHelper.convertType(oldType);
        if (newType == ParamType.OBJECT) {
            paramDef = new ObjectParamDefinition(var.getName());
        } else if (newType == ParamType.ARRAY) {
            ArrayParamDefinition arrayDef;
            ParamType itemType = LegacyMigrationHelper.convertType(var.getItemVarFieldType());
            if (itemType != ParamType.OBJECT) {
                BasicParamDefinition itemDef = new BasicParamDefinition("item", itemType);
                arrayDef = new ArrayParamDefinition(var.getName(), itemDef);
            } else {
                arrayDef = new ArrayParamDefinition(var.getName(), new ObjectParamDefinition("item"));
            }
            paramDef = arrayDef;
        } else {
            paramDef = new BasicParamDefinition(var.getName(), newType);
        }
        paramDef.setDescription(var.getDesc());
        if (var.isInput()) {
            paramDef.setDirection(ParamDirection.INPUT);
        } else {
            paramDef.setDirection(ParamDirection.OUTPUT);
            paramDef.setVisibility(ParamVisibility.PUBLIC);
        }
        if (var.isInput() && var.getValue() != null && !var.getValue().isEmpty()) {
            LegacyMigrationHelper.setConstantValue(paramDef, var.getValue(), oldType);
        }
        return paramDef;
    }

    public static ParamDefinition convertVarMapper(VarMapper mapper, ParamType defaultType) {
        String inVarName = mapper.getInVarName();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)inVarName)) {
            inVarName = "none";
        }
        BasicParamDefinition paramDef = new BasicParamDefinition(inVarName, defaultType);
        paramDef.setDirection(ParamDirection.INPUT);
        NodeParamPath path = new NodeParamPath();
        path.setNodeId(String.valueOf(mapper.getOutNodeId()));
        path.setOutputParamName(mapper.getOutVarName());
        paramDef.setReferencePath(path);
        return paramDef;
    }

    public static ParamType convertType(VarFieldType oldType) {
        switch (oldType) {
            case STRING: {
                return ParamType.STRING;
            }
            case INTEGER: {
                return ParamType.INTEGER;
            }
            case OBJECT: {
                return ParamType.OBJECT;
            }
            case ARRAY_STRING: {
                return ParamType.ARRAY;
            }
            case ARRAY_INTEGER: {
                return ParamType.ARRAY;
            }
            case ARRAY_OBJECT: {
                return ParamType.ARRAY;
            }
        }
        return ParamType.STRING;
    }

    public static VarFieldType getOldTypeFromParamDef(ParamDefinition paramDefinition) {
        if (paramDefinition == null) {
            return null;
        }
        ParamType newType = paramDefinition.getType();
        switch (newType) {
            case STRING: {
                return VarFieldType.STRING;
            }
            case INTEGER: {
                return VarFieldType.INTEGER;
            }
            case OBJECT: {
                return VarFieldType.OBJECT;
            }
            case ARRAY: {
                ArrayParamDefinition arrayParamDefinition = (ArrayParamDefinition)paramDefinition;
                ParamDefinition itemDefinition = arrayParamDefinition.getItemDefinition();
                ParamType itemDefinitionType = itemDefinition.getType();
                switch (itemDefinitionType) {
                    case STRING: {
                        return VarFieldType.ARRAY_STRING;
                    }
                    case INTEGER: {
                        return VarFieldType.ARRAY_INTEGER;
                    }
                    case OBJECT: {
                        return VarFieldType.ARRAY_OBJECT;
                    }
                }
                return VarFieldType.ARRAY_STRING;
            }
        }
        return VarFieldType.STRING;
    }

    public static ParamType getNewItemTypeFromOldListType(VarFieldType oldListType) {
        switch (oldListType) {
            case ARRAY_STRING: {
                return ParamType.STRING;
            }
            case ARRAY_INTEGER: {
                return ParamType.INTEGER;
            }
            case ARRAY_OBJECT: {
                return ParamType.OBJECT;
            }
        }
        throw new IllegalArgumentException("\u65e0\u6cd5\u89e3\u6790\u5217\u8868\u7c7b\u578b: " + oldListType.getType());
    }

    private static void setConstantValue(ParamDefinition paramDef, String value, VarFieldType oldType) {
        if (value == null || value.isEmpty()) {
            return;
        }
        try {
            switch (oldType) {
                case STRING: {
                    ((BasicParamDefinition)paramDef).setStringValue(value);
                    break;
                }
                case INTEGER: {
                    int intValue = Integer.parseInt(value);
                    ((BasicParamDefinition)paramDef).setIntegerValue(intValue);
                    break;
                }
                case ARRAY_STRING: {
                    List<Object> stringList = LegacyMigrationHelper.parseArray(value, false);
                    paramDef.setConstantValue(stringList);
                    break;
                }
                case ARRAY_INTEGER: {
                    List<Object> intList = LegacyMigrationHelper.parseArray(value, true);
                    paramDef.setConstantValue(intList);
                    break;
                }
                case ARRAY_OBJECT: {
                    List<Object> objList = LegacyMigrationHelper.parseObjectArray(value);
                    paramDef.setConstantValue(objList);
                }
            }
        }
        catch (Exception e) {
            System.err.println("\u8b66\u544a: \u65e0\u6cd5\u89e3\u6790\u53c2\u6570[" + paramDef.getName() + "]\u7684\u503c: " + e.getMessage());
        }
    }

    private static List<Object> parseArray(String arrayStr, boolean isInteger) {
        ArrayList<Object> result;
        block5: {
            result = new ArrayList();
            try {
                ObjectMapper mapper = new ObjectMapper();
                result = (List)mapper.readValue(arrayStr, List.class);
                if (!isInteger) break block5;
                for (int i = 0; i < result.size(); ++i) {
                    Object item = result.get(i);
                    if (item instanceof Number) continue;
                    result.set(i, Integer.parseInt(item.toString()));
                }
            }
            catch (Exception e) {
                String[] items;
                for (String item : items = arrayStr.split(",")) {
                    if (isInteger) {
                        result.add(Integer.parseInt(item.trim()));
                        continue;
                    }
                    result.add(item.trim());
                }
            }
        }
        return result;
    }

    private static List<Object> parseObjectArray(String arrayStr) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return (List)mapper.readValue(arrayStr, List.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u89e3\u6790\u5bf9\u8c61\u6570\u7ec4: " + e.getMessage(), e);
        }
    }

    public static void migrateNode(Action action) {
        ProcessNodeType nodeType = action.getNodeType();
        switch (nodeType) {
            case Start: {
                new MigrateStart((Start)action).migrateParams();
                break;
            }
            case End: {
                new MigrateEnd((End)action).migrateParams();
                break;
            }
            case Message: {
                new MigrateMessageAction((MessageAction)action).migrateParams();
                break;
            }
            case Repo: {
                new MigrateRepoAction((RepoAction)action).migrateParams();
                break;
            }
            case RepoReply: {
                new MigrateRepoReplyAction((RepoReplyAction)action).migrateParams();
                break;
            }
            case Loop: {
                new MigrateLoopAction((LoopAction)action).migrateParams();
                break;
            }
            case Parallel: {
                new MigrateParallelAction((ParallelAction)action).migrateParams();
                break;
            }
            case Llm: {
                new MigrateLLMAction((LLMAction)action).migrateParams();
                break;
            }
            case CusOption: 
            case PresetOption: {
                new MigrateJavaPluginAction((JavaPluginAction)action).migrateParams();
                break;
            }
            case AskUser: {
                new MigrateAskUserAction((AskUserAction)action).migrateParams();
                break;
            }
            case Code: {
                new MigrateCodeAction((CodeAction)action).migrateParams();
                break;
            }
            case Tool: {
                new MigrateToolAction((ToolAction)action).migrateParams();
            }
        }
        String inputParamGroup = action.getInputParamGroup();
        String outputParamGroup = action.getOutputParamGroup();
        action.setInputParamGroup(inputParamGroup);
        action.setOutputParamGroup(outputParamGroup);
        if (action.isBlockInnerNode()) {
            List<ParamDefinition> paramDefinitionList = action.getParamByDirection(ParamDirection.INPUT, ParamDirection.OUTPUT, ParamDirection.BOTH);
            paramDefinitionList.forEach(paramDefinition -> {
                if (!paramDefinition.isReference()) {
                    return;
                }
                String refParamName = paramDefinition.getReferencePath().getOutputParamName();
                String newParamName = LegacyMigrationHelper.migrateParamName(refParamName);
                if (!newParamName.equals(refParamName)) {
                    paramDefinition.getReferencePath().setOutputParamName(newParamName);
                }
            });
        }
    }

    public static String migrateParamName(String paramName) {
        if (StringUtils.isEmpty((CharSequence)paramName)) {
            return paramName;
        }
        if (paramName.endsWith("{{item}}")) {
            return paramName.replace(String.format(".%s", "{{item}}"), "[index]");
        }
        if (paramName.endsWith("{{index}}")) {
            return VariableBuilderFactory.getArrayItemIndexParamName();
        }
        return paramName;
    }
}

