/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.param.legacy.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.Var;
import kd.ai.gai.core.engine.flow.VarMapper;
import kd.ai.gai.core.enuz.MessageType;
import kd.ai.gai.core.flow.param.define.MessageParamDefinition;
import kd.ai.gai.core.flow.param.define.NodeParamPath;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.dimension.ParamSource;
import kd.ai.gai.core.flow.param.legacy.IMigrateAction;
import kd.ai.gai.core.flow.param.legacy.LegacyMigrationHelper;

public abstract class AbstractMigrateAction<T extends Action>
implements IMigrateAction {
    protected T action;

    public AbstractMigrateAction(T action) {
        this.action = action;
    }

    @Override
    public abstract void migrateParams();

    public T getAction() {
        return this.action;
    }

    public void setAction(T action) {
        this.action = action;
    }

    protected List<ParamDefinition> toParamDefinitionList(List<Var> varList, List<VarMapper> varMapperList) {
        if (varList == null) {
            varList = new ArrayList<Var>();
        }
        if (varMapperList == null) {
            varMapperList = new ArrayList<VarMapper>();
        }
        HashMap mapVarMapper = new HashMap(varMapperList.size());
        varMapperList.forEach(varMapper -> mapVarMapper.put(varMapper.getInVarName(), varMapper));
        ArrayList<ParamDefinition> paramDefinitionList = new ArrayList<ParamDefinition>(varList.size());
        for (Var var : varList) {
            paramDefinitionList.add(LegacyMigrationHelper.convert(var, (VarMapper)mapVarMapper.get(var.getName())));
        }
        return paramDefinitionList;
    }

    protected List<ParamDefinition> toMessageParamDefinitionList(List<Var> varList, List<VarMapper> varMapperList) {
        varList = varList == null ? Collections.emptyList() : varList;
        varMapperList = varMapperList == null ? Collections.emptyList() : varMapperList;
        Map<String, VarMapper> varMapperMap = varMapperList.stream().collect(Collectors.toMap(VarMapper::getInVarName, varMapper -> varMapper));
        ArrayList<ParamDefinition> paramDefList = new ArrayList<ParamDefinition>(varList.size());
        varList.forEach(var -> {
            MessageParamDefinition paramDefinition = new MessageParamDefinition(var.getName(), MessageType.parse(var.getType()));
            if (var.isInput()) {
                paramDefinition.setSource(ParamSource.CONSTANT);
                paramDefinition.setConstantValue(var.getValue());
            } else {
                paramDefinition.setSource(ParamSource.REFERENCE);
                VarMapper varMapper = (VarMapper)varMapperMap.get(var.getName());
                NodeParamPath path = new NodeParamPath();
                path.setNodeId(String.valueOf(varMapper.getOutNodeId()));
                path.setOutputParamName(varMapper.getOutVarName());
                paramDefinition.setReferencePath(path);
            }
            paramDefList.add(paramDefinition);
        });
        return paramDefList;
    }
}

