/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.param.legacy.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ai.gai.core.domain.dto.Prompt;
import kd.ai.gai.core.domain.dto.PromptInVar;
import kd.ai.gai.core.domain.dto.PromptOutVar;
import kd.ai.gai.core.engine.flow.LLMAction;
import kd.ai.gai.core.engine.flow.Var;
import kd.ai.gai.core.engine.flow.VarMapper;
import kd.ai.gai.core.enuz.PromptTemplateType;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.dimension.ParamDirection;
import kd.ai.gai.core.flow.param.dimension.ParamType;
import kd.ai.gai.core.flow.param.legacy.LegacyMigrationHelper;
import kd.ai.gai.core.flow.param.legacy.impl.AbstractMigrateAction;
import kd.ai.gai.core.service.PromptService;

public class MigrateLLMAction
extends AbstractMigrateAction<LLMAction> {
    public MigrateLLMAction(LLMAction action) {
        super(action);
    }

    @Override
    public void migrateParams() {
        int promptType = ((LLMAction)this.action).getPromptType();
        if (promptType == PromptTemplateType.CUSTOM_PROMPT.getCode()) {
            this.migrateCustomPromptParams();
        } else {
            this.migrateTemplatePromptParams();
        }
    }

    private void migrateTemplatePromptParams() {
        List<ParamDefinition> inputParamDefList = this.toParamDefinitionList(((LLMAction)this.action).getPromptTemplateContent().getInputVarList(), ((LLMAction)this.action).getInParamMap());
        inputParamDefList.forEach(paramDefinition -> paramDefinition.setDirection(ParamDirection.INPUT));
        ((LLMAction)this.action).setParams(((LLMAction)this.action).getInputParamGroup(), inputParamDefList);
        List<ParamDefinition> outputParamDefList = this.toParamDefinitionList(((LLMAction)this.action).getPromptTemplateContent().getOutputVarList(), new ArrayList<VarMapper>());
        outputParamDefList.forEach(paramDefinition -> paramDefinition.setDirection(ParamDirection.OUTPUT));
        ((LLMAction)this.action).setParams(((LLMAction)this.action).getOutputParamGroup(), outputParamDefList);
    }

    private void migrateCustomPromptParams() {
        VarMapper dynamicRepoMapper;
        ArrayList<ParamDefinition> defaulGroupParams = new ArrayList<ParamDefinition>(2);
        VarMapper userInputMapper = ((LLMAction)this.action).getUserInputMapper();
        if (userInputMapper != null) {
            userInputMapper.setInVarName("userInputMapper");
            ParamDefinition userInputParamDef = LegacyMigrationHelper.convertVarMapper(userInputMapper, ParamType.STRING);
            defaulGroupParams.add(userInputParamDef);
        }
        if ((dynamicRepoMapper = ((LLMAction)this.action).getRepoMapper()) != null) {
            dynamicRepoMapper.setInVarName("repoMapper");
            ParamDefinition dynamicRepoParamDef = LegacyMigrationHelper.convertVarMapper(dynamicRepoMapper, ParamType.STRING);
            defaulGroupParams.add(dynamicRepoParamDef);
        }
        ((LLMAction)this.action).setParams("DEFAULT_GROUP", defaulGroupParams);
        if (((LLMAction)this.action).getLlmPromptId() > 0L) {
            Prompt prompt = PromptService.getById(((LLMAction)this.action).getLlmPromptId());
            List<VarMapper> inParamMapperList = ((LLMAction)this.action).getInParamMap();
            Map<String, VarMapper> mapVarMapper = inParamMapperList.stream().collect(Collectors.toMap(VarMapper::getInVarName, v -> v));
            List<PromptInVar> promptInVarList = prompt.getPromptInVarList();
            for (PromptInVar promptInVar : promptInVarList) {
                ParamDefinition paramDef = LegacyMigrationHelper.convert(new Var(promptInVar.getVar(), promptInVar.getType(), promptInVar.getName()), mapVarMapper.get(promptInVar.getVar()));
                paramDef.setDirection(ParamDirection.INPUT);
                ((LLMAction)this.action).addParam(((LLMAction)this.action).getInputParamGroup(), paramDef);
            }
            List<PromptOutVar> outVarList = prompt.getPromptOutVarList();
            outVarList.forEach(promptOutVar -> {
                String paramName = promptOutVar.getVar();
                String paramType = promptOutVar.getType();
                Var var = new Var(paramName, paramType, promptOutVar.getName());
                ParamDefinition paramDef = LegacyMigrationHelper.convertVar(var);
                paramDef.setDirection(ParamDirection.OUTPUT);
                ((LLMAction)this.action).addParam(((LLMAction)this.action).getOutputParamGroup(), paramDef);
            });
        }
    }
}

