/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.runtime;

import java.util.function.Supplier;
import kd.bos.dlock.DLock;

public class FlowRuntimeLock {
    private FlowRuntimeLock() {
    }

    private static DLock getFlowRuntimeLock(String chatSessionId, long flowId) {
        return DLock.create((String)String.format("GaiFlowRuntimeLock-%s-%s", chatSessionId, flowId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T invokeWithLock(String chatSessionId, long flowId, Supplier<T> function) {
        DLock flowRuntimeLock = FlowRuntimeLock.getFlowRuntimeLock(chatSessionId, flowId);
        flowRuntimeLock.lock();
        try {
            T t = function.get();
            return t;
        }
        finally {
            flowRuntimeLock.unlock();
            flowRuntimeLock.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeWithLock(String chatSessionId, long flowId, Runnable runnable) {
        DLock flowRuntimeLock = FlowRuntimeLock.getFlowRuntimeLock(chatSessionId, flowId);
        flowRuntimeLock.lock();
        try {
            runnable.run();
        }
        finally {
            flowRuntimeLock.unlock();
            flowRuntimeLock.close();
        }
    }
}

