/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.template;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.util.DynamicObjectUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class FlowTemplate {
    private String id;
    private String name;
    private String desc;
    private String content;
    private String validateContent;
    private List<String> operationContents;
    private List<Map<String, String>> validateContents;
    private boolean preset;

    public FlowTemplate(boolean preset, String id, String name, String desc, String content) {
        this.preset = preset;
        this.id = id;
        this.name = name;
        this.desc = desc;
        this.content = content;
    }

    public List<Map<String, String>> getValidateContents() {
        return this.validateContents;
    }

    public void setValidateContents(List<Map<String, String>> validateContents) {
        this.validateContents = validateContents;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public boolean isPreset() {
        return this.preset;
    }

    public void setPreset(boolean preset) {
        this.preset = preset;
    }

    public String getValidateContent() {
        return this.validateContent;
    }

    public void setValidateContent(String validateContent) {
        this.validateContent = validateContent;
    }

    public Flow getFlow() {
        return JsonUtil.fromBase64String(this.getContent());
    }

    public Map<Long, DynamicObject> getOperationMap() {
        List<String> listOperationContents = this.getOperationContents();
        HashMap<Long, DynamicObject> operationMap = new HashMap<Long, DynamicObject>(listOperationContents.size());
        DynamicObject dObj = BusinessDataServiceHelper.newDynamicObject((String)"gai_operation");
        listOperationContents.forEach(operationJsonContent -> {
            if (StringUtils.isNotEmpty((CharSequence)operationJsonContent)) {
                DynamicObject operation = DynamicObjectUtils.json2DynamicObject(operationJsonContent, dObj.getDynamicObjectType());
                operationMap.put(operation.getLong("id"), operation);
            }
        });
        return operationMap;
    }

    public List<String> getOperationContents() {
        if (this.operationContents == null) {
            this.operationContents = new ArrayList<String>();
        }
        return this.operationContents;
    }

    public void setOperationContents(List<String> operationContents) {
        this.operationContents = operationContents;
    }

    public void addOperationContent(String operationContent) {
        this.getOperationContents().add(operationContent);
    }
}

