/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.template;

import java.util.List;
import java.util.Optional;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.End;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.RecommendAction;
import kd.ai.gai.core.engine.flow.Start;
import kd.ai.gai.core.enuz.agent.EnableEnum;
import kd.ai.gai.core.enuz.agent.GaiFormIdEnum;
import kd.ai.gai.core.flow.template.FlowTemplate;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowTemplateFactory {
    private static final Logger log = LoggerFactory.getLogger(FlowTemplateFactory.class);

    public static DynamicObject[] getFlowTemplateList() {
        QFilter enableFilter = new QFilter("enable", "=", (Object)String.valueOf(EnableEnum.YES.getKey()));
        return BusinessDataServiceHelper.load((String)GaiFormIdEnum.GAI_PROCESS_TEMPLATE.getId(), (String)"id,name,number,servicedesc,group,ispreset", (QFilter[])new QFilter[]{enableFilter}, (String)"group");
    }

    public static Optional<FlowTemplate> getTemplateById(Long id) {
        DynamicObject templateDO;
        try {
            templateDO = BusinessDataServiceHelper.loadSingle((Object)id, (String)GaiFormIdEnum.GAI_PROCESS_TEMPLATE.getId());
            if (templateDO == null) {
                return Optional.empty();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
        String pkValue = String.valueOf(templateDO.getPkValue());
        Boolean preset = templateDO.getBoolean("ispreset");
        String name = templateDO.getString("name");
        String desc = templateDO.getString("servicedesc");
        String flow = templateDO.getString("flow");
        return Optional.of(new FlowTemplate(BooleanUtils.isTrue((Boolean)preset), pkValue, name, desc, flow));
    }

    public static int getNodeNumByTemplateId(FlowTemplate flowTemplate) {
        List<Action> actions;
        End end;
        int nodeNum = 0;
        if (flowTemplate == null) {
            return nodeNum;
        }
        Flow flow = flowTemplate.getFlow();
        if (flow == null) {
            return nodeNum;
        }
        Start start = flow.getStart();
        if (start != null) {
            ++nodeNum;
        }
        if ((end = flow.getEnd()) != null) {
            ++nodeNum;
        }
        if (CollectionUtils.isEmpty(actions = flow.getActions())) {
            return nodeNum;
        }
        for (Action action : actions) {
            if (action instanceof RecommendAction) continue;
            ++nodeNum;
        }
        return nodeNum;
    }
}

