/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.var;

import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.End;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.Start;
import kd.ai.gai.core.flow.node.ExecutionNodeType;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.execution.IParamManager;
import kd.ai.gai.core.flow.param.execution.ParamManagerFactory;
import kd.ai.gai.core.flow.var.NodeVariablesInfo;
import kd.ai.gai.flow.flow.core.Execution;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class FlowParamVariableExtractor {
    private static final Log log = LogFactory.getLog(FlowParamVariableExtractor.class);
    private static final IParamManager paramManager = ParamManagerFactory.createParamManager();

    public static Map<String, NodeVariablesInfo> extractAllNodeVariables(Execution e, Flow gaiFlow) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            if (gaiFlow.getStart() != null) {
                String startNodeId = String.valueOf(gaiFlow.getStart().getId());
                NodeVariablesInfo startInfo = FlowParamVariableExtractor.createStartNodeInfo(e, gaiFlow.getStart(), startNodeId);
                result.put(startNodeId, startInfo);
            }
            List<Action> actions = gaiFlow.getActions();
            for (Action action : actions) {
                String nodeId = String.valueOf(action.getId());
                NodeVariablesInfo nodeInfo = FlowParamVariableExtractor.createActionNodeInfo(e, action, nodeId);
                result.put(nodeId, nodeInfo);
            }
            if (gaiFlow.getEnd() != null) {
                String endNodeId = String.valueOf(gaiFlow.getEnd().getId());
                NodeVariablesInfo endInfo = FlowParamVariableExtractor.createEndNodeInfo(e, gaiFlow.getEnd(), endNodeId);
                result.put(endNodeId, endInfo);
            }
        }
        catch (Exception ex) {
            log.error("Failed to extract flow variables using unified approach", (Throwable)ex);
        }
        Map sortedResult = result.entrySet().stream().filter(entry -> ((NodeVariablesInfo)entry.getValue()).getNodeAt() != Integer.MAX_VALUE).sorted(Comparator.comparingInt(entry -> ((NodeVariablesInfo)entry.getValue()).getNodeAt())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        return sortedResult;
    }

    private static NodeVariablesInfo createStartNodeInfo(Execution e, Start start, String nodeId) {
        NodeVariablesInfo nodeInfo = new NodeVariablesInfo();
        nodeInfo.setNodeId(nodeId);
        nodeInfo.setNodeName("Start");
        nodeInfo.setExecutionNodeType(ExecutionNodeType.START);
        HashMap<String, NodeVariablesInfo.VariableInfo> variables = new HashMap<String, NodeVariablesInfo.VariableInfo>();
        for (ParamDefinition paramDef : start.getOutputParams()) {
            FlowParamVariableExtractor.addVariableInfo(e, start, variables, paramDef, true);
        }
        nodeInfo.setVariables(variables);
        Object nodeIdAt = e.getRuntime().getRootMemory().getProperty("NODE_ID_AT_" + nodeId);
        if (nodeIdAt != null) {
            nodeInfo.setNodeAt(Integer.parseInt(nodeIdAt.toString()));
        }
        return nodeInfo;
    }

    private static NodeVariablesInfo createActionNodeInfo(Execution e, Action action, String nodeId) {
        NodeVariablesInfo nodeInfo = new NodeVariablesInfo();
        nodeInfo.setNodeId(nodeId);
        ExecutionNodeType nodeType = ExecutionNodeType.fromDesignNode(action);
        nodeInfo.setExecutionNodeType(nodeType);
        nodeInfo.setNodeName(nodeType != null ? nodeType.getDesc() : action.getClass().getSimpleName());
        HashMap<String, NodeVariablesInfo.VariableInfo> variables = new HashMap<String, NodeVariablesInfo.VariableInfo>();
        try {
            List<ParamDefinition> inputParams = action.getInputParams();
            for (ParamDefinition paramDef : inputParams) {
                FlowParamVariableExtractor.addVariableInfo(e, action, variables, paramDef, true);
            }
            List<ParamDefinition> outputParams = action.getOutputParams();
            for (ParamDefinition paramDef : outputParams) {
                FlowParamVariableExtractor.addVariableInfo(e, action, variables, paramDef, false);
            }
        }
        catch (Exception ex) {
            log.warn("Failed to extract variables for node: " + nodeId, (Throwable)ex);
        }
        nodeInfo.setVariables(variables);
        Object nodeIdAt = e.getRuntime().getRootMemory().getProperty("NODE_ID_AT_" + nodeId);
        if (nodeIdAt != null) {
            nodeInfo.setNodeAt(Integer.parseInt(nodeIdAt.toString()));
        }
        return nodeInfo;
    }

    private static NodeVariablesInfo createEndNodeInfo(Execution e, End end, String nodeId) {
        NodeVariablesInfo nodeInfo = new NodeVariablesInfo();
        nodeInfo.setNodeId(nodeId);
        nodeInfo.setNodeName("End");
        nodeInfo.setExecutionNodeType(ExecutionNodeType.END);
        nodeInfo.setVariables(new HashMap<String, NodeVariablesInfo.VariableInfo>());
        HashMap<String, NodeVariablesInfo.VariableInfo> variables = new HashMap<String, NodeVariablesInfo.VariableInfo>();
        for (ParamDefinition paramDef : end.getOutputParams()) {
            FlowParamVariableExtractor.addVariableInfo(e, end, variables, paramDef, false);
        }
        nodeInfo.setVariables(variables);
        Object nodeIdAt = e.getRuntime().getRootMemory().getProperty("NODE_ID_AT_" + nodeId);
        if (nodeIdAt != null) {
            nodeInfo.setNodeAt(Integer.parseInt(nodeIdAt.toString()));
        }
        return nodeInfo;
    }

    private static void addVariableInfo(Execution e, Action action, Map<String, NodeVariablesInfo.VariableInfo> variables, ParamDefinition paramDef, boolean isInput) {
        NodeVariablesInfo.VariableInfo varInfo = new NodeVariablesInfo.VariableInfo();
        varInfo.setName(paramDef.getName());
        varInfo.setType(paramDef.getType() != null ? paramDef.getType().name() : "UNKNOWN");
        varInfo.setDesc(paramDef.getDescription());
        varInfo.setInput(isInput);
        try {
            Object value = paramManager.getParamValue(e, action, paramDef);
            varInfo.setValue(FlowParamVariableExtractor.convertToString(value));
        }
        catch (Exception ex) {
            log.debug("Failed to get value for param: " + paramDef.getName(), (Object)ex);
            varInfo.setValue("");
        }
        variables.put(paramDef.getName(), varInfo);
    }

    private static String convertToString(Object value) {
        if (value == null) {
            return "";
        }
        String str = value.toString();
        if (str.length() > 1000) {
            return str.substring(0, 997) + "...";
        }
        return str;
    }
}

