/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.var;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.AskUserAction;
import kd.ai.gai.core.engine.flow.CodeAction;
import kd.ai.gai.core.engine.flow.End;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.JavaPluginAction;
import kd.ai.gai.core.engine.flow.LLMAction;
import kd.ai.gai.core.engine.flow.LoopAction;
import kd.ai.gai.core.engine.flow.MessageAction;
import kd.ai.gai.core.engine.flow.ParallelAction;
import kd.ai.gai.core.engine.flow.RepoAction;
import kd.ai.gai.core.engine.flow.RepoReplyAction;
import kd.ai.gai.core.engine.flow.Start;
import kd.ai.gai.core.engine.flow.Var;
import kd.ai.gai.core.engine.flow.VarMapper;
import kd.ai.gai.core.enuz.PromptTemplateType;
import kd.ai.gai.core.enuz.agent.GaiFormIdEnum;
import kd.ai.gai.core.flow.node.ExecutionNodeType;
import kd.ai.gai.core.flow.var.NodeVariablesInfo;
import kd.ai.gai.core.util.FlowUtils;
import kd.ai.gai.flow.flow.core.Execution;
import kd.ai.gai.flow.flow.core.Node;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

class FlowVariableExtractor {
    private static final Log log = LogFactory.getLog(FlowVariableExtractor.class);
    private static final String CHAT_HISTORY = "system.chat_history";
    private static final String CHAT_SESSION = "system.chat_sessionid";
    private static final String USER_ATTACHMENTS = "system.user_attachments";
    private static final String USER_GAI_ATTACHMENTS_ID = "system.user_gai_attachments_id";
    private static final String USER_INPUT = "system.user_input";
    private static final String VAR_VALUE_PREFIX = "VAR_VALUE_";
    private static final String VAR_CONFIGS = "var_configs";
    private static final String VAR_NAME = "var_name";
    private static final String VAR_TYPE = "var_type";
    private static final String OUT_VAR_CONFIGS = "out_var_configs";
    private static final String OUT_VAR_NAME = "out_var_name";
    private static final String OUT_VAR = "out_var";
    private static final String OUT_VAR_TYPE = "out_var_type";
    private static final String KEY_ENTRYENTITY_INPUT = "input";
    private static final String KEY_ENTRYENTITY_OUTPUT = "output";
    private static final String KEY_INPUT_DESC = "input_desc";
    private static final String KEY_INPUT_NAME = "input_name";
    private static final String KEY_INPUT_TYPE = "input_type";
    private static final String KEY_OUTPUT_DESC = "output_desc";
    private static final String KEY_OUTPUT_NAME = "output_name";
    private static final String KEY_OUTPUT_TYPE = "output_type";

    private FlowVariableExtractor() {
    }

    public static Map<String, NodeVariablesInfo> extractAllNodeVariables(Execution e, Flow gaiFlow) {
        HashMap<String, NodeVariablesInfo> result = new HashMap<String, NodeVariablesInfo>();
        Map<String, Object> properties = FlowUtils.getMemoryProperties(e);
        Map nodeMap = e.getMemory().getFlow().getNodes();
        Map<String, Action> actionsByNodeId = gaiFlow.getActions().stream().collect(Collectors.toMap(action -> "" + action.getId(), x -> x));
        String startNodeId = "" + gaiFlow.getStart().getId();
        NodeVariablesInfo startNodeInfo = FlowVariableExtractor.buildNodeInfo(properties, gaiFlow.getStart(), startNodeId, ExecutionNodeType.START);
        result.put(startNodeId, startNodeInfo);
        for (Map.Entry entry3 : nodeMap.entrySet()) {
            String nodeId = (String)entry3.getKey();
            Node node = (Node)entry3.getValue();
            Action action2 = actionsByNodeId.get(nodeId);
            if (action2 == null) continue;
            ExecutionNodeType executionNodeType = ExecutionNodeType.fromDesignNode(action2, executionNodeTypes -> {
                if (action2 instanceof LLMAction) {
                    int promptType = ((LLMAction)action2).getPromptType();
                    if (promptType == 1) {
                        return ExecutionNodeType.LLM_QUESTION_CLASSIFY;
                    }
                    if (promptType == 2) {
                        return ExecutionNodeType.LLM_QUESTION_REWRITE;
                    }
                    return ExecutionNodeType.LLM;
                }
                return executionNodeTypes.stream().findFirst().orElse(null);
            });
            if (executionNodeType != null) {
                NodeVariablesInfo nodeInfo = FlowVariableExtractor.buildNodeInfo(properties, action2, nodeId, executionNodeType);
                result.putIfAbsent(nodeId, nodeInfo);
                continue;
            }
            String nodeName = node.getTitle();
            if (StringUtils.isBlank((CharSequence)nodeName)) {
                nodeName = "Node-" + nodeId;
            }
            log.warn("Could not determine ActionType for node: " + nodeName + ", nodeId: " + nodeId);
            NodeVariablesInfo nodeInfo = FlowVariableExtractor.buildNodeInfo(properties, action2, nodeId, null);
            result.putIfAbsent(nodeId, nodeInfo);
        }
        ArrayList<String> propKeys = new ArrayList<String>(properties.keySet());
        Map sortedResult = result.entrySet().stream().filter(entry -> {
            Collection<NodeVariablesInfo.VariableInfo> varInfoList = ((NodeVariablesInfo)entry.getValue()).getVariables().values();
            for (NodeVariablesInfo.VariableInfo variableInfo : varInfoList) {
                if (!propKeys.contains(variableInfo.getValueKey())) continue;
                return true;
            }
            return false;
        }).sorted((entry1, entry2) -> {
            Collection<NodeVariablesInfo.VariableInfo> varInfoList1 = ((NodeVariablesInfo)entry1.getValue()).getVariables().values();
            Collection<NodeVariablesInfo.VariableInfo> varInfoList2 = ((NodeVariablesInfo)entry2.getValue()).getVariables().values();
            int index1 = varInfoList1.stream().filter(variableInfo -> propKeys.contains(variableInfo.getValueKey())).findFirst().map(variableInfo -> propKeys.indexOf(variableInfo.getValueKey())).orElse(Integer.MAX_VALUE);
            int index2 = varInfoList2.stream().filter(variableInfo -> propKeys.contains(variableInfo.getValueKey())).findFirst().map(variableInfo -> propKeys.indexOf(variableInfo.getValueKey())).orElse(Integer.MAX_VALUE);
            return Integer.compare(index1, index2);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        return sortedResult;
    }

    private static NodeVariablesInfo buildNodeInfo(Map<String, Object> properties, Action action, String nodeId, ExecutionNodeType executionNodeType) {
        NodeVariablesInfo nodeInfo = new NodeVariablesInfo();
        nodeInfo.setNodeId(nodeId);
        nodeInfo.setExecutionNodeType(executionNodeType);
        if (executionNodeType != null) {
            nodeInfo.setNodeName(executionNodeType.getDesc());
        } else if (action != null) {
            nodeInfo.setNodeName(action.getClass().getSimpleName());
        } else {
            nodeInfo.setNodeName("Unknown-" + nodeId);
        }
        List<Var> varList = FlowVariableExtractor.extractNodeVars(nodeInfo.getNodeName(), action);
        if (CollectionUtils.isNotEmpty(varList)) {
            HashMap<String, NodeVariablesInfo.VariableInfo> variableInfoMap = new HashMap<String, NodeVariablesInfo.VariableInfo>(varList.size());
            for (Var var : varList) {
                String varName = var.getName();
                String varType = var.getType();
                String valueKey = VAR_VALUE_PREFIX + nodeId + "." + varName;
                Object valueObj = properties.get(valueKey);
                String value = valueObj != null ? valueObj.toString() : "";
                NodeVariablesInfo.VariableInfo varInfo = new NodeVariablesInfo.VariableInfo();
                varInfo.setName(varName);
                varInfo.setType(varType);
                varInfo.setValue(value);
                varInfo.setDesc(var.getDesc());
                varInfo.setInput(var.isInput());
                varInfo.setValueKey(valueKey);
                variableInfoMap.put(varName, varInfo);
            }
            nodeInfo.setVariables(variableInfoMap);
        }
        return nodeInfo;
    }

    private static List<Var> extractNodeVars(String nodeName, Action action) {
        ArrayList<Var> varList = new ArrayList<Var>();
        try {
            if (action == null) {
                return varList;
            }
            if (action instanceof LLMAction) {
                LLMAction llmAction = (LLMAction)action;
                varList.addAll(FlowVariableExtractor.extractLLMActionVars(llmAction));
            } else if (action instanceof JavaPluginAction) {
                JavaPluginAction javaPluginAction = (JavaPluginAction)action;
                varList.addAll(FlowVariableExtractor.extractJavaPluginActionVars(javaPluginAction));
            } else if (action instanceof MessageAction) {
                MessageAction messageAction = (MessageAction)action;
                FlowVariableExtractor.markInputVars(messageAction.getVarList(), true);
                varList.addAll(CollectionUtils.emptyIfNull(messageAction.getVarList()));
            } else if (action instanceof AskUserAction) {
                AskUserAction askUserAction = (AskUserAction)action;
                FlowVariableExtractor.markInputVars(askUserAction.getVarList(), true);
                varList.addAll(CollectionUtils.emptyIfNull(askUserAction.getVarList()));
                FlowVariableExtractor.markInputVars(askUserAction.getOutputVarList(), false);
                varList.addAll(CollectionUtils.emptyIfNull(askUserAction.getOutputVarList()));
            } else if (action instanceof RepoAction) {
                RepoAction repoAction = (RepoAction)action;
                FlowVariableExtractor.markInputVars(repoAction.getVarList(), true);
                varList.addAll(CollectionUtils.emptyIfNull(repoAction.getVarList()));
                FlowVariableExtractor.markInputVars(repoAction.getOutputVarList(), false);
                varList.addAll(CollectionUtils.emptyIfNull(repoAction.getOutputVarList()));
            } else if (action instanceof RepoReplyAction) {
                RepoReplyAction repoReplyAction = (RepoReplyAction)action;
                FlowVariableExtractor.markInputVars(repoReplyAction.getVarList(), true);
                varList.addAll(CollectionUtils.emptyIfNull(repoReplyAction.getVarList()));
                FlowVariableExtractor.markInputVars(repoReplyAction.getOutputVarList(), false);
                varList.addAll(CollectionUtils.emptyIfNull(repoReplyAction.getOutputVarList()));
            } else if (action instanceof LoopAction) {
                LoopAction loopAction = (LoopAction)action;
                FlowVariableExtractor.markInputVars(loopAction.getLoopVarList(), true);
                varList.addAll(CollectionUtils.emptyIfNull(loopAction.getLoopVarList()));
                FlowVariableExtractor.markInputVars(loopAction.getVarList(), true);
                varList.addAll(CollectionUtils.emptyIfNull(loopAction.getVarList()));
                FlowVariableExtractor.markInputVars(loopAction.getOutputVars(), false);
                varList.addAll(CollectionUtils.emptyIfNull(loopAction.getOutputVars()));
            } else if (action instanceof CodeAction) {
                CodeAction codeAction = (CodeAction)action;
                FlowVariableExtractor.markInputVars(codeAction.getVarList(), true);
                varList.addAll(CollectionUtils.emptyIfNull(codeAction.getVarList()));
                FlowVariableExtractor.markInputVars(codeAction.getOutputVarList(), false);
                varList.addAll(CollectionUtils.emptyIfNull(codeAction.getOutputVarList()));
            } else if (action instanceof ParallelAction) {
                ParallelAction parallelAction = (ParallelAction)action;
                FlowVariableExtractor.markInputVars(parallelAction.getLoopVarList(), true);
                varList.addAll(CollectionUtils.emptyIfNull(parallelAction.getLoopVarList()));
                FlowVariableExtractor.markInputVars(parallelAction.getVarList(), true);
                varList.addAll(CollectionUtils.emptyIfNull(parallelAction.getVarList()));
                FlowVariableExtractor.markInputVars(parallelAction.getOutputVars(), false);
                varList.addAll(CollectionUtils.emptyIfNull(parallelAction.getOutputVars()));
            } else if (action instanceof End) {
                End end = (End)action;
                List<VarMapper> outParamMap = end.getOutParamMap();
                if (outParamMap != null) {
                    for (VarMapper mapper : outParamMap) {
                        Var var = new Var();
                        var.setName(mapper.getInVarName());
                        var.setInput(false);
                        varList.add(var);
                    }
                }
            } else if (action instanceof Start) {
                Var userInput = new Var();
                userInput.setName(USER_INPUT);
                userInput.setInput(true);
                varList.add(userInput);
                Var chatHistory = new Var();
                chatHistory.setName(CHAT_HISTORY);
                chatHistory.setInput(true);
                varList.add(chatHistory);
                Var chatSessionId = new Var();
                chatSessionId.setName(CHAT_SESSION);
                chatSessionId.setInput(true);
                varList.add(chatSessionId);
                Var userAttachments = new Var();
                userAttachments.setName(USER_ATTACHMENTS);
                userAttachments.setInput(true);
                varList.add(userAttachments);
                Var userGaiIdAttachments = new Var();
                userGaiIdAttachments.setName(USER_GAI_ATTACHMENTS_ID);
                userGaiIdAttachments.setInput(true);
                varList.add(userGaiIdAttachments);
            }
        }
        catch (Exception e) {
            log.error("Failed to extract vars from node: " + nodeName, (Throwable)e);
        }
        return varList;
    }

    private static void markInputVars(List<Var> varList, boolean isInput) {
        if (CollectionUtils.isNotEmpty(varList)) {
            for (Var var : varList) {
                var.setInput(isInput);
            }
        }
    }

    private static List<Var> extractLLMActionVars(LLMAction llmAction) {
        ArrayList<Var> varList = new ArrayList<Var>();
        try {
            int promptType = llmAction.getPromptType();
            if (promptType == PromptTemplateType.CUSTOM_PROMPT.getCode()) {
                DynamicObject prompt = BusinessDataServiceHelper.loadSingleFromCache((Object)llmAction.getLlmPromptId(), (String)GaiFormIdEnum.GAI_PROMPT.getId());
                if (prompt != null) {
                    DynamicObjectCollection outputs;
                    DynamicObjectCollection inputs = prompt.getDynamicObjectCollection(VAR_CONFIGS);
                    if (inputs != null) {
                        for (Iterator input : inputs) {
                            Var var = new Var();
                            var.setName(input.getString(VAR_NAME));
                            var.setType(input.getString(VAR_TYPE));
                            var.setInput(true);
                            varList.add(var);
                        }
                    }
                    if ((outputs = prompt.getDynamicObjectCollection(OUT_VAR_CONFIGS)) != null) {
                        for (DynamicObject output : outputs) {
                            Var var = new Var();
                            var.setName(output.getString(OUT_VAR));
                            var.setType(output.getString(OUT_VAR_TYPE));
                            var.setInput(false);
                            varList.add(var);
                        }
                    }
                }
            } else if (llmAction.getPromptTemplateContent() != null) {
                List<Var> outputVarList;
                List<Var> inputVarList = llmAction.getPromptTemplateContent().getInputVarList();
                if (inputVarList != null) {
                    for (Var var : inputVarList) {
                        var.setInput(true);
                        varList.add(var);
                    }
                }
                if ((outputVarList = llmAction.getPromptTemplateContent().getOutputVarList()) != null) {
                    for (Var var : outputVarList) {
                        var.setInput(false);
                        varList.add(var);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("Failed to extract vars from LLMAction", (Throwable)e);
        }
        return varList;
    }

    private static List<Var> extractJavaPluginActionVars(JavaPluginAction javaPluginAction) {
        ArrayList<Var> varList = new ArrayList<Var>();
        try {
            DynamicObject operation = BusinessDataServiceHelper.loadSingle((Object)javaPluginAction.getActionId(), (String)GaiFormIdEnum.GAI_OPERATION.getId());
            if (operation != null) {
                DynamicObjectCollection outputs;
                DynamicObjectCollection inputs = operation.getDynamicObjectCollection(KEY_ENTRYENTITY_INPUT);
                if (inputs != null) {
                    for (DynamicObject input : inputs) {
                        Var var = new Var();
                        var.setName(input.getString(KEY_INPUT_NAME));
                        var.setType(input.getString(KEY_INPUT_TYPE));
                        var.setDesc(input.getString(KEY_INPUT_DESC));
                        var.setInput(true);
                        varList.add(var);
                    }
                }
                if ((outputs = operation.getDynamicObjectCollection(KEY_ENTRYENTITY_OUTPUT)) != null) {
                    for (DynamicObject output : outputs) {
                        Var var = new Var();
                        var.setName(output.getString(KEY_OUTPUT_NAME));
                        var.setType(output.getString(KEY_OUTPUT_TYPE));
                        var.setDesc(output.getString(KEY_OUTPUT_DESC));
                        var.setInput(false);
                        varList.add(var);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("Failed to extract vars from JavaPluginAction", (Throwable)e);
        }
        return varList;
    }

    public static void logNodeVariablesInfo(Map<String, NodeVariablesInfo> nodeVariablesMap) {
        if (nodeVariablesMap == null || nodeVariablesMap.isEmpty()) {
            log.info("No node variables extracted.");
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Extracted node variables:\n");
        for (Map.Entry<String, NodeVariablesInfo> entry : nodeVariablesMap.entrySet()) {
            String nodeId = entry.getKey();
            NodeVariablesInfo info = entry.getValue();
            sb.append("Node ID: ").append(nodeId).append(", Name: ").append(info.getNodeName());
            if (info.getExecutionNodeType() != null) {
                sb.append(", Type: ").append(info.getExecutionNodeType().name()).append(" (").append(info.getExecutionNodeType().getType()).append(")");
            }
            sb.append("\n");
            Map<String, NodeVariablesInfo.VariableInfo> variables = info.getVariables();
            if (variables != null && !variables.isEmpty()) {
                sb.append("  Input Variables:\n");
                for (NodeVariablesInfo.VariableInfo var : variables.values()) {
                    if (!var.isInput()) continue;
                    sb.append("    ").append(var.getName()).append(" (").append(var.getType()).append(") = ").append(FlowVariableExtractor.truncateValue(var.getValue())).append("\n");
                }
                sb.append("  Output Variables:\n");
                for (NodeVariablesInfo.VariableInfo var : variables.values()) {
                    if (var.isInput()) continue;
                    sb.append("    ").append(var.getName()).append(" (").append(var.getType()).append(") = ").append(FlowVariableExtractor.truncateValue(var.getValue())).append("\n");
                }
            }
            sb.append("-----------------------------------\n");
        }
        log.info(sb.toString());
    }

    private static String truncateValue(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return "";
        }
        if (value.length() > 100) {
            return value.substring(0, 97) + "...";
        }
        return value;
    }

    public static String toJsonString(Map<Integer, NodeVariablesInfo> nodeVariablesMap) {
        return JSONObject.toJSONString(nodeVariablesMap);
    }
}

