/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.var;

import java.util.HashMap;
import java.util.Map;
import kd.ai.gai.core.flow.node.ExecutionNodeType;

public class NodeVariablesInfo {
    private String nodeId;
    private String nodeName;
    private ExecutionNodeType executionNodeType;
    private Map<String, VariableInfo> variables = new HashMap<String, VariableInfo>();
    private int nodeAt = Integer.MAX_VALUE;

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public ExecutionNodeType getExecutionNodeType() {
        return this.executionNodeType;
    }

    public void setExecutionNodeType(ExecutionNodeType executionNodeType) {
        this.executionNodeType = executionNodeType;
    }

    public int getNodeAt() {
        return this.nodeAt;
    }

    public void setNodeAt(int nodeAt) {
        this.nodeAt = nodeAt;
    }

    public Map<String, VariableInfo> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, VariableInfo> variables) {
        this.variables = variables;
    }

    public Map<String, String> getInputVars() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (VariableInfo var : this.variables.values()) {
            if (!var.isInput()) continue;
            result.put(var.getName(), var.getValue());
        }
        return result;
    }

    public Map<String, String> getOutputVars() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (VariableInfo var : this.variables.values()) {
            if (var.isInput()) continue;
            result.put(var.getName(), var.getValue());
        }
        return result;
    }

    public int calculateDataSize() {
        int size = 0;
        if (this.variables != null && !this.variables.isEmpty()) {
            for (VariableInfo var : this.variables.values()) {
                if (var == null || var.getValue() == null) continue;
                size += var.getValue().length();
            }
        }
        return size;
    }

    public static class VariableInfo {
        private String name;
        private String type;
        private String value;
        private String desc;
        private boolean isInput;
        private String valueKey;
        private int variableAt = Integer.MAX_VALUE;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public boolean isInput() {
            return this.isInput;
        }

        public void setInput(boolean input) {
            this.isInput = input;
        }

        public String getValueKey() {
            return this.valueKey;
        }

        public void setValueKey(String valueKey) {
            this.valueKey = valueKey;
        }

        public int getVariableAt() {
            return this.variableAt;
        }

        public void setVariableAt(int variableAt) {
            this.variableAt = variableAt;
        }
    }
}

