/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.var;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

class RedisFlowVariableCacheManager {
    private static final Log log = LogFactory.getLog(RedisFlowVariableCacheManager.class);
    private static final String FLOW_VAR_PREFIX = "flow:vars:";
    private static final int DEFAULT_MAX_HISTORY_SIZE = 100;
    private static final int DEFAULT_EXPIRATION_DAYS = 7;
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("flowvariables", new DistributeCacheHAPolicy(false, false));

    private RedisFlowVariableCacheManager() {
    }

    public static RedisFlowVariableCacheManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public boolean storeSessionVariables(String sessionId, String variableData) {
        return this.storeSessionVariables(sessionId, variableData, 100, 7);
    }

    public boolean storeSessionVariables(String sessionId, String variableData, int maxHistorySize, int expirationDays) {
        if (sessionId == null || sessionId.isEmpty() || variableData == null) {
            log.warn("Cannot store session variables: sessionId or data is null/empty");
            return false;
        }
        try {
            String key = this.generateKey(sessionId);
            try {
                JSONObject.parseObject((String)variableData);
            }
            catch (Exception e) {
                log.error("Invalid JSON format for session variables: " + e.getMessage());
                return false;
            }
            int length = cache.addList(key, new String[]{variableData}, expirationDays, TimeUnit.DAYS);
            if (length > maxHistorySize) {
                int elementsToRemove = length - maxHistorySize;
                cache.removeListObjects(key, 0, elementsToRemove);
                log.debug("Trimmed session variables history to " + maxHistorySize + " entries for session " + sessionId);
            }
            return true;
        }
        catch (Exception e) {
            log.error("Failed to store session variables for session " + sessionId, (Throwable)e);
            return false;
        }
    }

    public List<String> getTopNSessionVariables(String sessionId, int topN) {
        if (sessionId == null || sessionId.isEmpty() || topN <= 0) {
            log.warn("Invalid parameters for getTopNSessionVariables: sessionId=" + sessionId + ", topN=" + topN);
            return new ArrayList<String>();
        }
        try {
            String key = this.generateKey(sessionId);
            int listLength = cache.getListLength(key);
            if (listLength == 0) {
                return new ArrayList<String>();
            }
            int actualCount = Math.min(topN, listLength);
            int startIndex = listLength - actualCount;
            String[] elements = cache.getList(key, startIndex, actualCount);
            ArrayList<String> result = new ArrayList<String>();
            if (elements != null) {
                for (int i = elements.length - 1; i >= 0; --i) {
                    result.add(elements[i]);
                }
            }
            return result;
        }
        catch (Exception e) {
            log.error("Failed to retrieve session variables for session " + sessionId, (Throwable)e);
            return new ArrayList<String>();
        }
    }

    public List<String> getAllSessionVariables(String sessionId) {
        if (sessionId == null || sessionId.isEmpty()) {
            log.warn("Invalid sessionId for getAllSessionVariables: " + sessionId);
            return new ArrayList<String>();
        }
        try {
            String key = this.generateKey(sessionId);
            String[] elements = cache.getList(key);
            ArrayList<String> result = new ArrayList<String>();
            if (elements != null) {
                for (int i = elements.length - 1; i >= 0; --i) {
                    result.add(elements[i]);
                }
            }
            return result;
        }
        catch (Exception e) {
            log.error("Failed to retrieve all session variables for session " + sessionId, (Throwable)e);
            return new ArrayList<String>();
        }
    }

    public String getLatestSessionVariable(String sessionId) {
        if (sessionId == null || sessionId.isEmpty()) {
            log.warn("Invalid sessionId for getLatestSessionVariable: " + sessionId);
            return null;
        }
        try {
            String key = this.generateKey(sessionId);
            int length = cache.getListLength(key);
            if (length == 0) {
                return null;
            }
            return cache.getListObject(key, length - 1);
        }
        catch (Exception e) {
            log.error("Failed to retrieve latest session variable for session " + sessionId, (Throwable)e);
            return null;
        }
    }

    public String getSessionVariableAt(String sessionId, int index) {
        if (sessionId == null || sessionId.isEmpty() || index < 0) {
            log.warn("Invalid parameters for getSessionVariableAt: sessionId=" + sessionId + ", index=" + index);
            return null;
        }
        try {
            String key = this.generateKey(sessionId);
            int length = cache.getListLength(key);
            if (length == 0 || index >= length) {
                return null;
            }
            int actualIndex = length - index - 1;
            return cache.getListObject(key, actualIndex);
        }
        catch (Exception e) {
            log.error("Failed to retrieve session variable at index " + index + " for session " + sessionId, (Throwable)e);
            return null;
        }
    }

    public int getSessionHistoryLength(String sessionId) {
        if (sessionId == null || sessionId.isEmpty()) {
            log.warn("Invalid sessionId for getSessionHistoryLength: " + sessionId);
            return 0;
        }
        try {
            String key = this.generateKey(sessionId);
            return cache.getListLength(key);
        }
        catch (Exception e) {
            log.error("Failed to get history length for session " + sessionId, (Throwable)e);
            return 0;
        }
    }

    public boolean clearSessionVariables(String sessionId) {
        if (sessionId == null || sessionId.isEmpty()) {
            log.warn("Invalid sessionId for clearSessionVariables: " + sessionId);
            return false;
        }
        try {
            String key = this.generateKey(sessionId);
            cache.remove(key);
            return true;
        }
        catch (Exception e) {
            log.error("Failed to clear session variables for session " + sessionId, (Throwable)e);
            return false;
        }
    }

    private String generateKey(String sessionId) {
        String accountId = RequestContext.get().getAccountId();
        return accountId + ":" + FLOW_VAR_PREFIX + sessionId;
    }

    public boolean hasSessionVariables(String sessionId) {
        if (sessionId == null || sessionId.isEmpty()) {
            return false;
        }
        try {
            String key = this.generateKey(sessionId);
            return cache.getListLength(key) > 0;
        }
        catch (Exception e) {
            log.error("Failed to check session variables existence for session " + sessionId, (Throwable)e);
            return false;
        }
    }

    private static class SingletonHolder {
        private static final RedisFlowVariableCacheManager INSTANCE = new RedisFlowVariableCacheManager();

        private SingletonHolder() {
        }
    }
}

