/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.var;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.flow.node.ExecutionNodeType;
import kd.ai.gai.core.flow.var.FlowVariableExtractor;
import kd.ai.gai.core.flow.var.FlowVariableService;
import kd.ai.gai.core.flow.var.NodeVariablesInfo;
import kd.ai.gai.core.flow.var.RedisFlowVariableCacheManager;
import kd.ai.gai.flow.flow.core.Execution;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

class RedisFlowVariableService
implements FlowVariableService {
    private static final Log log = LogFactory.getLog(RedisFlowVariableService.class);
    private final RedisFlowVariableCacheManager cacheManager = RedisFlowVariableCacheManager.getInstance();

    public static RedisFlowVariableService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public boolean storeFlowVariables(String sessionId, Execution execution, Flow flow) {
        try {
            Map<String, NodeVariablesInfo> nodeVariablesMap = FlowVariableExtractor.extractAllNodeVariables(execution, flow);
            HashMap<String, Object> dataWithMetadata = new HashMap<String, Object>(1);
            dataWithMetadata.put("timestamp", System.currentTimeMillis());
            dataWithMetadata.put("nodeVariables", nodeVariablesMap);
            String jsonData = JSONObject.toJSONString(dataWithMetadata);
            return this.cacheManager.storeSessionVariables(sessionId, jsonData);
        }
        catch (Exception e) {
            log.error("Failed to store flow variables for session " + sessionId, (Throwable)e);
            return false;
        }
    }

    @Override
    public List<List<NodeVariablesInfo>> getRecentFlowVariables(String sessionId, int topN) {
        List<String> jsonDataList = this.cacheManager.getTopNSessionVariables(sessionId, topN);
        return this.parseVariablesToListFromJson(jsonDataList);
    }

    @Override
    public List<NodeVariablesInfo> getLatestFlowVariables(String sessionId) {
        String jsonData = this.cacheManager.getLatestSessionVariable(sessionId);
        if (jsonData == null) {
            return new ArrayList<NodeVariablesInfo>(1);
        }
        try {
            Map dataWithMetadata = (Map)JSONObject.parseObject((String)jsonData, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
            Map nodeVariablesObj = (Map)dataWithMetadata.get("nodeVariables");
            ArrayList<NodeVariablesInfo> result = new ArrayList<NodeVariablesInfo>(1);
            for (Map.Entry entry : nodeVariablesObj.entrySet()) {
                NodeVariablesInfo nodeInfo = (NodeVariablesInfo)JSONObject.parseObject((String)JSONObject.toJSONString(entry.getValue()), NodeVariablesInfo.class);
                result.add(nodeInfo);
            }
            return result;
        }
        catch (Exception e) {
            log.error("Failed to parse latest flow variables for session " + sessionId, (Throwable)e);
            return new ArrayList<NodeVariablesInfo>(1);
        }
    }

    @Override
    public List<NodeVariablesInfo> getLatestNodeVariablesByType(String sessionId, ExecutionNodeType executionNodeType) {
        List<NodeVariablesInfo> latestVars = this.getLatestFlowVariables(sessionId);
        return latestVars.stream().filter(nodeInfo -> nodeInfo.getExecutionNodeType() == executionNodeType).collect(Collectors.toList());
    }

    @Override
    public NodeVariablesInfo getLatestNodeVariablesById(String sessionId, String nodeId) {
        List<NodeVariablesInfo> latestVars = this.getLatestFlowVariables(sessionId);
        return latestVars.stream().filter(nodeInfo -> nodeInfo.getNodeId().equals(nodeId)).findFirst().orElse(null);
    }

    @Override
    public boolean clearSessionHistory(String sessionId) {
        return this.cacheManager.clearSessionVariables(sessionId);
    }

    @Override
    public boolean hasSessionVariables(String sessionId) {
        return this.cacheManager.hasSessionVariables(sessionId);
    }

    private List<List<NodeVariablesInfo>> parseVariablesToListFromJson(List<String> jsonDataList) {
        ArrayList<List<NodeVariablesInfo>> result = new ArrayList<List<NodeVariablesInfo>>(1);
        for (String jsonData : jsonDataList) {
            try {
                Map dataWithMetadata = (Map)JSONObject.parseObject((String)jsonData, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
                Map nodeVariablesObj = (Map)dataWithMetadata.get("nodeVariables");
                ArrayList<NodeVariablesInfo> roundVars = new ArrayList<NodeVariablesInfo>(1);
                for (Map.Entry entry : nodeVariablesObj.entrySet()) {
                    NodeVariablesInfo nodeInfo = (NodeVariablesInfo)JSONObject.parseObject((String)JSONObject.toJSONString(entry.getValue()), NodeVariablesInfo.class);
                    roundVars.add(nodeInfo);
                }
                result.add(roundVars);
            }
            catch (Exception e) {
                log.error("Failed to parse variables from JSON: " + e.getMessage());
            }
        }
        return result;
    }

    private static class SingletonHolder {
        private static final RedisFlowVariableService INSTANCE = new RedisFlowVariableService();

        private SingletonHolder() {
        }
    }
}

