/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.var;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.ai.gai.core.flow.var.NodeVariablesInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

class RedisOptimizedFlowVariableCacheManager {
    private static final Log log = LogFactory.getLog(RedisOptimizedFlowVariableCacheManager.class);
    private static final String SESSION_META_PREFIX = "ai:flow:meta:";
    private static final String ROUND_META_PREFIX = "ai:flow:round:";
    private static final String BATCH_DATA_PREFIX = "ai:flow:batch:";
    private static final int BATCH_SIZE_THRESHOLD = 1000;
    private static final int DEFAULT_MAX_HISTORY_SIZE = 10;
    private static final int DEFAULT_EXPIRATION_HOURS = 8;
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("flow-variables", new DistributeCacheHAPolicy(false, false));

    private RedisOptimizedFlowVariableCacheManager() {
    }

    public static RedisOptimizedFlowVariableCacheManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public boolean storeSessionVariables(String sessionId, Map<String, NodeVariablesInfo> roundData) {
        return this.storeSessionVariables(sessionId, roundData, 10, 8);
    }

    public boolean storeSessionVariables(String sessionId, Map<String, NodeVariablesInfo> roundData, int maxHistorySize, int expirationHours) {
        if (sessionId == null || sessionId.isEmpty() || roundData == null) {
            log.warn("Cannot store session variables: sessionId or data is null/empty");
            return false;
        }
        try {
            String roundId = sessionId + "_" + System.currentTimeMillis();
            String sessionMetaKey = this.generateSessionMetaKey(sessionId);
            Map<String, Object> sessionMeta = this.getSessionMeta(sessionId);
            if (sessionMeta == null) {
                sessionMeta = new HashMap<String, Object>();
                sessionMeta.put("sessionId", sessionId);
                sessionMeta.put("rounds", new ArrayList());
                sessionMeta.put("created", System.currentTimeMillis());
            }
            List rounds = (List)sessionMeta.get("rounds");
            while (rounds.size() >= maxHistorySize) {
                String oldestRoundId = (String)rounds.remove(0);
                this.deleteRound(oldestRoundId);
            }
            HashMap<String, Object> roundMeta = new HashMap<String, Object>();
            roundMeta.put("roundId", roundId);
            roundMeta.put("timestamp", System.currentTimeMillis());
            roundMeta.put("batches", new ArrayList());
            List batches = (List)roundMeta.get("batches");
            this.distributeDataToBatches(roundData, roundId, batches, expirationHours);
            String roundMetaKey = this.generateRoundMetaKey(roundId);
            cache.put(roundMetaKey, (Object)JSONObject.toJSONString(roundMeta), expirationHours, TimeUnit.HOURS);
            rounds.add(roundId);
            sessionMeta.put("updated", System.currentTimeMillis());
            cache.put(sessionMetaKey, (Object)JSONObject.toJSONString(sessionMeta), expirationHours, TimeUnit.HOURS);
            return true;
        }
        catch (Exception e) {
            log.error("Failed to store session variables for session " + sessionId, (Throwable)e);
            return false;
        }
    }

    public List<Map<String, NodeVariablesInfo>> getTopNSessionVariables(String sessionId, int topN) {
        if (sessionId == null || sessionId.isEmpty() || topN <= 0) {
            log.warn("Invalid parameters for getTopNSessionVariables: sessionId=" + sessionId + ", topN=" + topN);
            return new ArrayList<Map<String, NodeVariablesInfo>>();
        }
        try {
            Map<String, Object> sessionMeta = this.getSessionMeta(sessionId);
            if (sessionMeta == null) {
                return new ArrayList<Map<String, NodeVariablesInfo>>();
            }
            List rounds = (List)sessionMeta.get("rounds");
            if (rounds == null || rounds.isEmpty()) {
                return new ArrayList<Map<String, NodeVariablesInfo>>();
            }
            int start = Math.max(0, rounds.size() - topN);
            List recentRounds = rounds.subList(start, rounds.size());
            ArrayList<Map<String, NodeVariablesInfo>> result = new ArrayList<Map<String, NodeVariablesInfo>>();
            for (int i = recentRounds.size() - 1; i >= 0; --i) {
                String roundId = (String)recentRounds.get(i);
                Map<String, NodeVariablesInfo> roundData = this.getRoundData(roundId);
                if (roundData == null) continue;
                result.add(roundData);
            }
            return result;
        }
        catch (Exception e) {
            log.error("Failed to retrieve session variables for session " + sessionId, (Throwable)e);
            return new ArrayList<Map<String, NodeVariablesInfo>>();
        }
    }

    public Map<String, NodeVariablesInfo> getLatestSessionVariable(String sessionId) {
        if (sessionId == null || sessionId.isEmpty()) {
            log.warn("Invalid sessionId for getLatestSessionVariable: " + sessionId);
            return null;
        }
        try {
            Map<String, Object> sessionMeta = this.getSessionMeta(sessionId);
            if (sessionMeta == null) {
                return null;
            }
            List rounds = (List)sessionMeta.get("rounds");
            if (rounds == null || rounds.isEmpty()) {
                return null;
            }
            String latestRoundId = (String)rounds.get(rounds.size() - 1);
            return this.getRoundData(latestRoundId);
        }
        catch (Exception e) {
            log.error("Failed to retrieve latest session variable for session " + sessionId, (Throwable)e);
            return null;
        }
    }

    public boolean clearSessionVariables(String sessionId) {
        if (sessionId == null || sessionId.isEmpty()) {
            log.warn("Invalid sessionId for clearSessionVariables: " + sessionId);
            return false;
        }
        try {
            Map<String, Object> sessionMeta = this.getSessionMeta(sessionId);
            if (sessionMeta == null) {
                return true;
            }
            List rounds = (List)sessionMeta.get("rounds");
            if (rounds != null) {
                for (String roundId : rounds) {
                    this.deleteRound(roundId);
                }
            }
            String sessionMetaKey = this.generateSessionMetaKey(sessionId);
            cache.remove(sessionMetaKey);
            return true;
        }
        catch (Exception e) {
            log.error("Failed to clear session variables for session " + sessionId, (Throwable)e);
            return false;
        }
    }

    public int getSessionHistoryLength(String sessionId) {
        if (sessionId == null || sessionId.isEmpty()) {
            log.warn("Invalid sessionId for getSessionHistoryLength: " + sessionId);
            return 0;
        }
        try {
            Map<String, Object> sessionMeta = this.getSessionMeta(sessionId);
            if (sessionMeta == null) {
                return 0;
            }
            List rounds = (List)sessionMeta.get("rounds");
            return rounds != null ? rounds.size() : 0;
        }
        catch (Exception e) {
            log.error("Failed to get history length for session " + sessionId, (Throwable)e);
            return 0;
        }
    }

    public boolean hasSessionVariables(String sessionId) {
        if (sessionId == null || sessionId.isEmpty()) {
            return false;
        }
        try {
            String sessionMetaKey = this.generateSessionMetaKey(sessionId);
            return cache.get(sessionMetaKey) != null;
        }
        catch (Exception e) {
            log.error("Failed to check session variables existence for session " + sessionId, (Throwable)e);
            return false;
        }
    }

    private Map<String, Object> getSessionMeta(String sessionId) {
        String sessionMetaKey = this.generateSessionMetaKey(sessionId);
        String metaJson = (String)cache.get(sessionMetaKey);
        if (metaJson == null || metaJson.isEmpty()) {
            return null;
        }
        return (Map)JSONObject.parseObject((String)metaJson, Map.class);
    }

    private Map<String, NodeVariablesInfo> getRoundData(String roundId) {
        String roundMetaKey = this.generateRoundMetaKey(roundId);
        String metaJson = (String)cache.get(roundMetaKey);
        if (metaJson == null || metaJson.isEmpty()) {
            return null;
        }
        Map roundMeta = (Map)JSONObject.parseObject((String)metaJson, Map.class);
        List batches = (List)roundMeta.get("batches");
        if (batches == null || batches.isEmpty()) {
            return new HashMap<String, NodeVariablesInfo>();
        }
        LinkedHashMap<String, NodeVariablesInfo> result = new LinkedHashMap<String, NodeVariablesInfo>();
        for (String batchId : batches) {
            String batchKey = this.generateBatchKey(batchId);
            String batchJson = (String)cache.get(batchKey);
            if (batchJson == null || batchJson.isEmpty()) continue;
            Map batchData = (Map)JSONObject.parseObject((String)batchJson, (TypeReference)new TypeReference<LinkedHashMap<String, NodeVariablesInfo>>(){}, (Feature[])new Feature[]{Feature.OrderedField});
            result.putAll(batchData);
        }
        return result;
    }

    private void deleteRound(String roundId) {
        String roundMetaKey = this.generateRoundMetaKey(roundId);
        String metaJson = (String)cache.get(roundMetaKey);
        if (metaJson == null || metaJson.isEmpty()) {
            return;
        }
        Map roundMeta = (Map)JSONObject.parseObject((String)metaJson, Map.class);
        List batches = (List)roundMeta.get("batches");
        if (batches != null) {
            for (String batchId : batches) {
                String batchKey = this.generateBatchKey(batchId);
                cache.remove(batchKey);
            }
        }
        cache.remove(roundMetaKey);
    }

    private void distributeDataToBatches(Map<String, NodeVariablesInfo> nodeVariables, String roundId, List<String> batches, int expirationHours) {
        if (nodeVariables == null || nodeVariables.isEmpty()) {
            return;
        }
        Map<String, Integer> nodeSizes = this.calculateNodeSizes(nodeVariables);
        LinkedHashMap<String, Map<String, NodeVariablesInfo>> batchGroups = new LinkedHashMap<String, Map<String, NodeVariablesInfo>>(2);
        for (Map.Entry<String, NodeVariablesInfo> entry : nodeVariables.entrySet()) {
            String nodeId = entry.getKey();
            NodeVariablesInfo nodeData = entry.getValue();
            Integer nodeSize = nodeSizes.get(nodeId);
            if (nodeSize != null && nodeSize > 1000) {
                String batchId = roundId + "_batch_" + batches.size();
                HashMap<String, NodeVariablesInfo> batchData = new HashMap<String, NodeVariablesInfo>();
                batchData.put(nodeId, nodeData);
                String batchKey = this.generateBatchKey(batchId);
                cache.put(batchKey, (Object)JSONObject.toJSONString(batchData), expirationHours, TimeUnit.HOURS);
                batches.add(batchId);
                continue;
            }
            this.addNodeToBatchGroup(batchGroups, nodeId, nodeData, nodeSize != null ? nodeSize : 0);
        }
        for (Map.Entry<String, NodeVariablesInfo> entry : batchGroups.entrySet()) {
            String batchId = roundId + "_batch_" + batches.size();
            String batchKey = this.generateBatchKey(batchId);
            cache.put(batchKey, (Object)JSONObject.toJSONString((Object)entry.getValue()), expirationHours, TimeUnit.HOURS);
            batches.add(batchId);
        }
    }

    private Map<String, Integer> calculateNodeSizes(Map<String, NodeVariablesInfo> roundData) {
        HashMap<String, Integer> nodeSizes = new HashMap<String, Integer>(roundData.size());
        for (Map.Entry<String, NodeVariablesInfo> entry : roundData.entrySet()) {
            String nodeId = entry.getKey();
            NodeVariablesInfo nodeData = entry.getValue();
            nodeSizes.put(nodeId, nodeData.calculateDataSize());
        }
        return nodeSizes;
    }

    private void addNodeToBatchGroup(Map<String, Map<String, NodeVariablesInfo>> batchGroups, String nodeId, NodeVariablesInfo nodeData, int nodeSize) {
        for (Map<String, NodeVariablesInfo> group : batchGroups.values()) {
            int groupSize = group.values().stream().mapToInt(NodeVariablesInfo::calculateDataSize).sum();
            if (groupSize + nodeSize > 1000) continue;
            group.put(nodeId, nodeData);
            return;
        }
        String newGroupId = "group_" + batchGroups.size();
        LinkedHashMap<String, NodeVariablesInfo> newGroup = new LinkedHashMap<String, NodeVariablesInfo>();
        newGroup.put(nodeId, nodeData);
        batchGroups.put(newGroupId, newGroup);
    }

    private String generateSessionMetaKey(String sessionId) {
        String accountId = RequestContext.get().getAccountId();
        return accountId + ":" + SESSION_META_PREFIX + sessionId;
    }

    private String generateRoundMetaKey(String roundId) {
        String accountId = RequestContext.get().getAccountId();
        return accountId + ":" + ROUND_META_PREFIX + roundId;
    }

    private String generateBatchKey(String batchId) {
        String accountId = RequestContext.get().getAccountId();
        return accountId + ":" + BATCH_DATA_PREFIX + batchId;
    }

    private static class SingletonHolder {
        private static final RedisOptimizedFlowVariableCacheManager INSTANCE = new RedisOptimizedFlowVariableCacheManager();

        private SingletonHolder() {
        }
    }
}

