/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.var;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.flow.node.ExecutionNodeType;
import kd.ai.gai.core.flow.param.execution.ParamMode;
import kd.ai.gai.core.flow.var.FlowParamVariableExtractor;
import kd.ai.gai.core.flow.var.FlowVariableExtractor;
import kd.ai.gai.core.flow.var.FlowVariableService;
import kd.ai.gai.core.flow.var.NodeVariablesInfo;
import kd.ai.gai.core.flow.var.RedisOptimizedFlowVariableCacheManager;
import kd.ai.gai.flow.flow.core.Execution;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

class RedisOptimizedFlowVariableService
implements FlowVariableService {
    private static final Log log = LogFactory.getLog(RedisOptimizedFlowVariableService.class);
    private final RedisOptimizedFlowVariableCacheManager cacheManager = RedisOptimizedFlowVariableCacheManager.getInstance();

    public static RedisOptimizedFlowVariableService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public boolean storeFlowVariables(String sessionId, Execution execution, Flow flow) {
        try {
            Map<String, NodeVariablesInfo> nodeVariablesMap;
            if (ParamMode.VARIABLE.name().equals(flow.getParamMode())) {
                log.debug("Using unified parameter extraction for session: " + sessionId);
                nodeVariablesMap = FlowParamVariableExtractor.extractAllNodeVariables(execution, flow);
            } else {
                log.debug("Using legacy extraction for session: " + sessionId);
                nodeVariablesMap = FlowVariableExtractor.extractAllNodeVariables(execution, flow);
            }
            return this.cacheManager.storeSessionVariables(sessionId, nodeVariablesMap);
        }
        catch (Exception e) {
            log.error("Failed to store flow variables for session " + sessionId, (Throwable)e);
            return false;
        }
    }

    @Override
    public List<List<NodeVariablesInfo>> getRecentFlowVariables(String sessionId, int topN) {
        List<Map<String, NodeVariablesInfo>> mapResults = this.cacheManager.getTopNSessionVariables(sessionId, topN);
        return mapResults.stream().map(map -> new ArrayList(map.values())).collect(Collectors.toList());
    }

    @Override
    public List<NodeVariablesInfo> getLatestFlowVariables(String sessionId) {
        Map<String, NodeVariablesInfo> latestVars = this.cacheManager.getLatestSessionVariable(sessionId);
        return latestVars != null ? new ArrayList<NodeVariablesInfo>(latestVars.values()) : new ArrayList(1);
    }

    @Override
    public List<NodeVariablesInfo> getLatestNodeVariablesByType(String sessionId, ExecutionNodeType executionNodeType) {
        List<NodeVariablesInfo> latestVars = this.getLatestFlowVariables(sessionId);
        return latestVars.stream().filter(nodeInfo -> nodeInfo.getExecutionNodeType() == executionNodeType).collect(Collectors.toList());
    }

    @Override
    public NodeVariablesInfo getLatestNodeVariablesById(String sessionId, String nodeId) {
        List<NodeVariablesInfo> latestVars = this.getLatestFlowVariables(sessionId);
        return latestVars.stream().filter(nodeInfo -> nodeInfo.getNodeId().equals(nodeId)).findFirst().orElse(null);
    }

    @Override
    public boolean clearSessionHistory(String sessionId) {
        return this.cacheManager.clearSessionVariables(sessionId);
    }

    @Override
    public boolean hasSessionVariables(String sessionId) {
        return this.cacheManager.hasSessionVariables(sessionId);
    }

    private static class SingletonHolder {
        private static final RedisOptimizedFlowVariableService INSTANCE = new RedisOptimizedFlowVariableService();

        private SingletonHolder() {
        }
    }
}

