/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.vision;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.code.GaiErrorCode;
import kd.ai.gai.core.code.GaiExceptionUtil;
import kd.ai.gai.core.flow.vision.TransformService;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class IeTransformServiceImpl
implements TransformService {
    private static final Log logger = LogFactory.getLog(IeTransformServiceImpl.class);

    @Override
    public Map<String, Object> transform(String result, JSONObject bizJSONObj, String templateNumber) {
        JSONObject jsonObject;
        logger.info("\u4fe1\u606f\u63d0\u53d6\u7ed3\u679c\u8f6c\u6362\u5f00\u59cb...result:{},bizJSONObj:{}", (Object)result, (Object)(bizJSONObj != null ? bizJSONObj.toJSONString() : ""));
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((String)result) && (jsonObject = JSON.parseObject((String)result)) != null) {
            Integer code = jsonObject.getInteger("errorCode");
            if (code != 0) {
                throw new KDBizException(GaiExceptionUtil.buildErr(GaiErrorCode.VISION_FLOW_CVP_EXTRACT_ERROR), new Object[0]);
            }
            JSONObject data = jsonObject.getJSONObject("data");
            if (data != null && !data.isEmpty()) {
                String status = data.getString("status");
                if (!"success".equals(status)) {
                    return map;
                }
                JSONObject extractData = data.getJSONObject("extractData");
                JSONObject tieInfo = extractData.getJSONObject("tieInfo");
                JSONObject tieTableInfo = extractData.getJSONObject("tieTableInfo");
                JSONArray extractSeq = extractData.getJSONArray("extractSeq");
                JSONObject llmInfo = extractData.getJSONObject("llmInfo");
                JSONObject llmTableInfo = extractData.getJSONObject("llmTableInfo");
                JSONArray llmSeq = extractData.getJSONArray("llmSeq");
                Map<String, Object> templateMap = this.buildTemplateFields(tieInfo, tieTableInfo, llmInfo, llmTableInfo);
                logger.info("\u8f93\u51fa\u7684\u6a21\u7248\u7ed3\u6784\uff1a{}", (Object)JSON.toJSONString(templateMap));
                Map<String, Object> bizMap = this.buildBizFields(templateMap, bizJSONObj);
                logger.info("\u4e1a\u52a1\u5b57\u6bb5\u8f93\u51fa\u7ed3\u6784\uff1a{}", (Object)JSON.toJSONString(bizMap));
                map.put("templateOutput", templateMap);
                map.put("bizOutput", bizMap);
            }
        }
        logger.info("\u8f93\u51fa\u5185\u5bb9\uff1a{}", (Object)JSON.toJSONString(map));
        return map;
    }

    private Map<String, Object> buildBizFields(Map<String, Object> templateMap, JSONObject bizJSONObj) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        if (bizJSONObj != null) {
            JSONArray relateArr = bizJSONObj.getJSONArray("value");
            for (Object o : relateArr) {
                JSONObject jsonObject = JSON.parseObject((String)o.toString());
                for (Map.Entry jsonEntry : jsonObject.entrySet()) {
                    String templateKey = (String)jsonEntry.getKey();
                    Object bizKey = jsonEntry.getValue();
                    if (bizKey == null || StringUtils.isEmpty((String)bizKey.toString())) continue;
                    for (Map.Entry<String, Object> entry : templateMap.entrySet()) {
                        Object value = entry.getValue();
                        String key = entry.getKey();
                        if (!templateKey.equals(key) && !templateKey.contains(key)) continue;
                        if (templateKey.equals(key)) {
                            map.put(bizKey.toString(), value);
                            continue;
                        }
                        if (!templateKey.contains(key) || !templateKey.contains(".")) continue;
                        String[] split = templateKey.split("\\.");
                        String entryKey = split[0];
                        String fKey = split[1];
                        if (!entryKey.equals(key)) {
                            logger.warn("\u6a21\u7248key\u7ed3\u6784\u4e0d\u6b63\u786e\uff0c\u4e0d\u8fdb\u884c\u8d4b\u503c\uff0ckey:{},templteKey:{}", (Object)key, (Object)entryKey);
                            continue;
                        }
                        List jsonArray = (List)value;
                        ArrayList<String> list = new ArrayList<String>(16);
                        for (Object o1 : jsonArray) {
                            Map obj = (Map)o1;
                            Object o2 = obj.get(fKey);
                            if (o2 == null || StringUtils.isEmpty((String)o2.toString())) {
                                o2 = "";
                            }
                            list.add(o2.toString());
                        }
                        map.put(bizKey.toString(), list);
                    }
                }
            }
        }
        return map;
    }

    private Map<String, Object> buildTemplateFields(JSONObject tieInfo, JSONObject tieTableInfo, JSONObject llmInfo, JSONObject llmTableInfo) {
        Map<String, Object> llmTableFields;
        Map<String, Object> tableFields;
        Map<String, Object> llmCommonFields;
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        Map<String, Object> commonFields = this.getCommonFields(tieInfo);
        if (!commonFields.isEmpty()) {
            map.putAll(commonFields);
        }
        if (!(llmCommonFields = this.getCommonFields(llmInfo)).isEmpty()) {
            map.putAll(llmCommonFields);
        }
        if (!(tableFields = this.getTableFields(tieTableInfo)).isEmpty()) {
            map.putAll(tableFields);
        }
        if (!(llmTableFields = this.getTableFields(llmTableInfo)).isEmpty()) {
            map.putAll(llmTableFields);
        }
        return map;
    }

    private Map<String, Object> getTableFields(JSONObject tieTableInfo) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        if (tieTableInfo != null) {
            for (Map.Entry entry : tieTableInfo.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (value == null || JSON.parseArray((String)value.toString()).isEmpty()) {
                    map.put(key, new ArrayList(1));
                    continue;
                }
                ArrayList list = new ArrayList(16);
                JSONArray jsonArray = JSON.parseArray((String)value.toString());
                if (jsonArray != null && !jsonArray.isEmpty()) {
                    for (Object o : jsonArray) {
                        if (o == null) continue;
                        HashMap<String, String> map1 = new HashMap<String, String>(16);
                        JSONObject jsonObject = JSON.parseObject((String)o.toString());
                        for (Map.Entry keyMap : jsonObject.entrySet()) {
                            String fKey = (String)keyMap.getKey();
                            Object value1 = keyMap.getValue();
                            if (value1 != null) {
                                JSONObject jsonObject1 = JSON.parseObject((String)value1.toString());
                                String v = jsonObject1.getString("text");
                                map1.put(fKey, v);
                                continue;
                            }
                            map1.put(fKey, "");
                        }
                        list.add(map1);
                    }
                }
                map.put(key, list);
            }
        }
        return map;
    }

    private Map<String, Object> getCommonFields(JSONObject infoObj) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        if (infoObj != null) {
            for (Map.Entry entry : infoObj.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (value == null || JSON.parseArray((String)value.toString()).isEmpty()) {
                    map.put(key, "");
                    continue;
                }
                JSONArray jsonArray = JSON.parseArray((String)value.toString());
                Object o = jsonArray.get(0);
                if (o == null) continue;
                JSONObject firstData = JSON.parseObject((String)o.toString());
                String text = firstData.getString("text");
                map.put(key, text);
            }
        }
        return map;
    }
}

