/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.vision;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.ai.gai.core.code.GaiErrorCode;
import kd.ai.gai.core.code.GaiExceptionUtil;
import kd.ai.gai.core.domain.dto.vision.PresetTransformEnum;
import kd.ai.gai.core.flow.vision.TransformService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class PresetTransformServiceImpl
implements TransformService {
    private Log logger = LogFactory.getLog(PresetTransformServiceImpl.class);

    @Override
    public Map<String, Object> transform(String result, JSONObject bizJSONObj, String templateNumber) {
        this.logger.info("\u9884\u7f6e\u6a21\u677f\u7ed3\u679c\u8f6c\u6362\u5f00\u59cb...\uff0cdata:{}, bizJson:{} , templateNumber:{}", new Object[]{result, bizJSONObj, templateNumber});
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((String)result)) {
            JSONObject parseJson = new JSONObject();
            JSONObject resultJson = JSON.parseObject((String)result);
            JSONObject dataObject = resultJson.getJSONObject("data");
            for (Object key : dataObject.keySet()) {
                Object value = dataObject.get(key);
                if (value instanceof JSONArray) continue;
                parseJson.put((String)key, value);
            }
            HashMap<String, JSONObject> rowMap = new HashMap<String, JSONObject>();
            for (String key : dataObject.keySet()) {
                Object value = dataObject.get((Object)key);
                if (!(value instanceof JSONArray)) continue;
                JSONArray array = (JSONArray)value;
                for (Object item : array) {
                    JSONObject itemObj = (JSONObject)item;
                    String row = itemObj.getString("row");
                    String word = itemObj.getString("word");
                    JSONObject rowData = rowMap.computeIfAbsent(row, k -> new JSONObject());
                    rowData.put(key, (Object)word);
                }
            }
            JSONArray entryEntity = new JSONArray();
            rowMap.values().forEach(arg_0 -> ((JSONArray)entryEntity).add(arg_0));
            parseJson.put("entryentity", (Object)entryEntity);
            resultMap.put("templateOutput", parseJson);
            JSONObject bizJSON = this.businessDataParse(result, bizJSONObj);
            resultMap.put("bizOutput", bizJSON);
        }
        this.logger.info("\u9884\u7f6e\u6a21\u677f\u7ed3\u679c\u8f6c\u6362...\uff0cresult:{}", (Object)JSON.toJSONString(resultMap));
        return resultMap;
    }

    private JSONObject businessDataParse(String result, JSONObject bizMapperJSONObj) {
        JSONObject businessJSON = new JSONObject();
        JSONObject resultJSON = new JSONObject();
        if (StringUtils.isNotEmpty((String)result)) {
            resultJSON = JSON.parseObject((String)result);
        }
        JSONObject resultData = resultJSON.getJSONObject("data");
        JSONArray fieldMappingArray = bizMapperJSONObj.getJSONArray("value");
        for (int i = 0; i < fieldMappingArray.size(); ++i) {
            JSONObject fieldMapping = fieldMappingArray.getJSONObject(i);
            Set keys = fieldMapping.keySet();
            for (String describe : keys) {
                String templateKey = PresetTransformEnum.getCodeByDescription(describe);
                if (templateKey == null) continue;
                Object templateValue = resultData.get((Object)templateKey);
                String bizKey = fieldMapping.getString(describe);
                businessJSON.put(bizKey, templateValue);
            }
        }
        return businessJSON;
    }

    private JSONObject formatBillData(String splitKey, Object templateValue) {
        String[] splitKeys = splitKey.split("\\.");
        JSONObject formatJSON = new JSONObject();
        return PresetTransformServiceImpl.buildMapHelper(splitKeys, 0, templateValue);
    }

    private static JSONObject buildMapHelper(String[] keys, int index, Object value) {
        if (index == keys.length - 1) {
            JSONObject leaf = new JSONObject();
            leaf.put(keys[index], value);
            return leaf;
        }
        JSONObject node = new JSONObject();
        node.put(keys[index], (Object)PresetTransformServiceImpl.buildMapHelper(keys, index + 1, value));
        return node;
    }

    private Map<String, Object> buildPresetKeyValueMap(String result, String templateId, JSONObject bizJSONObj) {
        String templateNumber;
        Map<String, Object> map = new HashMap<String, Object>(16);
        DynamicObject templateObj = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(templateId), (String)"cvp_template", (String)"id,number");
        if (templateObj == null) {
            throw new KDBizException(GaiExceptionUtil.buildErr(GaiErrorCode.VISION_FLOW_CVP_TEMPLATE_NOT_EXIST), new Object[0]);
        }
        switch (templateNumber = templateObj.getString("number")) {
            case "OPM-PaymentRecord": 
            case "OPM-DrivingLicenseFront": 
            case "OPM-Passport": 
            case "OPM-IdCardBack": 
            case "OPM-IDCardFront": 
            case "OPM-BankCard": 
            case "OPM-CertificateOfDegree": 
            case "OPM-CertificateOfResignation": 
            case "OPM-Diploma": {
                map = this.buildKeyValuePairForCommonTemplate(result);
                break;
            }
            case "OPM-Invoice": {
                map = this.buildKeyValuePairForInvoice(result);
                break;
            }
            case "OPM-GeneralSpotting": {
                map = this.buildKeyValuePairForGS(result);
                break;
            }
            case "OPM-BankReceipt": {
                map = this.buildKeyValuePairForBR(result);
                break;
            }
        }
        return map;
    }

    private Map<String, Object> buildKeyValuePairForBR(String result) {
        return null;
    }

    private Map<String, Object> buildKeyValuePairForGS(String result) {
        return null;
    }

    private Map<String, Object> buildKeyValuePairForInvoice(String result) {
        return null;
    }

    private Map<String, Object> buildKeyValuePairForCommonTemplate(String result) {
        return null;
    }
}

