/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.helper;

import kd.ai.gai.core.code.GaiErrorCode;
import kd.ai.gai.core.code.GaiExceptionUtil;
import kd.ai.gai.core.util.AgentAppParamsUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class GptPrivacyHelper {
    public static boolean isTenantAgree(String tenantId) {
        QFilter filter = new QFilter("tenantid", "=", (Object)tenantId);
        DynamicObjectCollection agreements = QueryServiceHelper.query((String)"gai_tenant_agreement", (String)"isagree", (QFilter[])new QFilter[]{filter}, (String)"agreetime desc,agreetimestamp desc", (int)1);
        if (agreements.isEmpty()) {
            return false;
        }
        return ((DynamicObject)agreements.get(0)).getBoolean("isagree");
    }

    public static boolean isUserAgree(Long userId) {
        if (AgentAppParamsUtils.privacyAgreementNotSign()) {
            return true;
        }
        return GptPrivacyHelper.isUserAgreeNew(userId);
    }

    public static void checkCurrUserPrivacy() {
        boolean tenantAgree = GptPrivacyHelper.isTenantAgree(RequestContext.get().getTenantId());
        if (tenantAgree) {
            boolean userAgree = GptPrivacyHelper.isUserAgree(RequestContext.get().getCurrUserId());
            if (userAgree) {
                return;
            }
            GaiExceptionUtil.throwGaiException(GaiErrorCode.PRIVACY_USER_ERR);
        } else {
            GaiExceptionUtil.throwGaiException(GaiErrorCode.PRIVACY_TENANTE_ERR);
        }
    }

    public static boolean isUserAgreeNew(Long userId) {
        QFilter userFilter = new QFilter("user", "=", (Object)userId);
        DynamicObjectCollection agreements = QueryServiceHelper.query((String)"gai_user_agreement", (String)"isagree", (QFilter[])new QFilter[]{userFilter}, (String)"agreetime desc,agreetimestamp desc", (int)1);
        if (agreements.isEmpty()) {
            return false;
        }
        return ((DynamicObject)agreements.get(0)).getBoolean("isagree");
    }
}

