/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.List;
import java.util.Map;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;

public class KmServiceHelper {
    private static final Log log = LogFactory.getLog(KmServiceHelper.class);
    public static final String AI_CLOUD_ID = "ai";
    public static final String KM_APP_ID = "aikm";
    public static final String KM_SERVICE_NAME = "AIKMService";
    public static final String KM_RETRIEVAL_METHOD_NAME = "retrieval";
    public static final String KM_CONVERT_METHOD_NAME = "convertToKMSearchResults";
    public static final String KM_RETRIEVAL_GROUP_METHOD_NAME = "retrievalWithGroups";
    public static final String Q = "Q_ONLY";
    public static final String QA = "QA_ONLY";
    public static final String TEXT_QA = "TEXT_QA";
    public static final String Q_CONTENT = "Q_CONTENT_ONLY";

    public static JSONArray retrieval(String query, List<Long> repoIdList, String searchMode, int topK, float similarity, boolean rerank, String rerankNumber) {
        Object[] params = new Object[]{query, repoIdList, searchMode, topK, Float.valueOf(similarity), rerank, rerankNumber};
        List vectorResults = (List)DispatchServiceHelper.invokeBizService((String)AI_CLOUD_ID, (String)KM_APP_ID, (String)KM_SERVICE_NAME, (String)KM_RETRIEVAL_METHOD_NAME, (Object[])params);
        return KmServiceHelper.convertResult(query, repoIdList, searchMode, topK, similarity, rerank, rerankNumber, vectorResults);
    }

    public static JSONArray retrievalWithGroup(String query, List<Map<String, Object>> repoList, String searchMode, int topK, float similarity, boolean rerank, String rerankNumber) {
        Object[] params = new Object[]{query, repoList, searchMode, topK, Float.valueOf(similarity), rerank, rerankNumber};
        List vectorResults = (List)DispatchServiceHelper.invokeBizService((String)AI_CLOUD_ID, (String)KM_APP_ID, (String)KM_SERVICE_NAME, (String)KM_RETRIEVAL_GROUP_METHOD_NAME, (Object[])params);
        return KmServiceHelper.convertResult(query, repoList, searchMode, topK, similarity, rerank, rerankNumber, vectorResults);
    }

    private static JSONArray convertResult(String query, Object repoList, String searchMode, int topK, float similarity, boolean rerank, String rerankNumber, List<Object> vectorResults) {
        log.info("<\u901a\u7528\u77e5\u8bc6\u5e93>\u77e5\u8bc6\u5e93\u68c0\u7d22\u8c03\u7528\u5fae\u670d\u52a1,vectorResults:[{}]", (Object)vectorResults.toString());
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)AI_CLOUD_ID, (String)KM_APP_ID, (String)KM_SERVICE_NAME, (String)KM_CONVERT_METHOD_NAME, (Object[])new Object[]{vectorResults, searchMode});
        if (result == null) {
            throw new KDBizException("KM\u670d\u52a1\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38");
        }
        Object resultsObj = result.get("results");
        if (resultsObj == null) {
            throw new KDBizException("KM\u670d\u52a1\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38");
        }
        try {
            String resultsJsonStr = JSON.toJSONString(resultsObj);
            return JSON.parseArray((String)resultsJsonStr);
        }
        catch (Exception e) {
            log.error("<\u901a\u7528\u77e5\u8bc6\u5e93>\u77e5\u8bc6\u5e93\u68c0\u7d22\u8c03\u7528\u5fae\u670d\u52a1,KM\u670d\u52a1\u8fd4\u56de\u7ed3\u679c\u5904\u7406\u5f02\u5e38,query:[{}],repoList:[{}],searchMode:[{}],topK:[{}],similarity:[{}],rerank:[{}],rerankNumber:[{}],vectorResults:[{}]", new Object[]{query, repoList, searchMode, topK, Float.valueOf(similarity), rerank, rerankNumber, vectorResults.toString(), e});
            throw new KDBizException("KM\u670d\u52a1\u8fd4\u56de\u7ed3\u679c\u5904\u7406\u5f02\u5e38");
        }
    }
}

