/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.ai.gai.core.domain.dto.Chunk;
import kd.ai.gai.core.domain.dto.FilePreviewParams;
import kd.ai.gai.core.domain.dto.repo.CustomGaiRepoSearchData;
import kd.ai.gai.core.domain.vo.APIReferenceData;
import kd.ai.gai.core.domain.vo.KnowledgeCitationData;
import kd.ai.gai.core.domain.vo.RepoFileVO;
import kd.ai.gai.core.engine.EngineCache;
import kd.ai.gai.core.service.ChunkService;
import kd.ai.gai.core.service.FilePreviewService;
import kd.ai.gai.core.service.RepoService;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;
import org.jetbrains.annotations.NotNull;

public class KnowledgeCitationHelper {
    private static final Log logger = LogFactory.getLog(KnowledgeCitationHelper.class);

    public static String getSupKnowledgeIndex(String chatSessionId, String taskId, List<Long> chunkIdList, String targetContent) {
        String[] contents;
        if (chunkIdList == null || chunkIdList.isEmpty()) {
            return targetContent;
        }
        StringBuilder supMsgBuild = new StringBuilder();
        for (String content : contents = targetContent.split("########")) {
            String contentSupMsg = KnowledgeCitationHelper.getSupKnowledgeIndexByIdentifier(chatSessionId, taskId, chunkIdList, content);
            supMsgBuild.append(contentSupMsg);
        }
        logger.info("\u77e5\u8bc6\u5f15\u7528\u8f6c\u6362\u524d\uff1a{},\u8f6c\u6362\u540e\u4fe1\u606f\uff1a{}", (Object)targetContent, (Object)supMsgBuild.toString());
        return supMsgBuild.toString();
    }

    private static String getSupKnowledgeIndexByIdentifier(String chatSessionId, String taskId, List<Long> chunkIdList, String content) {
        if (StringUtils.isEmpty((CharSequence)content)) {
            return "";
        }
        ArrayList<Long> citationChunkIds = KnowledgeCitationHelper.useCitationChunk(chunkIdList, content);
        if (citationChunkIds.isEmpty()) {
            return content;
        }
        logger.info("\u771f\u5b9e\u5f15\u7528\u7684\u5757\u4fe1\u606f\uff1a{}\u3002", JSON.toJSON(citationChunkIds));
        Map<Integer, KnowledgeCitationData> citationInfo = KnowledgeCitationHelper.getStreamCitationInfoByCache(chatSessionId, taskId);
        Map<Integer, KnowledgeCitationData.ChunkItem> chunkCitationInfo = KnowledgeCitationHelper.getStreamChunkCitationInfoByCache(chatSessionId, taskId);
        List<Chunk> chunks = ChunkService.getByListWithTaskCache(citationChunkIds, chatSessionId, taskId, "needcachedKnowledge");
        logger.info("\u77e5\u8bc6\u5206\u5757\u4fe1\u606f\uff1a{}", JSON.toJSON(chunks));
        if (chunks != null && !chunks.isEmpty()) {
            HashSet<Integer> orderSet = new HashSet<Integer>();
            block0: for (Long chunkId : citationChunkIds) {
                for (Chunk chunk : chunks) {
                    int order;
                    if (!chunkId.equals(chunk.getId())) continue;
                    long repositoryId = chunk.getRepositoryId();
                    String title = chunk.getTitle();
                    String url = chunk.getUrl();
                    long fileId = chunk.getFileId();
                    int page = chunk.getPage();
                    if (StringUtils.isNotEmpty((CharSequence)title) && StringUtils.isNotEmpty((CharSequence)url)) {
                        String source = chunk.getSource();
                        order = KnowledgeCitationHelper.getSupOrder(citationInfo, chunkCitationInfo, repositoryId, fileId, chunkId, source, title, url, "", page);
                    } else {
                        RepoFileVO repoFileVO = RepoService.getFileByChunkId(chunkId);
                        String source = repoFileVO.getSource();
                        title = repoFileVO.getTitle();
                        url = repoFileVO.getUrl();
                        String fileType = repoFileVO.getFileType();
                        if (StringUtils.isEmpty((CharSequence)title)) {
                            title = repoFileVO.getName();
                            url = repoFileVO.getPath();
                        }
                        order = KnowledgeCitationHelper.getSupOrder(citationInfo, chunkCitationInfo, repositoryId, fileId, chunkId, source, title, url, fileType, page);
                    }
                    boolean addStatus = orderSet.add(order);
                    logger.info("\u5e8f\u53f7\u5224\u65ad\uff1astatus = {}, order = {}", (Object)addStatus, (Object)order);
                    if (addStatus) {
                        String supMsg = "<sup>[" + order + "]</sup>";
                        content = content.replaceAll(chunkId + "", supMsg);
                        continue block0;
                    }
                    content = content.replaceAll(chunkId + "", "");
                    continue block0;
                }
            }
            orderSet.clear();
            content = content.replaceAll(",", "").replaceAll("\uff0c", "").replaceAll(" ", "");
            EngineCache.getAppCache(chatSessionId).put("usedKnowledge" + taskId, (Object)JSON.toJSONString(citationInfo));
            EngineCache.getAppCache(chatSessionId).put("usedKnowledge_chunk" + taskId, (Object)JSON.toJSONString(chunkCitationInfo));
        }
        return content;
    }

    @NotNull
    public static ArrayList<Long> useCitationChunk(List<Long> chunkIdList, String streamRepoBuffer) {
        TreeMap<Integer, Long> chunkIds = new TreeMap<Integer, Long>();
        for (Long chunkId : chunkIdList) {
            int index = streamRepoBuffer.indexOf(chunkId + "");
            if (index < 0) continue;
            chunkIds.put(index, chunkId);
        }
        return new ArrayList<Long>(chunkIds.values());
    }

    @NotNull
    public static Map<Integer, KnowledgeCitationData> getStreamCitationInfoByCache(String chatSessionId, String taskId) {
        Map<Integer, KnowledgeCitationData> quoteInfo = new LinkedHashMap<Integer, KnowledgeCitationData>(16);
        String usedChunkStr = (String)EngineCache.getAppCache(chatSessionId).get("usedKnowledge" + taskId, String.class);
        if (StringUtils.isNotEmpty((CharSequence)usedChunkStr)) {
            try {
                quoteInfo = (Map)JSON.parseObject((String)usedChunkStr, (TypeReference)new TypeReference<LinkedHashMap<Integer, KnowledgeCitationData>>(){}, (Feature[])new Feature[0]);
            }
            catch (Exception e) {
                logger.error("\u9519\u8bef\u5b9a\u4f4d\uff0cusedChunkInfos:{}", (Object)usedChunkStr, (Object)e);
            }
        }
        return quoteInfo;
    }

    @NotNull
    public static Map<Integer, KnowledgeCitationData.ChunkItem> getStreamChunkCitationInfoByCache(String chatSessionId, String taskId) {
        Map<Integer, KnowledgeCitationData.ChunkItem> quoteChunkInfo = new LinkedHashMap<Integer, KnowledgeCitationData.ChunkItem>(16);
        String usedChunkStr = (String)EngineCache.getAppCache(chatSessionId).get("usedKnowledge_chunk" + taskId, String.class);
        if (StringUtils.isNotEmpty((CharSequence)usedChunkStr)) {
            try {
                quoteChunkInfo = (Map)JSON.parseObject((String)usedChunkStr, (TypeReference)new TypeReference<LinkedHashMap<Integer, KnowledgeCitationData.ChunkItem>>(){}, (Feature[])new Feature[0]);
            }
            catch (Exception e) {
                logger.error("\u5757\u5f15\u7528\u9519\u8bef\u5b9a\u4f4d\uff0cusedChunkInfos:{}", (Object)usedChunkStr, (Object)e);
            }
        }
        return quoteChunkInfo;
    }

    public static void cacheFilePreviewParams(String chatSessionId, String cacheTag, String taskId) {
        String retrievalContent = (String)EngineCache.getAppCache(chatSessionId).get(cacheTag + taskId, String.class);
        logger.info("\u4ece\u7f13\u5b58\u83b7\u53d6chunks\uff0c\u7528\u4e8e\u7f13\u5b58\u6587\u4ef6\u9884\u89c8\u53c2\u6570\uff1a{}", (Object)retrievalContent);
        if (StringUtils.isNotEmpty((CharSequence)retrievalContent)) {
            List gaiRepoSearchDatas = JSON.parseArray((String)retrievalContent, CustomGaiRepoSearchData.class);
            HashSet<Long> fileIdSet = new HashSet<Long>(gaiRepoSearchDatas.size());
            for (CustomGaiRepoSearchData gaiRepoSearchData : gaiRepoSearchDatas) {
                Long fileId = gaiRepoSearchData.getFileId();
                String cachedFileStr = (String)EngineCache.getAppCacheForFile().get("filePreview" + fileId, String.class);
                boolean addStatus = fileIdSet.add(gaiRepoSearchData.getFileId());
                if (!StringUtils.isEmpty((CharSequence)cachedFileStr) && !addStatus) continue;
                FilePreviewParams filePreviewParams = new FilePreviewParams();
                filePreviewParams.setFileName(gaiRepoSearchData.getFileName());
                filePreviewParams.setFileType(gaiRepoSearchData.getFileType());
                filePreviewParams.setSize(gaiRepoSearchData.getFileSize());
                String fileJson = JSON.toJSONString((Object)filePreviewParams);
                EngineCache.getAppCacheForFile().put("filePreview" + fileId, (Object)fileJson);
                logger.info("\u6587\u4ef6\u9884\u89c8\u53c2\u6570\u52a0\u5165\u7f13\u5b58: fileId = {}, FileJson: {}", (Object)fileId, (Object)fileJson);
            }
        }
    }

    public static int getSupOrder(Map<Integer, KnowledgeCitationData> quoteInfo, Map<Integer, KnowledgeCitationData.ChunkItem> quoteChunkInfo, long repoId, long fileId, long chunkId, String source, String title, String url, String fileType, int page) {
        int order = quoteInfo.size();
        int chunkOrder = quoteChunkInfo.size();
        int titleUrlHash = (title.trim() + url.trim()).hashCode();
        int chunkHash = (chunkId + "").hashCode();
        boolean exit = quoteInfo.containsKey(titleUrlHash);
        if (!exit) {
            KnowledgeCitationData citationData = new KnowledgeCitationData(repoId, fileId, title, url, source, ++order);
            quoteInfo.put(titleUrlHash, citationData);
        }
        if (exit = quoteChunkInfo.containsKey(chunkHash)) {
            KnowledgeCitationData.ChunkItem chunkItem = quoteChunkInfo.get(chunkHash);
            chunkOrder = chunkItem.getChunkOrder();
        } else {
            KnowledgeCitationData.ChunkItem newChunkItem = new KnowledgeCitationData.ChunkItem(++chunkOrder, chunkId);
            if (StringUtils.isNotEmpty((CharSequence)fileType) && fileType.equals("pdf")) {
                newChunkItem.setPage(page);
            } else {
                newChunkItem.setPage(-1);
            }
            KnowledgeCitationData item = quoteInfo.get(titleUrlHash);
            List<KnowledgeCitationData.ChunkItem> chunkItems = item.getChunkItems();
            chunkItems.add(newChunkItem);
            quoteChunkInfo.put(chunkHash, newChunkItem);
        }
        return chunkOrder;
    }

    public static List<KnowledgeCitationData> getCitationInfo(String chatSessionId, String taskId) {
        Map<Integer, KnowledgeCitationData> quoteInfo = KnowledgeCitationHelper.getStreamCitationInfoByCache(chatSessionId, taskId);
        return new ArrayList<KnowledgeCitationData>(quoteInfo.values());
    }

    public static List<APIReferenceData> boxCitationInfoToAPIService(List<KnowledgeCitationData> citationDatas) {
        if (citationDatas == null || citationDatas.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<APIReferenceData> webItems = new ArrayList<APIReferenceData>(citationDatas.size());
        for (KnowledgeCitationData citationData : citationDatas) {
            APIReferenceData mSkcDta;
            Long repoId = citationData.getRepoId();
            String title = citationData.getTitle();
            String source = citationData.getSource();
            String linkUrl = citationData.getLinkUrl();
            int order = citationData.getOrder();
            if ("doc".equals(source) || "code".equals(source)) {
                String previewPath = FilePreviewService.getPreviewUrl(linkUrl);
                mSkcDta = new APIReferenceData(repoId, title, previewPath, order);
            } else {
                String url = linkUrl;
                boolean isNextCloud = url.startsWith("{domainContextUrl}");
                if (isNextCloud) {
                    String domainContextUrl = UrlService.getDomainContextUrl();
                    url = url.replaceFirst("\\{domainContextUrl\\}", domainContextUrl);
                }
                mSkcDta = new APIReferenceData(repoId, title, url, order);
            }
            webItems.add(mSkcDta);
        }
        return webItems;
    }

    public static Integer getFileIndex(String chatSessionId, String taskId, List<Long> chunkIdList, String streamRepoBuffer) {
        int fileIdIndex;
        Long thisChunkId = null;
        for (Long chunkId : chunkIdList) {
            if (!streamRepoBuffer.contains(chunkId + "")) continue;
            thisChunkId = chunkId;
            break;
        }
        if (null == thisChunkId) {
            return null;
        }
        Long fileId = ChunkService.getFileIdByChunkId(thisChunkId);
        List<Long> fileIdList = new ArrayList();
        String usedFileIds = (String)EngineCache.getAppCache(chatSessionId).get("usedFileIds" + taskId, String.class);
        if (StringUtils.isNotEmpty((CharSequence)usedFileIds)) {
            fileIdList = JSON.parseArray((String)usedFileIds, Long.class);
        }
        if ((fileIdIndex = fileIdList.indexOf(fileId)) != -1) {
            return fileIdIndex + 1;
        }
        fileIdList.add(fileId);
        logger.info("\u9519\u8bef\u5b9a\u4f4d\uff0cthisChunk:{},fileId:{} ", new Object[]{thisChunkId, fileId, JSON.toJSON(fileIdList)});
        EngineCache.getAppCache(chatSessionId).put("usedFileIds" + taskId, (Object)JSON.toJSONString(fileIdList));
        return fileIdList.size();
    }
}

