/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.helper;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ai.gai.core.Constant;
import kd.ai.gai.core.aop.GaiMService;
import kd.ai.gai.core.code.GaiErrorCode;
import kd.ai.gai.core.code.GaiExceptionUtil;
import kd.ai.gai.core.domain.dto.Chunk;
import kd.ai.gai.core.domain.dto.repo.GaiEmbeddingData;
import kd.ai.gai.core.domain.dto.repo.GaiRepoData;
import kd.ai.gai.core.domain.dto.repo.GaiRepoFileData;
import kd.ai.gai.core.domain.dto.repo.GaiRepoGroupData;
import kd.ai.gai.core.domain.dto.repo.RepoFulltextDeleteParam;
import kd.ai.gai.core.domain.mservice.GaiDBRepoAddGroupChunkDataParams;
import kd.ai.gai.core.domain.mservice.GaiDBRepoDelChunkParams;
import kd.ai.gai.core.domain.mservice.GaiRepoAddFileParams;
import kd.ai.gai.core.domain.mservice.GaiRepoAddGroupDataParams;
import kd.ai.gai.core.domain.mservice.GaiRepoCreateDBParams;
import kd.ai.gai.core.domain.mservice.GaiRepoCreateParams;
import kd.ai.gai.core.domain.mservice.GaiRepoDelFileParams;
import kd.ai.gai.core.domain.mservice.GaiRepoDelGroupParams;
import kd.ai.gai.core.domain.vo.AddRepoGroupDatasVO;
import kd.ai.gai.core.domain.vo.RepoDataInfo;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.VectorMetricType;
import kd.ai.gai.core.enuz.repo.RepoChunkDataPreRule;
import kd.ai.gai.core.enuz.repo.RepoChunkEmbeddingRule;
import kd.ai.gai.core.enuz.repo.RepoChunkStrategy;
import kd.ai.gai.core.enuz.repo.RepoPreIdentifierRule;
import kd.ai.gai.core.enuz.repo.RepoServiceCallType;
import kd.ai.gai.core.rag.milvus.MilvusService;
import kd.ai.gai.core.rag.service.RepoDispatchService;
import kd.ai.gai.core.rag.service.RepoFulltextService;
import kd.ai.gai.core.service.AiccService;
import kd.ai.gai.core.service.ChunkService;
import kd.ai.gai.core.service.RepoService;
import kd.ai.gai.core.service.vdb.VDBServiceManager;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;

public class RagHelper {
    private static final Log logger = LogFactory.getLog(RagHelper.class);
    private static final long max_file_size = 0x6400000L;
    private static final String repos_file_id = "doc_manage.id";
    private static final String repos_file_name = "doc_manage.file_name";
    private static final String repos_file_status = "doc_manage.file_status";
    private static final String repos_file_path = "doc_manage.file_path";
    private static final String repo_file_select_field = String.join((CharSequence)",", "doc_manage.id", "doc_manage.file_name", "doc_manage.file_status", "doc_manage.file_path");
    private static final String repo_select_field = String.join((CharSequence)",", "id", "isfulltext", "metric_type", "number", "name", "useorg", "repo_source", "desc", "status", "index_method", "type", "modifytime");
    private static final String preset = "preset";
    private static final String custom = "custom";

    public static RepoDataInfo createRepo(RepoServiceCallType callType, GaiRepoCreateParams params) {
        return GaiMService.execute(String.format("%s-\u521b\u5efa\u95ee\u7b54\u77e5\u8bc6\u5e93", new Object[]{callType}), params, p -> {
            RequestContext rc = RequestContext.get();
            long currUserId = rc.getCurrUserId();
            String repoName = params.getName();
            String repoType = params.getType();
            long useOrg = params.getUseOrg();
            String indexMethod = params.getIndexMethod();
            String desc = params.getDesc();
            String chunkStrategy = params.getChunkStrategy();
            String metricType = params.getMetricType();
            List<GaiRepoCreateParams.RepoFileParam> fileInfos = params.getFileInfos();
            if (StringUtils.isEmpty((String)chunkStrategy)) {
                chunkStrategy = RepoChunkStrategy.BASE_FIXED_LENGTH.getType();
            }
            GaiRepoCreateParams.IdentifierStrategyContent identifierStrategyContent = params.getIdentifierStrategyContent();
            int chunkMaxLenth = 0;
            String identifierType = "";
            String identifierContent = "";
            String[] preDataRule = null;
            if (identifierStrategyContent != null) {
                chunkMaxLenth = identifierStrategyContent.getChunkMaxLenth();
                identifierType = identifierStrategyContent.getIdentifierType();
                identifierContent = identifierStrategyContent.getIdentifierContent();
                preDataRule = identifierStrategyContent.getPreDataRule();
            }
            indexMethod = RagHelper.indexMethodModify(indexMethod);
            if (params.isEnableFT()) {
                RepoFulltextService.getInstance().initRepoIndex();
            }
            RagHelper.checkMustParams(repoName, repoType, useOrg, fileInfos, chunkStrategy, indexMethod, chunkMaxLenth, identifierType, identifierContent);
            DynamicObject repoInfo = BusinessDataServiceHelper.newDynamicObject((String)"gai_repo_info");
            String repoNumber = CodeRuleServiceHelper.getNumber((String)repoInfo.getDataEntityType().getName(), (DynamicObject)repoInfo, null);
            long repoId = ORM.create().genLongId("gai_repo_info");
            repoInfo.set("id", (Object)repoId);
            repoInfo.set("name", (Object)repoName);
            repoInfo.set("number", (Object)repoNumber);
            repoInfo.set("useorg", (Object)useOrg);
            repoInfo.set("type", (Object)repoType);
            repoInfo.set("chunk_strategy", (Object)chunkStrategy);
            repoInfo.set("metric_type", (Object)(StringUtils.isEmpty((String)metricType) ? "l2" : metricType));
            repoInfo.set("creator", (Object)currUserId);
            repoInfo.set("desc", (Object)desc);
            repoInfo.set("enable", (Object)"1");
            repoInfo.set("isfulltext", (Object)params.isEnableFT());
            repoInfo.set("index_method", (Object)indexMethod);
            repoInfo.set("status", (Object)"A");
            repoInfo.set("repo_source", (Object)"ms");
            repoInfo.set("file_total", (Object)(fileInfos != null ? fileInfos.size() : 0));
            if (chunkStrategy.equals(RepoChunkStrategy.IDENTIFIER.getType())) {
                repoInfo.set("chunk_maxlength", (Object)chunkMaxLenth);
                if (identifierType.equals(custom)) {
                    repoInfo.set("text_customidentifier", (Object)identifierContent);
                    repoInfo.set("identifiertype", (Object)2);
                } else if (identifierType.equals(preset)) {
                    String identifierVal = RepoPreIdentifierRule.forIdentifier(identifierContent);
                    repoInfo.set("combo_presetidentifier", (Object)identifierVal);
                    repoInfo.set("identifiertype", (Object)1);
                }
                if (preDataRule != null) {
                    RagHelper.matchPreRules(preDataRule, repoInfo);
                }
            }
            DynamicObjectCollection docs = repoInfo.getDynamicObjectCollection("doc_manage");
            logger.info("\u3010GPT-\u5fae\u670d\u52a1\u670d\u52a1\u3011\u521b\u5efa\u95ee\u7b54\u77e5\u8bc6\u5e93-\u5165\u5e93\u5f00\u59cb\uff0crepoId:{}", (Object)repoId);
            for (GaiRepoCreateParams.RepoFileParam f : fileInfos) {
                DynamicObject doc = docs.addNew();
                doc.set("file_name", (Object)f.getFileName());
                doc.set("file_type", (Object)f.getFileType());
                doc.set("file_path", (Object)f.getFilePath());
                doc.set("file_size", (Object)f.getFileSize());
                doc.set("file_status", (Object)"A");
                String currenFileSource = RagHelper.getFileSource(repoType, f.getFileType());
                doc.set("file_source", (Object)currenFileSource);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{repoInfo});
            logger.info("\u3010GPT-\u5fae\u670d\u52a1\u670d\u52a1\u3011\u521b\u5efa\u95ee\u7b54\u77e5\u8bc6\u5e93-\u5165\u5e93\u5b8c\u6210\uff0crepoId:{}", (Object)repoId);
            boolean start = RepoDispatchService.dispatchTask(repoId);
            if (!start) {
                DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_info set fstatus=? where fid = ?", (Object[])new Object[]{"D", repoId});
                throw new KDBizException(GaiExceptionUtil.buildErr(GaiErrorCode.RAG_REPO_TASK_ERR), new Object[0]);
            }
            DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_info set fstatus=? where fid = ?", (Object[])new Object[]{"B", repoId});
            logger.info("\u3010GPT-\u5fae\u670d\u52a1\u670d\u52a1\u3011\u95ee\u7b54\u77e5\u8bc6\u5e93\uff0crepoId:{}-\u4efb\u52a1\u542f\u52a8\u6210\u529f", (Object)repoId);
            return new RepoDataInfo(repoId, repoNumber, repoName);
        });
    }

    private static String indexMethodModify(String indexMethod) {
        List<GaiEmbeddingData> useableEmbeddings = RagHelper.getGaiUseableEmbedding();
        if (useableEmbeddings.isEmpty()) {
            GaiExceptionUtil.throwGaiException(GaiErrorCode.RAG_REPO_EMBEDDING_LLM_ERR);
        }
        if (StringUtils.isEmpty((String)indexMethod)) {
            indexMethod = useableEmbeddings.get(0).getNumber();
        } else {
            boolean isvalid = false;
            for (GaiEmbeddingData modelData : useableEmbeddings) {
                if (!modelData.getNumber().equals(indexMethod)) continue;
                isvalid = true;
                break;
            }
            if (!isvalid) {
                indexMethod = useableEmbeddings.get(0).getNumber();
            }
        }
        return indexMethod;
    }

    private static void matchPreRules(String[] preRules, DynamicObject repoInfo) {
        repoInfo.set("checkbox_replacesymbol", (Object)false);
        repoInfo.set("checkbox_deleteurl", (Object)false);
        for (String preRule : preRules) {
            if (RepoChunkDataPreRule.REPLACE_CONTINUOUS.getVal().equals(preRule)) {
                repoInfo.set("checkbox_replacesymbol", (Object)true);
            }
            if (!RepoChunkDataPreRule.DELETEURL.getVal().equals(preRule)) continue;
            repoInfo.set("checkbox_deleteurl", (Object)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GaiRepoData queryRepoInfo(RepoServiceCallType callType, long repoId) {
        String repoStatus = "B";
        float repoProcess = 0.0f;
        long repoModiftTime = 0L;
        try {
            GaiRepoData repoData = GaiMService.execute(String.format("%s-\u67e5\u8be2\u77e5\u8bc6\u5e93\u4fe1\u606f", new Object[]{callType}), repoId, p -> {
                DynamicObject repoObj = QueryServiceHelper.queryOne((String)"gai_repo_info", (String)repo_select_field, (QFilter[])new QFilter[]{new QFilter("id", "=", p)});
                long id = repoObj.getLong("id");
                String status = repoObj.getString("status");
                String number = repoObj.getString("number");
                String name = repoObj.getString("name");
                Long useorg = repoObj.getLong("useorg");
                String desc = repoObj.getString("desc");
                String indexMethod = repoObj.getString("index_method");
                boolean enableFT = repoObj.getBoolean("isfulltext");
                String type = repoObj.getString("type");
                long modifytime = repoObj.getDate("modifytime").getTime();
                float process = RepoService.algoRepoTaskProcess(p);
                return new GaiRepoData(id, number, name, useorg, indexMethod, enableFT, type, desc, status, process, modifytime);
            });
            repoStatus = repoData.getStatus();
            repoProcess = repoData.getProcess();
            repoModiftTime = repoData.getLastModifytime();
            GaiRepoData gaiRepoData = repoData;
            return gaiRepoData;
        }
        finally {
            long currentTime = System.currentTimeMillis();
            if (("B".equals(repoStatus) || repoProcess < 1.0f) && currentTime - repoModiftTime >= 0x6DDD00L) {
                RepoService.checkRepoTaskTime(repoId, repoProcess, repoModiftTime);
            }
        }
    }

    public static List<GaiRepoFileData> queryRepoFilesInfo(RepoServiceCallType callType, long repoId) {
        return GaiMService.execute(String.format("%s-\u67e5\u8be2\u77e5\u8bc6\u5e93\u6587\u4ef6\u5217\u8868\u4fe1\u606f", new Object[]{callType}), repoId, p -> {
            List files;
            DynamicObjectCollection repoObjs = QueryServiceHelper.query((String)"gai_repo_info", (String)repo_file_select_field, (QFilter[])new QFilter[]{new QFilter("id", "=", p)});
            if (repoObjs != null && repoObjs.size() > 0) {
                files = new ArrayList(repoObjs.size());
                for (DynamicObject repoObj : repoObjs) {
                    Long fileId = repoObj.getLong(repos_file_id);
                    String name = repoObj.getString(repos_file_name);
                    String path = repoObj.getString(repos_file_path);
                    String status = repoObj.getString(repos_file_status);
                    GaiRepoFileData repoFileDTO = new GaiRepoFileData(fileId, name, path, status);
                    files.add(repoFileDTO);
                }
            } else {
                files = Collections.emptyList();
            }
            return files;
        });
    }

    public static List<GaiEmbeddingData> queryIndexMethod(RepoServiceCallType callType) {
        return GaiMService.execute(String.format("%s-\u67e5\u8be2\u77e5\u8bc6\u5e93\u7d22\u53ef\u7528\u5f15\u65b9\u5f0f", new Object[]{callType}), null, o -> {
            LLM[] llms = LLM.values();
            List<String> instanceList = AiccService.getAiccInstanceList();
            ArrayList<GaiEmbeddingData> list = new ArrayList<GaiEmbeddingData>(llms.length);
            for (LLM llm : llms) {
                if (!llm.isActive() || llm.getModelType() != LLM.ModelType.EMBEDDING || !instanceList.contains(llm.getNumber())) continue;
                list.add(new GaiEmbeddingData(llm.getNumber(), llm.getName()));
            }
            return list;
        });
    }

    public static boolean addRepoFiles(RepoServiceCallType callType, GaiRepoAddFileParams params) {
        return GaiMService.execute(String.format("%s-\u65b0\u589e\u77e5\u8bc6\u5e93\u6587\u4ef6", new Object[]{callType}), params, p -> {
            long repoId = params.getRepoId();
            List<GaiRepoCreateParams.RepoFileParam> fileInfos = params.getFileInfos();
            DynamicObject repoObj = QueryServiceHelper.queryOne((String)"gai_repo_info", (String)repo_select_field, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)repoId)});
            RagHelper.checkExistAndRunning(repoObj);
            StringBuilder msg = new StringBuilder();
            String repoType = repoObj.getString("type");
            RagHelper.checkMustFilesParams(msg, repoType, fileInfos);
            int size = fileInfos.size();
            long[] ids = ORM.create().genLongIds("gai_repo_info", size);
            String sql = "INSERT INTO T_GAI_REPO_DOC_MANAGE (FID,FENTRYID,FFILENAME,FFILESTATUS,FFILEPATH,FFILESIZE,FFILETYPE,FCREATEDATE,FFILESOURCE) VALUES (?,?,?,?,?,?,?,?,?)";
            for (int i = 0; i < fileInfos.size(); ++i) {
                GaiRepoCreateParams.RepoFileParam fileParam = fileInfos.get(i);
                RagHelper.insertOneFile(repoId, repoType, ids[i], sql, fileParam);
            }
            boolean start = RepoDispatchService.dispatchTask(repoId);
            DynamicObject repo = QueryServiceHelper.queryOne((String)"gai_repo_info", (String)"file_total", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)repoId)});
            int repoFileTotal = repo.getInt("file_total");
            if (start) {
                DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_info set fstatus=?,ffiletotal=? where fid = ?", (Object[])new Object[]{"B", repoFileTotal + size, repoId});
            } else {
                DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_info set fstatus=?,ffiletotal=? where fid = ?", (Object[])new Object[]{"D", repoFileTotal + size, repoId});
                GaiExceptionUtil.throwGaiException(GaiErrorCode.RAG_REPO_TASK_ERR);
            }
            return Boolean.TRUE;
        });
    }

    public static boolean deleteRepoById(RepoServiceCallType callType, long repoId) {
        return GaiMService.execute(String.format("%s-\u5220\u9664\u77e5\u8bc6\u5e93", new Object[]{callType}), repoId, p -> {
            DynamicObject repoObj = QueryServiceHelper.queryOne((String)"gai_repo_info", (String)repo_select_field, (QFilter[])new QFilter[]{new QFilter("id", "=", p)});
            RagHelper.checkExistAndRunning(repoObj);
            boolean del = "dev".equalsIgnoreCase(repoObj.getString("repo_source"));
            RepoService.delRepoChunkAndVectorByIds(new Object[]{p}, del);
            MainEntityType repoEntityType = EntityMetadataCache.getDataEntityType((String)"gai_repo_info");
            DeleteServiceHelper.delete((IDataEntityType)repoEntityType, (Object[])new Object[]{p});
            return Boolean.TRUE;
        });
    }

    public static boolean deleteRepoFiles(RepoServiceCallType callType, GaiRepoDelFileParams delFileParams) {
        return GaiMService.execute(String.format("%s-\u5220\u9664\u77e5\u8bc6\u5e93\u4e2d\u6587\u4ef6", new Object[]{callType}), delFileParams, params -> {
            long repoId = params.getRepoId();
            long[] fileIds = params.getFileIds();
            if (repoId <= 0L || fileIds == null || fileIds.length <= 0) {
                GaiExceptionUtil.throwGaiException(GaiErrorCode.RAG_REPO_PARAMS_ERR);
            }
            DynamicObject repoObj = QueryServiceHelper.queryOne((String)"gai_repo_info", (String)repo_select_field, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)repoId)});
            RagHelper.checkExistAndRunning(repoObj);
            String indexMethod = repoObj.getString("index_method");
            LLM llm = LLM.parse(indexMethod);
            String metricType = repoObj.getString("metric_type");
            VectorMetricType vectorMetricType = VectorMetricType.parse(metricType);
            DynamicObjectCollection dids = QueryServiceHelper.query((String)"gai_text_chunk", (String)"id", (QFilter[])new QFilter[]{new QFilter("repoid", "=", (Object)repoId).and("fileid", "in", (Object)fileIds)});
            if (dids != null) {
                List<Long> ids = dids.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
                logger.info("\u3010GPT-RAG-\u5fae\u670d\u52a1\u670d\u52a1\u3011\u5220\u9664\u77e5\u8bc6\u5e93\u4e2d\u6587\u4ef6,\u5757IDS:{}", ids);
                if (!ids.isEmpty()) {
                    if (MilvusService.enableVDB()) {
                        VDBServiceManager.getStore(llm, vectorMetricType).delByIdList(ids);
                    } else {
                        MilvusService.getExecutor(llm, vectorMetricType).delByIdList(ids);
                    }
                }
            }
            DeleteServiceHelper.delete((String)"gai_text_chunk", (QFilter[])new QFilter[]{new QFilter("repoid", "=", (Object)repoId).and("fileid", "in", (Object)fileIds)});
            StringBuilder sql = new StringBuilder();
            sql.append("delete t_gai_repo_doc_manage ");
            sql.append("where fid = ? ");
            sql.append("and fentryid in (");
            sql.append(String.join((CharSequence)",", Collections.nCopies(fileIds.length, "?")));
            sql.append(')');
            Object[] sqlParams = new Object[fileIds.length + 1];
            sqlParams[0] = repoId;
            for (int i = 0; i < fileIds.length; ++i) {
                sqlParams[i + 1] = fileIds[i];
            }
            DB.execute((DBRoute)DBRoute.of((String)"aidb"), (String)sql.toString(), (Object[])sqlParams);
            String docCountSql = "select count(1)  from t_gai_repo_doc_manage  where fid=? ";
            int totalCount = (Integer)DB.query((DBRoute)DBRoute.of((String)"aidb"), (String)docCountSql, (Object[])new Object[]{repoId}, resultSet -> {
                resultSet.next();
                return resultSet.getInt(1);
            });
            DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_info set ffiletotal=? where fid = ?", (Object[])new Object[]{totalCount, repoId});
            String repoSource = repoObj.getString("repo_source");
            if ("dev".equalsIgnoreCase(repoSource)) {
                DynamicObjectCollection repoObjPaths = QueryServiceHelper.query((String)"gai_repo_info", (String)repos_file_path, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)repoId).and(repos_file_id, "in", (Object)fileIds)});
                if (repoObjPaths != null) {
                    for (DynamicObject repoObjPath : repoObjPaths) {
                        String path = repoObjPath.getString(repos_file_path);
                        FileServiceFactory.getAttachmentFileService().delete(path);
                    }
                }
            } else {
                logger.info("\u3010GPT-RAG-\u5fae\u670d\u52a1\u670d\u52a1\u3011\u5220\u9664\u77e5\u8bc6\u5e93\u4e2d\u6587\u4ef6\uff0c\u975e\u5f00\u53d1\u5e73\u53f0\u521b\u5efa\u6765\u6e90\uff0c\u4e0d\u5904\u7406\u539f\u6587\u4ef6");
            }
            RepoService.updateRepoStatus(llm, repoId);
            return Boolean.TRUE;
        });
    }

    public static RepoDataInfo createRepoByDatabase(RepoServiceCallType callType, GaiRepoCreateDBParams params) {
        return GaiMService.execute(String.format("%s-\u521b\u5efa\u95ee\u7b54\u77e5\u8bc6\u5e93-DB\u578b", new Object[]{callType}), params, p -> {
            Iterator<GaiRepoCreateDBParams.RepoGroupDataInfoParam> iterator;
            ArrayList<GaiRepoGroupData> resultGroupDatas;
            RequestContext rc = RequestContext.get();
            long currUserId = rc.getCurrUserId();
            String repoName = params.getName();
            long useOrg = params.getUseOrg();
            String indexMethod = params.getIndexMethod();
            String desc = params.getDesc();
            String metricType = params.getMetricType();
            String repoType = "qa";
            String chunkStrategy = RepoChunkStrategy.CUSTOMIZE.getType();
            List<GaiRepoCreateDBParams.RepoGroupDataInfoParam> groupInfos = params.getGroupInfos();
            List<GaiEmbeddingData> useableEmbeddings = RagHelper.getGaiUseableEmbedding();
            if (useableEmbeddings == null || useableEmbeddings.isEmpty()) {
                GaiExceptionUtil.throwGaiException(GaiErrorCode.RAG_REPO_EMBEDDING_LLM_ERR);
            }
            if (StringUtils.isEmpty((String)indexMethod)) {
                indexMethod = useableEmbeddings.get(0).getNumber();
            }
            if (params.isEnableFT()) {
                RepoFulltextService.getInstance().initRepoIndex();
            }
            DynamicObject repoInfo = BusinessDataServiceHelper.newDynamicObject((String)"gai_repo_info");
            String repoNumber = CodeRuleServiceHelper.getNumber((String)repoInfo.getDataEntityType().getName(), (DynamicObject)repoInfo, null);
            long repoId = ORM.create().genLongId("gai_repo_info");
            repoInfo.set("id", (Object)repoId);
            repoInfo.set("name", (Object)repoName);
            repoInfo.set("number", (Object)repoNumber);
            repoInfo.set("useorg", (Object)useOrg);
            repoInfo.set("type", (Object)repoType);
            repoInfo.set("chunk_strategy", (Object)chunkStrategy);
            repoInfo.set("creator", (Object)currUserId);
            repoInfo.set("desc", (Object)desc);
            repoInfo.set("metric_type", (Object)(StringUtils.isEmpty((String)metricType) ? "l2" : metricType));
            repoInfo.set("enable", (Object)"1");
            repoInfo.set("index_method", (Object)indexMethod);
            repoInfo.set("isfulltext", (Object)params.isEnableFT());
            repoInfo.set("status", (Object)"A");
            repoInfo.set("repo_source", (Object)"ms_db");
            repoInfo.set("file_total", (Object)(groupInfos != null ? groupInfos.size() : 0));
            RepoDataInfo repoDataInfo = new RepoDataInfo(repoId, repoNumber, repoName);
            DynamicObjectCollection docs = repoInfo.getDynamicObjectCollection("doc_manage");
            logger.info("\u3010GPT-\u5fae\u670d\u52a1\u670d\u52a1\u3011\u521b\u5efa\u95ee\u7b54\u77e5\u8bc6\u5e93-\u4e1a\u52a1\u6570\u636e\u578b-\u5165\u5e93\u5f00\u59cb\uff0crepoId:{}", (Object)repoId);
            if (groupInfos != null && groupInfos.size() > 0) {
                resultGroupDatas = new ArrayList<GaiRepoGroupData>(groupInfos.size());
                iterator = groupInfos.iterator();
            } else {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{repoInfo});
                logger.info("\u3010GPT-\u5fae\u670d\u52a1\u670d\u52a1\u3011\u521b\u5efa\u95ee\u7b54\u77e5\u8bc6\u5e93-\u4e1a\u52a1\u6570\u636e\u578b-\u5165\u5e93\u5b8c\u6210\uff0crepoId:{}", (Object)repoId);
                return repoDataInfo;
            }
            while (iterator.hasNext()) {
                GaiRepoCreateDBParams.RepoGroupDataInfoParam f = iterator.next();
                DynamicObject doc = docs.addNew();
                long groupId = DB.genLongId((String)"gai_text_chunk");
                doc.set("id", (Object)groupId);
                doc.set("file_name", (Object)f.getGroupName());
                doc.set("file_status", (Object)"A");
                doc.set("file_source", (Object)"db");
                doc.set("file_type", (Object)"db");
                ArrayList<Chunk> chunks = new ArrayList<Chunk>(10);
                List<GaiRepoCreateDBParams.RepoDatabase> groupDatas = f.getGroupDatas();
                resultGroupDatas.add(new GaiRepoGroupData(groupId, f.getGroupName(), "A"));
                for (int i = 0; i < groupDatas.size(); ++i) {
                    GaiRepoCreateDBParams.RepoDatabase repoDatabase = groupDatas.get(i);
                    Chunk chunk = new Chunk();
                    chunk.setRepositoryId(repoId);
                    chunk.setFileId(groupId);
                    chunk.setBusinessId(repoDatabase.getBusinessId());
                    chunk.setSource("db");
                    chunk.setChunk(repoDatabase.getChunk());
                    chunks.add(chunk);
                    ChunkService.batchConditionInsert(chunks);
                }
                ChunkService.batchInsert(chunks);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{repoInfo});
            logger.info("\u3010GPT-\u5fae\u670d\u52a1\u670d\u52a1\u3011\u521b\u5efa\u95ee\u7b54\u77e5\u8bc6\u5e93-\u4e1a\u52a1\u6570\u636e\u578b-\u5165\u5e93\u5b8c\u6210\uff0crepoId:{}", (Object)repoId);
            repoDataInfo.setGroupDatas(resultGroupDatas);
            LLM llm = LLM.parse(indexMethod);
            boolean start = RepoDispatchService.addEmbeddingTaskByDB(repoId, llm);
            if (start) {
                DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_info set fstatus=? where fid = ?", (Object[])new Object[]{"B", repoId});
                logger.info("\u3010GPT-\u5fae\u670d\u52a1\u670d\u52a1\u3011\u95ee\u7b54\u77e5\u8bc6\u5e93-\u4e1a\u52a1\u6570\u636e\u578b\uff0crepoId:{}-\u4efb\u52a1\u542f\u52a8\u6210\u529f", (Object)repoId);
                return repoDataInfo;
            }
            DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_info set fstatus=? where fid = ?", (Object[])new Object[]{"D", repoId});
            throw new KDBizException(GaiExceptionUtil.buildErr(GaiErrorCode.RAG_REPO_TASK_ERR), new Object[0]);
        });
    }

    public static AddRepoGroupDatasVO addRepoGroupDatas(RepoServiceCallType callType, GaiRepoAddGroupDataParams params) {
        return GaiMService.execute(String.format("%s-\u65b0\u589e\u77e5\u8bc6\u5e93-DB\u578b\u5206\u7ec4\u6570\u636e", new Object[]{callType}), params, p -> {
            long repoId = params.getRepoId();
            List<GaiRepoCreateDBParams.RepoGroupDataInfoParam> groupInfos = params.getGroupInfos();
            DynamicObject repoObj = QueryServiceHelper.queryOne((String)"gai_repo_info", (String)repo_select_field, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)repoId)});
            RagHelper.checkExistAndRunning(repoObj);
            StringBuilder msg = new StringBuilder();
            RagHelper.checkMustGroupInfosParams(msg, groupInfos);
            AddRepoGroupDatasVO addRepoGroupDatasVO = new AddRepoGroupDatasVO();
            addRepoGroupDatasVO.setRepoId(repoId);
            int size = groupInfos.size();
            ArrayList<GaiRepoGroupData> groupDatas = new ArrayList<GaiRepoGroupData>(size);
            long[] ids = ORM.create().genLongIds("gai_repo_info", size);
            for (int i = 0; i < groupInfos.size(); ++i) {
                GaiRepoCreateDBParams.RepoGroupDataInfoParam groupDataInfoParam = groupInfos.get(i);
                RagHelper.insertOneGroupData(repoId, ids[i], groupDataInfoParam);
                groupDatas.add(new GaiRepoGroupData(ids[i], groupDataInfoParam.getGroupName(), "A"));
            }
            addRepoGroupDatasVO.setGroupDatas(groupDatas);
            String indexMethod = repoObj.getString("index_method");
            LLM llm = LLM.parse(indexMethod);
            boolean start = RepoDispatchService.addEmbeddingTaskByDB(repoId, llm);
            DynamicObject repo = QueryServiceHelper.queryOne((String)"gai_repo_info", (String)"file_total", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)repoId)});
            int repoFileTotal = repo.getInt("file_total");
            if (start) {
                DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_info set fstatus=?,ffiletotal=? where fid = ?", (Object[])new Object[]{"B", repoFileTotal + size, repoId});
            } else {
                DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_info set fstatus=?,ffiletotal=? where fid = ?", (Object[])new Object[]{"D", repoFileTotal + size, repoId});
                GaiExceptionUtil.throwGaiException(GaiErrorCode.RAG_REPO_TASK_ERR);
            }
            return addRepoGroupDatasVO;
        });
    }

    public static boolean addRepoGroupChunkDatas(RepoServiceCallType callType, GaiDBRepoAddGroupChunkDataParams params) {
        return GaiMService.execute(String.format("%s-\u65b0\u589e\u77e5\u8bc6\u5e93-DB\u578b\u5206\u5757\u6570\u636e", new Object[]{callType}), params, p -> {
            Long repoId = params.getRepoId();
            Long groupId = params.getGroupId();
            List<GaiRepoCreateDBParams.RepoDatabase> groupChunks = params.getGroupChunks();
            if (repoId == null) {
                throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.RAG_REPO_MS_PARAMS_ERR, "\u77e5\u8bc6\u5e93\u4e0d\u4e3a\u7a7a"), new Object[0]);
            }
            if (groupId == null) {
                throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.RAG_REPO_MS_PARAMS_ERR, "\u77e5\u8bc6\u5e93\u5206\u7ec4ID\u4e0d\u4e3a\u7a7a"), new Object[0]);
            }
            if (groupChunks == null || groupChunks.size() <= 0) {
                throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.RAG_REPO_MS_PARAMS_ERR, "\u77e5\u8bc6\u5e93\u5757\u6570\u636e\u4e0d\u4e3a\u7a7a"), new Object[0]);
            }
            DynamicObject repoObj = QueryServiceHelper.queryOne((String)"gai_repo_info", (String)repo_select_field, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)repoId)});
            RagHelper.checkExistAndRunning(repoObj);
            DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_doc_manage set ffilestatus=?  where fentryid=?", (Object[])new Object[]{"B", groupId});
            RagHelper.addDBGroupChunk(repoId, groupId, groupChunks);
            String indexMethod = repoObj.getString("index_method");
            LLM llm = LLM.parse(indexMethod);
            boolean start = RepoDispatchService.addEmbeddingTaskByDB(repoId, llm);
            if (start) {
                DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_info set fstatus=? where fid = ?", (Object[])new Object[]{"B", repoId});
            } else {
                DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_info set fstatus=? where fid = ?", (Object[])new Object[]{"D", repoId});
                GaiExceptionUtil.throwGaiException(GaiErrorCode.RAG_REPO_TASK_ERR);
            }
            return Boolean.TRUE;
        });
    }

    public static List<GaiRepoGroupData> queryRepoGroupDatasInfo(RepoServiceCallType callType, long repoId) {
        return GaiMService.execute(String.format("%s-\u67e5\u8be2\u77e5\u8bc6\u5e93-DB\u578b\u5217\u8868\u4fe1\u606f", new Object[]{callType}), repoId, p -> {
            List files;
            DynamicObjectCollection repoObjs = QueryServiceHelper.query((String)"gai_repo_info", (String)repo_file_select_field, (QFilter[])new QFilter[]{new QFilter("id", "=", p)});
            if (repoObjs != null && repoObjs.size() == 1) {
                files = new ArrayList(repoObjs.size());
                for (DynamicObject repoObj : repoObjs) {
                    Long fileId = repoObj.getLong(repos_file_id);
                    String name = repoObj.getString(repos_file_name);
                    String status = repoObj.getString(repos_file_status);
                    if (fileId == 0L && StringUtils.isEmpty((String)name) && StringUtils.isEmpty((String)status)) continue;
                    GaiRepoGroupData repoFileDTO = new GaiRepoGroupData(fileId, name, status);
                    files.add(repoFileDTO);
                }
            } else if (repoObjs != null && repoObjs.size() > 1) {
                files = new ArrayList(repoObjs.size());
                for (DynamicObject repoObj : repoObjs) {
                    Long fileId = repoObj.getLong(repos_file_id);
                    String name = repoObj.getString(repos_file_name);
                    String status = repoObj.getString(repos_file_status);
                    GaiRepoGroupData repoFileDTO = new GaiRepoGroupData(fileId, name, status);
                    files.add(repoFileDTO);
                }
            } else {
                files = Collections.emptyList();
            }
            return files;
        });
    }

    public static boolean deleteRepoGroupDatas(RepoServiceCallType callType, GaiRepoDelGroupParams delGroupParams) {
        return GaiMService.execute(String.format("%s-\u5220\u9664\u77e5\u8bc6\u5e93-DB\u578b\u4e2d\u5206\u7ec4\u6570\u636e", new Object[]{callType}), delGroupParams, params -> {
            Long repoId = params.getRepoId();
            Long[] groupIds = params.getGroupIds();
            if (repoId <= 0L || groupIds == null || groupIds.length <= 0) {
                GaiExceptionUtil.throwGaiException(GaiErrorCode.RAG_REPO_PARAMS_ERR);
            }
            DynamicObject repoObj = QueryServiceHelper.queryOne((String)"gai_repo_info", (String)repo_select_field, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)repoId)});
            RagHelper.checkExistAndRunning(repoObj);
            String indexMethod = repoObj.getString("index_method");
            boolean isfulltext = repoObj.getBoolean("isfulltext");
            LLM llm = LLM.parse(indexMethod);
            String metricType = repoObj.getString("metric_type");
            VectorMetricType vectorMetricType = VectorMetricType.parse(metricType);
            DynamicObjectCollection dids = QueryServiceHelper.query((String)"gai_text_chunk", (String)"id", (QFilter[])new QFilter[]{new QFilter("repoid", "=", (Object)repoId).and("fileid", "in", (Object)groupIds)});
            List<Long> ids = dids.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            logger.info("\u3010RAG\u3011\u5411\u91cf\u6570\u636e\u5f85\u5220\u9664\uff0cIDS:{}", ids);
            try {
                if (ids != null && ids.size() > 0) {
                    boolean milvusDel;
                    if (isfulltext) {
                        RepoFulltextDeleteParam deleteParam = new RepoFulltextDeleteParam(repoId, groupIds);
                        long fulltextDel = RepoFulltextService.getInstance().deleteByQuery(deleteParam);
                        logger.info("\u3010\u77e5\u8bc6\u5e93\u3011\u5220\u9664-ES\u6570\u636e,\u6267\u884c\u6570\uff1a{} ,repoId:{},groupIds:{}", new Object[]{fulltextDel, repoId, groupIds});
                    }
                    logger.info("\u3010\u77e5\u8bc6\u5e93\u3011\u5220\u9664-\u5411\u91cf\u6570\u636e repoId:{},groupIds:{},ids:{}", new Object[]{repoId, groupIds, JsonUtil.toJson(ids)});
                    if (MilvusService.enableVDB()) {
                        logger.info("delete Repo Group Datas data bos-vdb");
                        milvusDel = VDBServiceManager.getStore(llm, vectorMetricType).delByIdList(ids);
                    } else {
                        logger.info("delete Repo Group Datas data gai-vdb");
                        milvusDel = MilvusService.getExecutor(llm, vectorMetricType).delByIdList(ids);
                    }
                    if (!milvusDel) throw new KDException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.REPO_DEL_ERR, "\u6587\u4ef6-\u5411\u91cf\u503c\u5220\u9664\u5931\u8d25\uff0c\u68c0\u67e5\u5411\u91cf\u5e93\u670d\u52a1"), new Object[0]);
                    logger.info("\u3010\u77e5\u8bc6\u5e93\u3011\u5220\u9664-\u6587\u4ef6 repoId:{},groupIds:{}", (Object)repoId, (Object)groupIds);
                    DeleteServiceHelper.delete((String)"gai_text_chunk", (QFilter[])new QFilter[]{new QFilter("fileid", "in", (Object)groupIds)});
                } else {
                    logger.info("\u77e5\u8bc6\u5e93[{}]\u6587\u672c\u5757\u6570\u4e3a0", (Object)repoId);
                }
                StringBuilder sql = new StringBuilder();
                sql.append("delete t_gai_repo_doc_manage ");
                sql.append("where fid = ? ");
                sql.append("and fentryid in (");
                sql.append(String.join((CharSequence)",", Collections.nCopies(groupIds.length, "?")));
                sql.append(')');
                Object[] sqlParams = new Object[groupIds.length + 1];
                sqlParams[0] = repoId;
                for (int i = 0; i < groupIds.length; ++i) {
                    sqlParams[i + 1] = groupIds[i];
                }
                DB.execute((DBRoute)DBRoute.of((String)"aidb"), (String)sql.toString(), (Object[])sqlParams);
                String docCountSql = "select count(1)  from t_gai_repo_doc_manage  where fid=? ";
                int totalCount = (Integer)DB.query((DBRoute)DBRoute.of((String)"aidb"), (String)docCountSql, (Object[])new Object[]{repoId}, resultSet -> {
                    resultSet.next();
                    return resultSet.getInt(1);
                });
                DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_info set ffiletotal=? where fid = ?", (Object[])new Object[]{totalCount, repoId});
                RepoService.updateRepoStatus(llm, repoId);
                return Boolean.TRUE;
            }
            catch (Exception e) {
                String errmsg = String.format("\u6570\u636e\u5220\u9664\u5f02\u5e38,\u8bf7\u68c0\u67e5\u76f8\u5173\u670d\u52a1,%s", e.getMessage());
                logger.error(errmsg, (Throwable)e);
                RepoService.updateRepoDocSqlStatus(repoId, groupIds, "H", errmsg);
                DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_info set fstatus=?,fmodifytime=? where fid = ?", (Object[])new Object[]{"D", new Timestamp(System.currentTimeMillis()), repoId});
                throw e;
            }
        });
    }

    public static boolean deleteDBRepoChunkDatas(RepoServiceCallType callType, GaiDBRepoDelChunkParams delChunkParams) {
        return GaiMService.execute(String.format("%s-\u5220\u9664\u77e5\u8bc6\u5e93-DB\u578b\u4e2d\u5757\u6570\u636e", new Object[]{callType}), delChunkParams, params -> {
            Long repoId = params.getRepoId();
            Long groupId = params.getGroupId();
            Long[] chunkIds = params.getChunkIds();
            if (repoId == null) {
                throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.RAG_REPO_MS_PARAMS_ERR, "\u77e5\u8bc6\u5e93\u4e0d\u4e3a\u7a7a"), new Object[0]);
            }
            if (groupId == null) {
                throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.RAG_REPO_MS_PARAMS_ERR, "\u77e5\u8bc6\u5e93\u5206\u7ec4ID\u4e0d\u4e3a\u7a7a"), new Object[0]);
            }
            if (chunkIds == null || chunkIds.length <= 0) {
                throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.RAG_REPO_MS_PARAMS_ERR, "\u77e5\u8bc6\u5e93\u5757ID\u4e0d\u4e3a\u7a7a"), new Object[0]);
            }
            DynamicObject repoObj = QueryServiceHelper.queryOne((String)"gai_repo_info", (String)repo_select_field, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)repoId)});
            RagHelper.checkExistAndRunning(repoObj);
            boolean isfulltext = repoObj.getBoolean("isfulltext");
            String indexMethod = repoObj.getString("index_method");
            String metricType = repoObj.getString("metric_type");
            VectorMetricType vectorMetricType = VectorMetricType.parse(metricType);
            LLM llm = LLM.parse(indexMethod);
            DynamicObjectCollection dids = QueryServiceHelper.query((String)"gai_text_chunk", (String)"id", (QFilter[])new QFilter[]{new QFilter("repoid", "=", (Object)repoId).and("fileid", "=", (Object)groupId).and("id", "in", (Object)chunkIds)});
            List<Long> ids = dids.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            logger.info("\u3010RAG\u3011\u77e5\u8bc6\u5e93\u5411\u91cf\u6570\u636e\u5f85\u5220\u9664\uff0cIDS:{}", ids);
            if (!ids.isEmpty()) {
                if (isfulltext) {
                    RepoFulltextDeleteParam deleteParam = new RepoFulltextDeleteParam(repoId, new Long[]{groupId}, chunkIds);
                    long fulltextDel = RepoFulltextService.getInstance().deleteByQuery(deleteParam);
                    logger.info("\u3010\u77e5\u8bc6\u5e93\u3011\u5220\u9664-ES\u6570\u636e,\u6267\u884c\u6570\uff1a{} ,repoId:{},groupId:{},chunkIds:{}", new Object[]{fulltextDel, repoId, new Long[]{groupId}, chunkIds});
                }
                boolean milvusDel = false;
                milvusDel = MilvusService.enableVDB() ? VDBServiceManager.getStore(llm, vectorMetricType).delByIdList(ids) : MilvusService.getExecutor(llm, vectorMetricType).delByIdList(ids);
                if (milvusDel) {
                    logger.info("\u3010RAG\u3011\u77e5\u8bc6\u5e93\u5220\u9664-\u5757\u6570\u636e repoId:{},groupId:{},chunkIds:{}", new Object[]{repoId, groupId, JsonUtil.toJson(ids)});
                    DeleteServiceHelper.delete((String)"gai_text_chunk", (QFilter[])new QFilter[]{new QFilter("repoid", "=", (Object)repoId).and("fileid", "=", (Object)groupId).and("id", "in", (Object)chunkIds)});
                } else {
                    String errMsg = "\u5206\u7ec4\u4e2d\u5757\u6570\u636e-\u5411\u91cf\u503c\u5220\u9664\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5411\u91cf\u5e93\u670d\u52a1";
                    RepoService.updateRepoDocSqlStatus(repoId, new Long[]{groupId}, "H", errMsg);
                    DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_info set fstatus=?,fmodifytime=? where fid = ?", (Object[])new Object[]{"D", new Timestamp(System.currentTimeMillis()), repoId});
                    throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.REPO_DEL_ERR, errMsg), new Object[0]);
                }
            }
            RepoService.updateRepoStatus(llm, repoId);
            return Boolean.TRUE;
        });
    }

    private static void checkMustParams(String repoName, String repoType, long useOrg, List<GaiRepoCreateParams.RepoFileParam> fileInfos, String chunkStrategy, String indexMethod, int chunkMaxLength, String identifierType, String identifierContent) {
        StringBuilder msg = new StringBuilder();
        if (StringUtils.isEmpty((String)repoName)) {
            msg.append("repoName,");
        }
        if (StringUtils.isEmpty((String)repoType)) {
            msg.append("type,");
        }
        if (!(StringUtils.isEmpty((String)chunkStrategy) || RepoChunkStrategy.BASE_FIXED_LENGTH.getType().equals(chunkStrategy) || RepoChunkStrategy.CUSTOMIZE.getType().equals(chunkStrategy) || RepoChunkStrategy.IDENTIFIER.getType().equals(chunkStrategy))) {
            msg.append("chunkStrategy,");
        }
        ArrayList<String> propList = new ArrayList<String>();
        propList.add("number");
        Map orgInfo = OrgUnitServiceHelper.getOrgProperty((long)useOrg, propList);
        if (orgInfo == null || orgInfo.isEmpty()) {
            msg.append("useOrg,");
        }
        if (RepoChunkStrategy.IDENTIFIER.getType().equals(chunkStrategy)) {
            RagHelper.checkIdentifierParams(msg, indexMethod, chunkMaxLength, identifierType, identifierContent);
        }
        RagHelper.checkMustFilesParams(msg, repoType, fileInfos);
    }

    private static void checkIdentifierParams(StringBuilder msg, String indexMethod, int chunkMaxLength, String identifierType, String identifierContent) {
        if (!identifierType.equals(preset) && !identifierType.equals(custom)) {
            msg.append("identifierType,");
            return;
        }
        for (RepoChunkEmbeddingRule rule : RepoChunkEmbeddingRule.VALUE) {
            if (rule.getChunkStrategy() != RepoChunkStrategy.IDENTIFIER || !indexMethod.equals(rule.getLlm().getNumber())) continue;
            if (chunkMaxLength <= rule.getMaxSize() && chunkMaxLength >= rule.getMinSize()) break;
            msg.append(String.format("[\u4e0d\u652f\u6301\u7684chunkMaxLength\uff0c\u5bf9\u4e8e %s \uff0cchunkMaxLength\u53d6\u503c\u8303\u56f4\u9700\u5728 %d \u548c %d \u4e4b\u95f4],", indexMethod, rule.getMinSize(), rule.getMaxSize()));
            break;
        }
        if (identifierType.equals(preset)) {
            boolean isvaild = false;
            for (RepoPreIdentifierRule rule : RepoPreIdentifierRule.VALUES) {
                if (!rule.getIdentifier().equals(identifierContent)) continue;
                isvaild = true;
                break;
            }
            if (!isvaild) {
                msg.append("[\u6ca1\u6709\u5bf9\u5e94\u7684\u9884\u7f6e\u6807\u8bc6\u7b26\u4e0eidentifierContent\u5339\u914d],");
            }
        } else if (identifierContent.length() > 20) {
            msg.append("[\u81ea\u5b9a\u4e49\u6807\u8bc6\u7b26identifierContent\u957f\u5ea6\u9700\u5c0f\u4e8e20],");
        }
    }

    private static void checkMustGroupInfosParams(StringBuilder msg, List<GaiRepoCreateDBParams.RepoGroupDataInfoParam> groupInfos) {
        if (groupInfos == null || groupInfos.isEmpty()) {
            msg.append("groupInfos\u4e0d\u4e3a\u7a7a,");
        } else {
            boolean groupDatasFail;
            boolean groupNameFail = groupInfos.stream().allMatch(f -> StringUtils.isEmpty((String)f.getGroupName()));
            if (groupNameFail) {
                msg.append("\u6570\u636e\u5206\u7ec4\u540d\u4e0d\u4e3a\u7a7a,");
            }
            if (groupDatasFail = groupInfos.stream().allMatch(f -> f.getGroupDatas() == null || f.getGroupDatas().size() <= 0)) {
                msg.append("\u5206\u7ec4\u6570\u636e\u4e0d\u4e3a\u7a7a,");
            }
        }
        if (StringUtils.isNotEmpty((String)msg.toString())) {
            msg.append("\u53c2\u6570\u4e0d\u5408\u89c4");
            GaiExceptionUtil.throwGaiException(GaiErrorCode.RAG_REPO_PARAMS_ERR, msg.toString());
        }
    }

    private static void checkMustFilesParams(StringBuilder msg, String repoType, List<GaiRepoCreateParams.RepoFileParam> fileInfos) {
        if (fileInfos == null || fileInfos.isEmpty()) {
            msg.append("fileInfos,");
        } else {
            boolean outOfRange = fileInfos.stream().anyMatch(f -> f.getFileSize() > 0x6400000L || f.getFileSize() <= 0L);
            if (outOfRange) {
                msg.append("\u6587\u4ef6\u5927\u5c0f\u4e0d\u6ee1\u8db3\uff1a\u5927\u4e8e0MB\u6216\u5c0f\u4e8e\u7b49\u4e8e100MB \u8981\u6c42,");
            }
            if ("kd_code_gen".equals(repoType)) {
                boolean typefail = fileInfos.stream().allMatch(f -> f.getFileType().contains("json"));
                if (typefail) {
                    msg.append("\u4ee3\u7801\u751f\u6210\u77e5\u8bc6\u5e93\uff0c\u6587\u4ef6\u7c7b\u578b\u5fc5\u987b\u90fd\u4e3ajson,");
                }
            } else {
                boolean typefail = fileInfos.stream().allMatch(f -> Arrays.asList(Constant.RepoInfo.handle_file_type).contains(f.getFileType()));
                if (!typefail) {
                    msg.append("\u95ee\u7b54\u77e5\u8bc6\u5e93\uff0c\u6587\u4ef6\u7c7b\u578b\u5fc5\u987b\u4e3a\uff1atext,pdf,json,");
                }
            }
        }
        if (StringUtils.isNotEmpty((String)msg.toString())) {
            msg.append("\u53c2\u6570\u4e0d\u5408\u89c4");
            GaiExceptionUtil.throwGaiException(GaiErrorCode.RAG_REPO_PARAMS_ERR, msg.toString());
        }
    }

    private static void insertOneGroupData(long repoId, long id, GaiRepoCreateDBParams.RepoGroupDataInfoParam groupDataInfoParam) {
        String sql = "INSERT INTO T_GAI_REPO_DOC_MANAGE (FID,FENTRYID,FFILENAME,FFILESTATUS,FFILETYPE,FCREATEDATE,FFILESOURCE) VALUES (?,?,?,?,?,?,?)";
        DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)sql, (Object[])new Object[]{repoId, id, groupDataInfoParam.getGroupName(), "A", "db", new Timestamp(System.currentTimeMillis()), "db"});
        List<GaiRepoCreateDBParams.RepoDatabase> groupDatas = groupDataInfoParam.getGroupDatas();
        ArrayList<Chunk> chunks = new ArrayList<Chunk>(10);
        for (int i = 0; i < groupDatas.size(); ++i) {
            GaiRepoCreateDBParams.RepoDatabase repoDatabase = groupDatas.get(i);
            Chunk chunk = new Chunk();
            chunk.setRepositoryId(repoId);
            chunk.setFileId(id);
            chunk.setBusinessId(repoDatabase.getBusinessId());
            chunk.setSource("db");
            chunk.setChunk(repoDatabase.getChunk());
            chunks.add(chunk);
            ChunkService.batchConditionInsert(chunks);
        }
        ChunkService.batchInsert(chunks);
    }

    private static void insertOneFile(long repoId, String repoType, long id, String sql, GaiRepoCreateParams.RepoFileParam fileParam) {
        String currenFileSource = RagHelper.getFileSource(repoType, fileParam.getFileType());
        DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)sql, (Object[])new Object[]{repoId, id, fileParam.getFileName(), "A", fileParam.getFilePath(), fileParam.getFileSize(), fileParam.getFileType(), new Timestamp(System.currentTimeMillis()), currenFileSource});
    }

    private static void addDBGroupChunk(long repoId, long groupId, List<GaiRepoCreateDBParams.RepoDatabase> groupDatas) {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>(10);
        for (int i = 0; i < groupDatas.size(); ++i) {
            GaiRepoCreateDBParams.RepoDatabase repoDatabase = groupDatas.get(i);
            Chunk chunk = new Chunk();
            chunk.setRepositoryId(repoId);
            chunk.setFileId(groupId);
            chunk.setBusinessId(repoDatabase.getBusinessId());
            chunk.setSource("db");
            chunk.setChunk(repoDatabase.getChunk());
            chunks.add(chunk);
            ChunkService.batchConditionInsert(chunks);
        }
        ChunkService.batchInsert(chunks);
    }

    private static void checkExistAndRunning(DynamicObject repoObj) {
        if (repoObj != null) {
            String status = repoObj.getString("status");
            if ("B".equals(status)) {
                logger.info("\u3010\u77e5\u8bc6\u5e93\u3011\u4efb\u52a1\u8fd0\u884c\u4e2d\uff0c\u8bf7\u5b8c\u6210\u540e\u518d\u64cd\u4f5c\u3002");
                GaiExceptionUtil.throwGaiException(GaiErrorCode.RAG_REPO_RUNNING_ERR);
            }
        } else {
            GaiExceptionUtil.throwGaiException(GaiErrorCode.RAG_REPO_EXEIT_ERR);
        }
    }

    private static List<GaiEmbeddingData> getGaiUseableEmbedding() {
        LLM[] llms = LLM.values();
        List<String> instanceList = AiccService.getAiccInstanceList();
        ArrayList<GaiEmbeddingData> list = new ArrayList<GaiEmbeddingData>(llms.length);
        for (LLM llm : llms) {
            if (!llm.isActive() || llm.getModelType() != LLM.ModelType.EMBEDDING || !instanceList.contains(llm.getNumber())) continue;
            list.add(new GaiEmbeddingData(llm.getNumber(), llm.getName()));
        }
        return list;
    }

    private static String getFileSource(String repoType, String fileType) {
        String currenFileSource = "kd_code_gen".equals(repoType) ? "code" : ("qa".equals(repoType) && fileType.contains("json") ? "html" : "doc");
        return currenFileSource;
    }
}

