/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.memory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.ai.gai.core.domain.chat.ChatHistoryMessage;
import kd.ai.gai.core.domain.llm.base.UserHistoryMessage;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.flow.node.ExecutionNodeType;
import kd.ai.gai.core.flow.var.FlowVariableService;
import kd.ai.gai.core.flow.var.NodeVariablesInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class ChatMemoryService {
    private static final Log logger = LogFactory.getLog(ChatMemoryService.class);
    private static final String GLOBAL_USER_INPUT = "system.user_input";
    private static final String REPO_REPLY_INPUT = "question";
    private static final String REPO_REPLY_OUT = "answer";
    private static final String REPO_SEARCH_INPUT = "query";
    private static final String REPO_SEARCH_OUT = "outputList";
    private static final String LLM_OUT = "prompt_output";
    private static final String QC_INPUT = "qc_input_name";
    private static final String QC_OUT = "prompt_output";
    private static final String QR_INPUT = "history";
    private static final String QR_OUT = "prompt_output";
    private static final String history_key = "history";
    private static final String repo_search_key = "repoSearchDataList";
    private static final int TOP_MAX_VALUE = 10000;

    public static List<UserHistoryMessage> getChatSessionHistory(String chatSessionId, boolean enableTop, int top) {
        logger.info("\u3010chat history\u3011query chat history msg,chatSessionId:{},enableTop:{},top:{}.", new Object[]{chatSessionId, enableTop, top});
        if (!enableTop) {
            top = 10000;
        } else if (top <= 0) {
            logger.info("\u3010chat history\u3011get chat session history top is 0");
            return Collections.EMPTY_LIST;
        }
        FlowVariableService flowService = FlowVariableService.getInstance();
        List<List<NodeVariablesInfo>> flowVars = flowService.getRecentFlowVariables(chatSessionId, top);
        if (flowVars == null || flowVars.isEmpty()) {
            logger.info("\u3010chat history\u3011get chat session getRecentFlowVariables is null");
            return Collections.EMPTY_LIST;
        }
        ArrayList<UserHistoryMessage> historyMessages = new ArrayList<UserHistoryMessage>(top);
        for (int i = 0; i < flowVars.size(); ++i) {
            List<NodeVariablesInfo> flowVar = flowVars.get(i);
            NodeVariablesInfo startNodeInfo = ChatMemoryService.findNodeInfo(flowVar, ExecutionNodeType.START);
            Map<String, String> inputStartVars = startNodeInfo.getInputVars();
            Set<Map.Entry<String, String>> inputEntrys = inputStartVars.entrySet();
            NodeVariablesInfo nodeInfo = ChatMemoryService.findNodeInfo(flowVar, ExecutionNodeType.REPO_REPLY);
            String outMsg = null;
            UserHistoryMessage chatHistoryMessage = new UserHistoryMessage();
            String inputMsg = (String)inputEntrys.stream().filter(o -> ((String)o.getKey()).contains(GLOBAL_USER_INPUT)).findFirst().get().getValue();
            if (nodeInfo != null) {
                Map<String, String> outputVarsRepoReply = nodeInfo.getOutputVars();
                outMsg = outputVarsRepoReply.get(REPO_REPLY_OUT);
                if (StringUtils.isEmpty((String)outMsg) && (nodeInfo = ChatMemoryService.findNodeInfo(flowVar, ExecutionNodeType.LLM, ExecutionNodeType.LLM_QUESTION_CLASSIFY, ExecutionNodeType.LLM_QUESTION_REWRITE)) != null) {
                    Map<String, String> outputVarsLLM = nodeInfo.getOutputVars();
                    outMsg = outputVarsLLM.get("prompt_output");
                }
            } else {
                nodeInfo = ChatMemoryService.findNodeInfo(flowVar, ExecutionNodeType.LLM, ExecutionNodeType.LLM_QUESTION_CLASSIFY, ExecutionNodeType.LLM_QUESTION_REWRITE);
                if (nodeInfo != null) {
                    Map<String, String> outputVarsLLM = nodeInfo.getOutputVars();
                    outMsg = outputVarsLLM.get("prompt_output");
                }
            }
            if (!StringUtils.isNotEmpty((String)outMsg)) continue;
            logger.info("\u3010chat history\u3011get chat session history output message not exit");
            chatHistoryMessage.setUser(inputMsg);
            chatHistoryMessage.setAssistant(outMsg);
            historyMessages.add(chatHistoryMessage);
        }
        if (!historyMessages.isEmpty()) {
            Collections.reverse(historyMessages);
        }
        logger.info("\u3010chat history\u3011get chat session history message:{}", (Object)JsonUtil.toJson(historyMessages));
        return historyMessages;
    }

    private static NodeVariablesInfo findNodeInfo(List<NodeVariablesInfo> flowVar, ExecutionNodeType ... nodeTypes) {
        return flowVar.stream().filter(v -> Arrays.stream(nodeTypes).anyMatch(nodeType -> nodeType == v.getExecutionNodeType())).reduce((first, second) -> second).orElse(null);
    }

    public static List<ChatHistoryMessage> chatMsgCoversion(List<UserHistoryMessage> chatSessionHistory) {
        if (chatSessionHistory != null && !chatSessionHistory.isEmpty()) {
            ArrayList<ChatHistoryMessage> historyMessages = new ArrayList<ChatHistoryMessage>(chatSessionHistory.size() * 2);
            for (UserHistoryMessage message : chatSessionHistory) {
                String userMessage = message.getUser();
                String assistantMessage = message.getAssistant();
                ChatHistoryMessage msg = new ChatHistoryMessage(userMessage, assistantMessage);
                historyMessages.add(msg);
            }
            logger.info("\u3010chat history\u3011msg coversion:{} msg:{}.", (Object)JsonUtil.toJson(chatSessionHistory), (Object)JsonUtil.toJson(historyMessages));
            return historyMessages;
        }
        logger.warn("\u3010chat history\u3011history msg is null.");
        return Collections.EMPTY_LIST;
    }
}

