/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.menu;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ai.gai.core.menu.MenuDTO;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class KMSyncMenuTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(KMSyncMenuTask.class);
    private static final String CDZSK_NUMBER = "cdzsk_number";
    private static final String APP_IDS = "app_ids";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        if (!map.containsKey(CDZSK_NUMBER) || StringUtils.isEmpty((String)map.get(CDZSK_NUMBER).toString())) {
            logger.info(String.format("\u83dc\u5355\u77e5\u8bc6\u5e93\u540c\u6b65\u5931\u8d25\uff0c\u8bf7\u5728\u8c03\u5ea6\u4f5c\u4e1a\u91cc\u914d\u7f6e\u53c2\u6570%s\u7684\u503c", CDZSK_NUMBER));
            return;
        }
        String aikmNumber = "aikm_" + map.get(CDZSK_NUMBER).toString();
        String appIds = "";
        if (map.containsKey(APP_IDS)) {
            appIds = map.get(APP_IDS).toString();
        }
        logger.info(String.format("\u8c03\u5ea6\u4f5c\u4e1a\u53c2\u6570%s=%s\uff0c\u53c2\u6570%s=%s", CDZSK_NUMBER, aikmNumber, APP_IDS, appIds));
        String cdzskGroupNumber = aikmNumber + "_group";
        int removeInvalidMenuCount = this.removeInvalidMenu(aikmNumber);
        List<MenuDTO> listBizMenus = this.getBizMenus(appIds);
        List<MenuDTO> listKMMenus = this.getKMMenus(aikmNumber);
        List<MenuDTO> listAddedMenus = listBizMenus.stream().filter(o1 -> listKMMenus.stream().noneMatch(o2 -> o2.getMenuId().equals(o1.getMenuId()))).collect(Collectors.toList());
        this.addKMMenu(listAddedMenus, cdzskGroupNumber, aikmNumber);
        List<MenuDTO> listRemovedMenus = listKMMenus.stream().filter(o1 -> listBizMenus.stream().noneMatch(o2 -> o2.getMenuId().equals(o1.getMenuId()))).collect(Collectors.toList());
        this.removeKMMenus(listRemovedMenus, aikmNumber);
        List<MenuDTO> listModifiedMenus = listBizMenus.stream().filter(o1 -> listKMMenus.stream().anyMatch(o2 -> o2.getMenuId().equals(o1.getMenuId()) && (!o2.getMenuName().equals(o1.getMenuName()) || !o2.getDescription().equals(o1.getDescription())))).collect(Collectors.toList());
        this.modifyKMMenu(listModifiedMenus, aikmNumber);
        logger.info(String.format("\u83dc\u5355\u77e5\u8bc6\u5e93\u540c\u6b65\u5b8c\u6210\uff1a\u79fb\u9664\u65e0\u6548\u83dc\u5355%d\u9879\uff0c\u5171\u6dfb\u52a0\u83dc\u5355%d\u9879\uff0c\u5220\u9664\u83dc\u5355%d\u9879\uff0c\u4fee\u6539\u83dc\u5355%d\u9879\u3002", removeInvalidMenuCount, listAddedMenus.size(), listRemovedMenus.size(), listModifiedMenus.size()));
    }

    private void addAppHomeMenu(String appId, List<MenuDTO> listMenu) {
        try {
            String appDescription;
            AppInfo appInfo = AppMetadataCache.getAppInfo((String)appId);
            String appName = appInfo.getName().toString();
            appName = appName.replaceAll(" ", "");
            String appHomeNumber = appInfo.getHomeNum();
            String string = appDescription = appInfo.getDescription() != null ? appInfo.getDescription().getLocaleValue() : "";
            if (StringUtils.isEmpty((String)appHomeNumber)) {
                appHomeNumber = String.format("%s_%s", appId, "apphome");
            }
            MenuDTO menuDTO = new MenuDTO(appId, appName, appHomeNumber, appName + "\u9996\u9875", appDescription);
            listMenu.add(menuDTO);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    private void addAppBizMenu(String appId, List<AppMenuInfo> menus, List<MenuDTO> listMenu) {
        try {
            AppInfo appInfo = AppMetadataCache.getAppInfo((String)appId);
            if (menus == null) {
                menus = AppMetadataCache.getAppMenusInfoByAppId((String)appId);
            }
            menus.forEach(menu -> {
                if (StringUtils.isNotBlank((String)menu.getFormId()) && menu.getFormName() != null && menu.getName() != null) {
                    String appName = appInfo.getName().toString().replaceAll(" ", "");
                    String menuName = menu.getName().toString().replaceAll(" ", "");
                    String description = menu.getDescription() != null ? menu.getDescription().getLocaleValue() : "";
                    MenuDTO menuDTO = new MenuDTO(appId, appName, menu.getId(), menuName, description);
                    listMenu.add(menuDTO);
                }
            });
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    private List<MenuDTO> getBizMenus(String appIds) {
        ArrayList<MenuDTO> listBizMenus = new ArrayList<MenuDTO>();
        if (!StringUtils.isEmpty((String)appIds)) {
            String[] arrAppId;
            for (String appId2 : arrAppId = appIds.split(",")) {
                this.addAppHomeMenu(appId2, listBizMenus);
                this.addAppBizMenu(appId2, null, listBizMenus);
            }
        } else {
            Map allAppMenus = AppMetadataCache.getAllAppMenus();
            allAppMenus.forEach((appId, menus) -> {
                this.addAppHomeMenu((String)appId, (List<MenuDTO>)listBizMenus);
                this.addAppBizMenu((String)appId, (List<AppMenuInfo>)menus, (List<MenuDTO>)listBizMenus);
            });
        }
        return listBizMenus;
    }

    private List<MenuDTO> getKMMenus(String aikmNumber) {
        ArrayList<MenuDTO> listKMMenus = new ArrayList<MenuDTO>();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"AIKMMenuService_getList_Chunk", (String)aikmNumber, (String)"id,segmententity.segment_tag", null, (String)"createtime,segmententity.seq");){
            for (Row row : ds) {
                String[] chunks;
                String chunk = row.getString("segmententity.segment_tag");
                if (!StringUtils.isNotBlank((String)chunk) || (chunks = chunk.split("\\|")).length < 4) continue;
                String appId = chunks[0];
                String appName = chunks[1];
                String menuId = chunks[2];
                String menuName = chunks[3];
                String description = "";
                if (chunks.length == 5) {
                    description = chunks[4];
                }
                listKMMenus.add(new MenuDTO(appId, appName, menuId, menuName, description));
            }
        }
        return listKMMenus;
    }

    private int removeInvalidMenu(String aikmNumber) {
        int successCount = 0;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"AIKMMenuService_deleteInvalidList_Chunk", (String)aikmNumber, (String)"id,status,uploadstatus", (QFilter[])new QFilter[]{new QFilter("status", "=", (Object)"C").and(new QFilter("uploadstatus", "=", (Object)"I"))}, (String)"");){
            for (Row row : ds) {
                Long id = row.getLong("id");
                OperationResult opResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)aikmNumber, (Object[])new Object[]{id});
                List validResult = opResult.getAllErrorOrValidateInfo();
                if (!validResult.isEmpty()) {
                    logger.error(opResult.getMessage());
                }
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)aikmNumber);
                DeleteServiceHelper.delete((IDataEntityType)dt, (Object[])new Object[]{id});
                ++successCount;
            }
        }
        logger.info(String.format("\u672c\u6b21\u5171\u5220\u9664%d\u4e2a\u65e0\u6548\u83dc\u5355", successCount));
        return successCount;
    }

    private void modifyKMMenu(List<MenuDTO> menus, String aikmNumber) {
        if (menus.isEmpty()) {
            return;
        }
        int successCount = 0;
        for (MenuDTO menu : menus) {
            Object[] fidArrays;
            OperationResult opResult;
            List validResult;
            Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)aikmNumber, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)menu.getMenuId())});
            if (objectDynamicObjectMap.isEmpty()) continue;
            DynamicObject data = (DynamicObject)objectDynamicObjectMap.values().iterator().next();
            if (data.getString("status").equals("C") && !(validResult = (opResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)aikmNumber, (Object[])new Object[]{data.getPkValue()})).getAllErrorOrValidateInfo()).isEmpty()) {
                logger.error(opResult.getMessage());
            }
            data.set("name", (Object)menu.getMenuName());
            String description = menu.getDescription();
            String appId = menu.getAppId();
            String appName = menu.getAppName();
            String menuId = menu.getMenuId();
            String menuName = menu.getMenuName();
            String seg = "";
            seg = !StringUtils.isEmpty((String)menu.getDescription()) ? String.format("%s|%s|%s|%s|%s", appId, appName, menuId, menuName, description) : String.format("%s|%s|%s|%s", appId, appName, menuId, menuName);
            data.set("inputcontent_tag", (Object)seg);
            DynamicObjectCollection segmentEntities = data.getDynamicObjectCollection("segmententity");
            if (segmentEntities.size() > 0) {
                ((DynamicObject)segmentEntities.get(0)).set("segment_tag", (Object)seg);
            }
            Object[] ids = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{data});
            ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>();
            dynamicObjects.add(data);
            DynamicObject[] dynamicObjArrays = new DynamicObject[]{};
            OperateOption option = OperateOption.create();
            option.setVariableValue("isNeedSplit", "true");
            OperationResult opResult2 = OperationServiceHelper.executeOperate((String)"submit", (String)aikmNumber, (DynamicObject[])dynamicObjects.toArray(dynamicObjArrays), (OperateOption)option);
            List fids = opResult2.getSuccessPkIds();
            OperationResult audit = OperationServiceHelper.executeOperate((String)"audit", (String)aikmNumber, (Object[])fids.toArray(fidArrays = new Object[0]));
            if (!audit.isSuccess()) continue;
            ++successCount;
        }
        logger.info(String.format("\u672c\u6b21\u5171\u4fee\u6539%d\u4e2a\u83dc\u5355\uff0c\u6210\u529f%d\u6761", menus.size(), successCount));
    }

    private void removeKMMenus(List<MenuDTO> menus, String aikmNumber) {
        if (menus.isEmpty()) {
            return;
        }
        int successCount = 0;
        for (MenuDTO menu : menus) {
            DataSet ds = QueryServiceHelper.queryDataSet((String)"AIKMMenuService_deleteList_Chunk", (String)aikmNumber, (String)"id,status", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)menu.getMenuId())}, (String)"");
            Throwable throwable = null;
            try {
                OperationResult opResult;
                List validResult;
                if (!ds.hasNext()) continue;
                Row data = (Row)ds.iterator().next();
                Long id = data.getLong("id");
                if (data.getString("status").equals("C") && !(validResult = (opResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)aikmNumber, (Object[])new Object[]{id})).getAllErrorOrValidateInfo()).isEmpty()) {
                    logger.error(opResult.getMessage());
                }
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)aikmNumber);
                DeleteServiceHelper.delete((IDataEntityType)dt, (Object[])new Object[]{id});
                ++successCount;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ds == null) continue;
                if (throwable != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ds.close();
            }
        }
        logger.info(String.format("\u672c\u6b21\u5171\u5220\u9664%d\u4e2a\u83dc\u5355\uff0c\u6210\u529f%d\u6761", menus.size(), successCount));
    }

    private void addKMMenu(List<MenuDTO> menus, String cdzskGroupNumber, String cdzskNumber) {
        if (menus.isEmpty()) {
            return;
        }
        ArrayList datas = new ArrayList();
        menus.forEach(menu -> {
            long pkId = ID.genLongId();
            Long groupId = KMSyncMenuTask.getDefaultGroupId(cdzskGroupNumber);
            DynamicObject data = BusinessDataServiceHelper.newDynamicObject((String)cdzskNumber);
            data.set("status", (Object)"A");
            data.set("id", (Object)pkId);
            data.set("masterid", (Object)pkId);
            data.set("number", (Object)menu.getMenuId());
            data.set("name", (Object)menu.getMenuName());
            data.set("type", (Object)"common");
            data.set("enable", (Object)1);
            data.set("creator_id", (Object)RequestContext.get().getCurrUserId());
            data.set("org_id", (Object)OrgUnitServiceHelper.getRootOrgId());
            data.set("group_id", (Object)groupId);
            data.set("uploadstatus", (Object)"I");
            String menuId = menu.getMenuId();
            String appId = menu.getAppId();
            String appName = menu.getAppName();
            String menuName = menu.getMenuName();
            String description = menu.getDescription();
            String seg = "";
            seg = !StringUtils.isEmpty((String)menu.getDescription()) ? String.format("%s|%s|%s|%s|%s", appId, appName, menuId, menuName, description) : String.format("%s|%s|%s|%s", appId, appName, menuId, menuName);
            DynamicObjectCollection segmentEntities = data.getDynamicObjectCollection("segmententity");
            DynamicObject segObj = segmentEntities.addNew();
            segObj.set("segment_tag", (Object)seg);
            segObj.set("seq", (Object)1);
            segObj.set("creatway", (Object)"1");
            segObj.set("segmenttype", (Object)"TEXT");
            data.set("inputcontent_tag", (Object)seg);
            datas.add(data);
        });
        DynamicObject[] dynamicObjArrays = datas.toArray(new DynamicObject[0]);
        OperateOption option = OperateOption.create();
        option.setVariableValue("isNeedSplit", "true");
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)cdzskNumber, (DynamicObject[])dynamicObjArrays, (OperateOption)option);
        List successPkIds = saveResult.getSuccessPkIds();
        if (saveResult.isSuccess() && !successPkIds.isEmpty()) {
            OperationResult opResult = OperationServiceHelper.executeOperate((String)"submit", (String)cdzskNumber, (Object[])successPkIds.toArray(new Object[0]), (OperateOption)option);
            List fids = opResult.getSuccessPkIds();
            Object[] fidArrays = new Object[]{};
            OperationServiceHelper.executeOperate((String)"audit", (String)cdzskNumber, (Object[])fids.toArray(fidArrays));
            logger.info(String.format("\u672c\u6b21\u5171\u65b0\u589e%d\u4e2a\u83dc\u5355\uff0c\u6210\u529f%d\u6761", dynamicObjArrays.length, fids.size()));
        }
    }

    private static Long getDefaultGroupId(String groupNumber) {
        Long groupId = 0L;
        Map data = BusinessDataReader.loadFromCache((String)groupNumber, null);
        if (!data.isEmpty()) {
            DynamicObject first = (DynamicObject)data.values().iterator().next();
            groupId = first.getLong("id");
        }
        return groupId;
    }
}

