/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.menu;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.ai.gai.core.engine.EngineCache;
import kd.ai.gai.core.menu.MenuDTO;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.CloudMetadataCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.form.gpt.IGPTAction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.StringUtils;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class MenuAction
implements IGPTAction {
    private static final String GET_MENUS = "get_menus";
    private static final String CREATE_MENU_LINK = "create_menu_link";
    private static final String OPEN_MENU = "open_menu";
    private static final String CREATE_AUTOOPEN_MENU_LINK = "create_autoopen_menu_link";
    private static final String LISTSHOWPARAMETER = "ListShowParameter";
    private static final String FORMSHOWPARAMETER = "FormShowParameter";
    private static final String BILLSHOWPARAMETER = "BillShowParameter";
    private static final String REPORTSHOWPARAMETER = "ReportShowParameter";
    private static final Log logger = LogFactory.getLog(MenuAction.class);
    private static final Pattern BillFormId_Pattern = Pattern.compile("\"billFormId\":\"([^\"]*)\"");
    private static final String[] ArrayOperator = new String[]{"\u6253\u5f00", "\u65b0\u589e", "\u67e5\u770b", "\u6dfb\u52a0"};

    public Map<String, String> invokeAction(String s, Map<String, String> map) {
        switch (s) {
            case "get_menus": {
                return this.getMenus(map);
            }
            case "create_menu_link": {
                return this.createMenuLink(map);
            }
            case "open_menu": {
                return this.openMenu(map);
            }
            case "create_autoopen_menu_link": {
                return this.createAutoOpenMenuLink(map);
            }
        }
        return null;
    }

    private Map<String, String> openMenu(Map<String, String> map) {
        HashMap<String, String> mapReturn = new HashMap<String, String>();
        String menuJson = map.get("menu_json");
        String input = map.get("input");
        return mapReturn;
    }

    private Map<String, String> getMenus(Map<String, String> map) {
        HashMap<String, String> mapReturn = new HashMap<String, String>();
        String menuJson = map.get("menu_json");
        String userInput = map.get("input");
        int menuCount = Integer.parseInt(map.get("menu_count"));
        ArrayList<MenuDTO> listMenusByAppNameAndMenuName = new ArrayList<MenuDTO>();
        ArrayList<MenuDTO> listMenusByOther = new ArrayList<MenuDTO>();
        if (StringUtils.isNotBlank((String)menuJson)) {
            ArrayList arrayList = (ArrayList)SerializationUtils.fromJsonString((String)menuJson, ArrayList.class);
            int menuIndex = 1;
            for (LinkedHashMap chunkMap : arrayList) {
                String[] chunks;
                if (menuIndex > menuCount) break;
                String chunk = chunkMap.get("chunk").toString();
                if (StringUtils.isNotBlank((String)chunk) && (chunks = chunk.split("\\|")).length >= 4) {
                    AppMenuInfo appMenuInfo;
                    String formId;
                    boolean hasPerm;
                    String appId = chunks[0];
                    String appName = chunks[1];
                    String menuId = chunks[2];
                    String menuName = chunks[3];
                    String description = "";
                    if (chunks.length == 5) {
                        description = chunks[4];
                    }
                    String appHomeNumber = AppMetadataCache.getAppInfo((String)appId).getHomeNum();
                    StringBuilder sbError = new StringBuilder();
                    if (menuId.equals(appHomeNumber) && !(hasPerm = this.CheckPerm(appId, menuId, formId = menuId, "", sbError)) || StringUtils.isNotBlank((String)appId) && StringUtils.isNotBlank((String)menuId) && (appMenuInfo = AppMetadataCache.getAppMenuInfoByAppNumAndMenuId((String)appId, (String)menuId)) != null && !(hasPerm = this.CheckPerm(appId, menuId, appMenuInfo.getFormId(), appMenuInfo.getParamType(), sbError))) continue;
                    MenuDTO menuDTO = new MenuDTO(appId, appName, menuId, menuName, description);
                    userInput = userInput.toLowerCase();
                    appId = appId.toLowerCase();
                    appName = appName.toLowerCase();
                    menuName = menuName.toLowerCase();
                    if ((userInput = this.replaceOperator(userInput)).equals(menuName) || userInput.contains(String.format("%s %s", appName, menuName)) || userInput.contains(String.format("%s %s", appId, menuName)) || userInput.contains(String.format("%s%s", appId, menuName)) || userInput.contains(String.format("%s%s", appName, menuName)) || menuId.equals(appHomeNumber) && ((userInput + "\u9996\u9875").equals(appName) || userInput.equals(appName))) {
                        listMenusByAppNameAndMenuName.add(menuDTO);
                    } else {
                        listMenusByOther.add(menuDTO);
                    }
                }
                ++menuIndex;
            }
        }
        if (listMenusByAppNameAndMenuName.size() > 0) {
            mapReturn.put("filter_menu_json", SerializationUtils.toJsonString(listMenusByAppNameAndMenuName));
        } else {
            mapReturn.put("filter_menu_json", SerializationUtils.toJsonString(listMenusByOther));
        }
        return mapReturn;
    }

    private Map<String, String> createMenuLink(Map<String, String> map) {
        HashMap<String, String> mapReturn = new HashMap<String, String>();
        String menuJson = map.get("menu_json");
        int menuCount = Integer.parseInt(map.get("menu_count"));
        if (StringUtils.isNotBlank((String)menuJson)) {
            ArrayList arrayList = (ArrayList)SerializationUtils.fromJsonString((String)menuJson, ArrayList.class);
            int linkIndex = 1;
            for (LinkedHashMap mapMenu : arrayList) {
                AppMenuInfo appMenuInfo;
                String menuId = mapMenu.get("menuId").toString();
                String appId = mapMenu.get("appId").toString();
                String appName = mapMenu.get("appName").toString();
                String menuName = mapMenu.get("menuName").toString();
                String appHomeNumber = AppMetadataCache.getAppInfo((String)appId).getHomeNum();
                String cloudName = this.getCloudName(appId);
                String title = menuName;
                String remark = String.format("%s-%s", cloudName, appName);
                if (menuId.equals(appHomeNumber)) {
                    String link = String.format("bizAction://currentPage?gaiShow=0&selectedProcessNumber=processNumber&gaiAction=showBillForm&gaiParams= {\"appId\":\"%s\",\"billFormId\":\" \",\"billPkId\":\" \",\"menuId\":\"home\"}&title=%s&remark=%s&iconType=web&method=bizAction", appId, title, remark);
                    mapReturn.put("link" + linkIndex++, link);
                    continue;
                }
                if (!StringUtils.isNotBlank((String)appId) || !StringUtils.isNotBlank((String)menuId) || (appMenuInfo = AppMetadataCache.getAppMenuInfoByAppNumAndMenuId((String)appId, (String)menuId)) == null) continue;
                IAppCache appCache = EngineCache.getAppCache("menu_search");
                String replaceMenuId = this.replaceSpecialChar(menuId);
                if (!replaceMenuId.equals(menuId)) {
                    appCache.put(replaceMenuId, (Object)menuId);
                }
                String link = String.format("bizAction://currentPage?gaiShow=0&selectedProcessNumber=processNumber&gaiAction=showBillForm&gaiParams= {\"appId\":\"%s\",\"billFormId\":\" \",\"billPkId\":\" \",\"menuId\":\"%s\"}&title=%s&remark=%s&iconType=web&method=bizAction", appId, replaceMenuId, title, remark);
                mapReturn.put("link" + linkIndex++, link);
            }
            for (int i = 1; i <= menuCount; ++i) {
                if (mapReturn.containsKey("link" + i)) continue;
                String hideLink = "bizAction://currentPage?gaiShow=0&selectedProcessNumber=processNumber&gaiAction=showBillForm&gaiParams= {\"appId\":\"\",\"billFormId\":\" \",\"billPkId\":\" \",\"menuId\":\"\"}&title=&iconType=web&method=bizAction&hide=true";
                mapReturn.put("link" + i, hideLink);
            }
        }
        return mapReturn;
    }

    private Map<String, String> createAutoOpenMenuLink(Map<String, String> map) {
        HashMap<String, String> mapReturn = new HashMap<String, String>();
        String menuJson = map.get("menu_json");
        if (StringUtils.isNotBlank((String)menuJson)) {
            ArrayList arrayList = (ArrayList)SerializationUtils.fromJsonString((String)menuJson, ArrayList.class);
            for (LinkedHashMap mapMenu : arrayList) {
                AppMenuInfo appMenuInfo;
                String menuId = mapMenu.get("menuId").toString();
                String appId = mapMenu.get("appId").toString();
                String appName = mapMenu.get("appName").toString();
                String menuName = mapMenu.get("menuName").toString();
                String appHomeNumber = AppMetadataCache.getAppInfo((String)appId).getHomeNum();
                String cloudName = this.getCloudName(appId);
                String title = menuName;
                String remark = String.format("%s-%s", cloudName, appName);
                if (menuId.equals(appHomeNumber)) {
                    String link = String.format("bizAction://currentPage?gaiShow=0&selectedProcessNumber=processNumber&gaiAction=showBillForm&gaiParams= {\"appId\":\"%s\",\"billFormId\":\" \",\"billPkId\":\" \",\"menuId\":\"home\"}&open=true&title=%s&remark=%s&iconType=web&method=bizAction", appId, title, remark);
                    mapReturn.put("link", link);
                    continue;
                }
                if (!StringUtils.isNotBlank((String)appId) || !StringUtils.isNotBlank((String)menuId) || (appMenuInfo = AppMetadataCache.getAppMenuInfoByAppNumAndMenuId((String)appId, (String)menuId)) == null) continue;
                IAppCache appCache = EngineCache.getAppCache("menu_search");
                String replaceMenuId = this.replaceSpecialChar(menuId);
                if (!replaceMenuId.equals(menuId)) {
                    appCache.put(replaceMenuId, (Object)menuId);
                }
                String link = String.format("bizAction://currentPage?gaiShow=0&selectedProcessNumber=processNumber&gaiAction=showBillForm&gaiParams= {\"appId\":\"%s\",\"billFormId\":\" \",\"billPkId\":\" \",\"menuId\":\"%s\"}&open=true&title=%s&remark=%s&iconType=web&method=bizAction", appId, replaceMenuId, title, remark);
                mapReturn.put("link", link);
            }
        }
        return mapReturn;
    }

    private String replaceSpecialChar(String str) {
        String specialStr = "[#?=&.]";
        return str.replaceAll(specialStr, "");
    }

    private boolean containsOperator(String input) {
        for (String s : ArrayOperator) {
            if (!input.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    private String replaceOperator(String input) {
        for (String s : ArrayOperator) {
            if (!input.startsWith(s)) continue;
            input = input.replaceAll(String.format("[%s \\s]", s), "");
        }
        return input;
    }

    private String getCloudName(String appId) {
        String cloudId = AppMetadataCache.getAppInfo((String)appId).getCloudNum();
        AtomicReference<String> cloudName = new AtomicReference<String>("");
        Map allCloudInfo = CloudMetadataCache.getAllCloudInfo();
        allCloudInfo.forEach((id, cloudInfo) -> {
            if (cloudId.equals(id)) {
                cloudName.set(cloudInfo.getName().getLocaleValue());
            }
        });
        return cloudName.get();
    }

    private boolean CheckPerm(String appId, String menuId, String formId, String paramType, StringBuilder error) {
        boolean hasPerm = false;
        try {
            Long userId = Long.valueOf(RequestContext.get().getUserId());
            Boolean aBoolean = PermissionServiceHelper.checkUserBizApp((Long)userId, (String)appId);
            if (aBoolean == Boolean.TRUE) {
                if (StringUtils.isBlank((String)paramType)) {
                    hasPerm = true;
                } else {
                    boolean isAdmin = PermissionServiceHelper.isAdminUser((long)userId);
                    List listAllNoPermMenuIds = PermissionServiceHelper.getAllNoPermMenuIdsByAppId((Long)userId, (String)AppMetadataCache.getAppInfo((String)appId).getId());
                    if (listAllNoPermMenuIds.contains(menuId)) {
                        return false;
                    }
                    boolean hasAddPerm = PermissionServiceHelper.hasNewPermission((long)userId, (String)appId, (String)formId);
                    boolean hasViewPerm = PermissionServiceHelper.hasViewPermission((long)userId, (String)appId, (String)formId);
                    if (paramType.equals(LISTSHOWPARAMETER) || paramType.equals(REPORTSHOWPARAMETER) || paramType.equals(BILLSHOWPARAMETER)) {
                        if (isAdmin || hasViewPerm) {
                            hasPerm = true;
                        }
                    } else if (paramType.equals(FORMSHOWPARAMETER) && (isAdmin || hasAddPerm)) {
                        hasPerm = true;
                    }
                }
            }
        }
        catch (Exception exception) {
            logger.error(exception.getMessage());
            error.append("\u3010\u8868\u5355\u6e90\u6570\u636e\u9519\u8bef\u3011");
        }
        return hasPerm;
    }

    public static String getBillFormId(String params) {
        if (StringUtils.isEmpty((String)params)) {
            return "";
        }
        Matcher matcher = BillFormId_Pattern.matcher(params);
        if (matcher.find()) {
            String billFormId = matcher.group(1);
            return billFormId;
        }
        return "";
    }
}

