/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.nl2filter;

import java.util.ArrayList;
import java.util.Map;
import kd.ai.gai.core.nl2filter.Filter;
import kd.ai.gai.core.nl2filter.FilterCondition;
import kd.ai.gai.core.nl2filter.IFilterPostProcessor;
import kd.ai.gai.core.nl2filter.NL2FilterService;
import kd.ai.gai.core.search.helper.StructuredRepoServiceHelper;
import kd.ai.gai.core.search.index.param.structured.SearchStructuredDataParam;
import kd.ai.gai.core.search.index.param.structured.StructuredRowData;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class BaseDataMatchProcessor
implements IFilterPostProcessor {
    private static final Log LOG = LogFactory.getLog(NL2FilterService.class);

    @Override
    public Filter postProcess(String entityNumber, Filter filter) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        for (FilterCondition item : filter.getConditions()) {
            this.matchBaseData(mainEntityType, item);
        }
        return filter;
    }

    public void matchBaseData(MainEntityType mainEntityType, FilterCondition condition) {
        DynamicObject structRepo;
        EntryProp entry;
        DynamicObjectType entryEntityType;
        DynamicProperty property2;
        DynamicProperty property;
        CharSequence[] propertyValues = condition.getProperty().split("\\.");
        String baseDataEntityNumber = null;
        if (propertyValues.length == 2) {
            property = mainEntityType.getProperty(propertyValues[0]);
            if (property instanceof BasedataProp) {
                BasedataProp basedataProp = (BasedataProp)property;
                baseDataEntityNumber = basedataProp.getBaseEntityId();
                propertyValues[1] = "id";
            }
        } else if (propertyValues.length == 3 && (property = mainEntityType.getProperty(propertyValues[0])) instanceof EntryProp && (property2 = (entryEntityType = (entry = (EntryProp)property).getDynamicCollectionItemPropertyType()).getProperty(propertyValues[1])) instanceof BasedataProp) {
            BasedataProp basedataProp = (BasedataProp)property2;
            baseDataEntityNumber = basedataProp.getBaseEntityId();
            propertyValues[2] = "id";
        }
        if (baseDataEntityNumber != null && (structRepo = this.getStructRepository(baseDataEntityNumber)) != null) {
            SearchStructuredDataParam param = new SearchStructuredDataParam(structRepo.getLong("id"), condition.getValue().toString(), 10, 0.8f, true);
            StructuredRowData result = StructuredRepoServiceHelper.search(param);
            if (!result.getDataList().isEmpty()) {
                ArrayList<Object> ids = new ArrayList<Object>(result.getDataList().size());
                for (Map<String, Object> map : result.getDataList()) {
                    ids.add(map.get("id"));
                }
                condition.setProperty(String.join((CharSequence)".", propertyValues));
                condition.setOperator("in");
                condition.setValue(ids);
            } else {
                LOG.warn("\u5728\u77e5\u8bc6\u5e93{}\u4e2d\uff0c\u6ca1\u6709\u627e\u5230\u57fa\u7840\u8d44\u6599{}\uff1a{}", new Object[]{structRepo.getString("number"), baseDataEntityNumber, condition.getValue()});
            }
        }
    }

    public DynamicObject getStructRepository(String entityNumber) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter filterStatus = new QFilter("srcbizobject", "=", (Object)entityNumber);
        filters.add(filterStatus);
        QFilter serviceFilter = new QFilter("enable", "=", (Object)"1");
        filters.add(serviceFilter);
        return QueryServiceHelper.queryOne((String)"gai_struct_repo", (String)"id,number", (QFilter[])filters.toArray(new QFilter[0]));
    }
}

