/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.nl2filter;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import kd.ai.gai.core.nl2filter.Filter;
import kd.ai.gai.core.nl2filter.FilterCondition;
import kd.ai.gai.core.nl2filter.IFilterPostProcessor;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.MetadataServiceHelper;

public class DateProcessor
implements IFilterPostProcessor {
    public static final ErrorCode PARSE_DATE_ERROR = new ErrorCode("gai.parse_date_error", ResManager.loadKDString((String)"\u89e3\u6790\u65e5\u671f\u5931\u8d25", (String)"gai.parse_date_error", (String)"ai-gai-core", (Object[])new Object[0]));

    @Override
    public Filter postProcess(String entityNumber, Filter filter) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        for (FilterCondition condition : filter.getConditions()) {
            DynamicProperty fieldProperty = mainEntityType.getProperty(condition.getProperty());
            if (fieldProperty instanceof DateProp && condition.getValue() instanceof String) {
                try {
                    condition.setValue(dateFormat.parse((String)condition.getValue()));
                    continue;
                }
                catch (ParseException e) {
                    throw new KDBizException(new ErrorCode("gai.parse_date_error", String.format(ResManager.loadKDString((String)"\u89e3\u6790\u65e5\u671f\u5931\u8d25", (String)"gai.parse_date_error", (String)"ai-gai-core", (Object[])new Object[0]), condition.getValue())), new Object[0]);
                }
            }
            if (!(fieldProperty instanceof DateTimeProp) || !(condition.getValue() instanceof String)) continue;
            try {
                condition.setValue(dateTimeFormat.parse((String)condition.getValue()));
            }
            catch (ParseException e) {
                try {
                    condition.setValue(dateFormat.parse((String)condition.getValue()));
                }
                catch (ParseException e1) {
                    throw new KDBizException(new ErrorCode("gai.parse_datetime_error", String.format(ResManager.loadKDString((String)"\u89e3\u6790\u65e5\u671f\u65f6\u95f4\u5931\u8d25", (String)"gai.parse_datetime_error", (String)"ai-gai-core", (Object[])new Object[0]), condition.getValue())), new Object[0]);
                }
            }
        }
        return filter;
    }
}

