/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.nl2filter;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.List;
import kd.ai.gai.core.nl2filter.BaseDataMatchProcessor;
import kd.ai.gai.core.nl2filter.DateProcessor;
import kd.ai.gai.core.nl2filter.Filter;
import kd.ai.gai.core.nl2filter.FilterCondition;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class NL2FilterService {
    private static final Log LOG = LogFactory.getLog(NL2FilterService.class);
    public static final ErrorCode JSON_FORMAT_ERROR = new ErrorCode("gai.json_format_error", ResManager.loadKDString((String)"\u9519\u8bef\u7684JSON\u683c\u5f0f", (String)"gai.json_format_error", (String)"ai-gai-core", (Object[])new Object[0]));

    public DynamicObject[] queryData(String entityNumber, String selectProperties, Filter filter) {
        filter = this.postProcessFilter(entityNumber, filter);
        QFilter[] qFilters = this.convertFilter(filter).toArray(new QFilter[0]);
        return BusinessDataServiceHelper.load((String)entityNumber, (String)selectProperties, (QFilter[])qFilters);
    }

    public Filter parseFilter(String entityNumber, String llmJSONResult) {
        List conditions;
        if (StringUtils.isEmpty((String)llmJSONResult)) {
            LOG.warn("\u53c2\u6570\u4e3a\u7a7a");
            return null;
        }
        int startIndex = llmJSONResult.indexOf(91);
        int lastIndex = llmJSONResult.lastIndexOf(93);
        if (startIndex < 1 || lastIndex < startIndex + 1) {
            throw new KDBizException(JSON_FORMAT_ERROR, new Object[]{llmJSONResult});
        }
        try {
            conditions = JSONArray.parseArray((String)llmJSONResult.substring(startIndex, lastIndex + 1), FilterCondition.class);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            throw new KDBizException(JSON_FORMAT_ERROR, new Object[]{llmJSONResult});
        }
        Filter filter = new Filter();
        filter.setConditions(conditions);
        return filter;
    }

    public Filter postProcessFilter(String entityNumber, Filter filter) {
        BaseDataMatchProcessor baseDataProcessor = new BaseDataMatchProcessor();
        Filter processedFilter = baseDataProcessor.postProcess(entityNumber, filter);
        DateProcessor dateProcessor = new DateProcessor();
        processedFilter = dateProcessor.postProcess(entityNumber, processedFilter);
        return processedFilter;
    }

    public DynamicObject[] queryData(String entityNumber, String selectProperties, QFilter[] filter) {
        return BusinessDataServiceHelper.load((String)entityNumber, (String)selectProperties, (QFilter[])filter);
    }

    public List<QFilter> convertFilter(Filter filter) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(filter.getConditions().size());
        for (FilterCondition condition : filter.getConditions()) {
            filters.add(new QFilter(condition.getProperty(), condition.getOperator(), condition.getValue()));
        }
        return filters;
    }
}

