/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.privacy;

import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.ai.gai.core.code.GaiErrorCode;
import kd.ai.gai.core.code.GaiExceptionUtil;
import kd.ai.gai.core.privacy.model.AgreementCache;
import kd.ai.gai.core.privacy.model.PrivacyAgreeRecord;
import kd.ai.gai.core.privacy.model.PrivacyAgreement;
import kd.ai.gai.core.privacy.model.PrivacyAgreementType;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.io.IOUtils;

public class PrivacyAgreementService {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PrivacyAgreement getPrivacyAgreement(PrivacyAgreementType agreementType) {
        PrivacyAgreement agreement = null;
        agreement = AgreementCache.getInstance().getAgreement(agreementType);
        if (agreement != null) {
            return agreement;
        }
        GaiErrorCode errorCode = agreementType == PrivacyAgreementType.TENANT_PRIVACY_AGREEMENT ? GaiErrorCode.PRIVACY_ERR_TENANTE_AGREEMENT_LOAD_FAILED : GaiErrorCode.PRIVACY_ERR_USER_AGREEMENT_LOAD_FAILED;
        try (InputStream in = PrivacyAgreementService.class.getClassLoader().getResourceAsStream("META-INF/kd/ai/gai/AgreementContent.json");){
            if (in == null) {
                GaiExceptionUtil.throwFormatGaiException(errorCode, new Object[0]);
                PrivacyAgreement privacyAgreement = null;
                return privacyAgreement;
            }
            String jsonStr = IOUtils.toString((InputStream)in, (String)"UTF-8");
            if (StringUtils.isEmpty((CharSequence)jsonStr)) {
                GaiExceptionUtil.throwFormatGaiException(errorCode, new Object[0]);
                PrivacyAgreement privacyAgreement = null;
                return privacyAgreement;
            }
            JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
            JSONObject agreementJson = jsonObject.getJSONObject(agreementType.getKey());
            String version = agreementJson.getString("version");
            String content = agreementJson.getString("content");
            agreement = new PrivacyAgreement(version, content);
            AgreementCache.getInstance().putAgreement(agreementType, agreement);
            PrivacyAgreement privacyAgreement = agreement;
            return privacyAgreement;
        }
        catch (Exception e) {
            GaiExceptionUtil.throwFormatGaiException(e, errorCode, new Object[0]);
            return null;
        }
    }

    private static String getPrivacyAgreementVersion(PrivacyAgreementType agreementType) {
        PrivacyAgreement agreement = PrivacyAgreementService.getPrivacyAgreement(agreementType);
        return agreement == null ? "" : agreement.getVersion();
    }

    public static boolean signTenantPrivacyAgreement(String tenantId, long userId, boolean bSginOrUnSign) {
        String version = PrivacyAgreementService.getPrivacyAgreementVersion(PrivacyAgreementType.TENANT_PRIVACY_AGREEMENT);
        if (StringUtils.isEmpty((CharSequence)version)) {
            return false;
        }
        DynamicObject tenantAgreement = BusinessDataServiceHelper.newDynamicObject((String)"gai_tenant_agreement");
        tenantAgreement.set("tenantid", (Object)tenantId);
        tenantAgreement.set("user", (Object)userId);
        tenantAgreement.set("isagree", (Object)bSginOrUnSign);
        Date agreetime = new Date();
        tenantAgreement.set("agreetime", (Object)agreetime);
        tenantAgreement.set("agreetimestamp", (Object)agreetime.getTime());
        tenantAgreement.set("version", (Object)version);
        Object[] objs = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tenantAgreement});
        return objs != null && objs.length > 0;
    }

    public static boolean signUserPrivacyPolicy(long userId, boolean bSginOrUnSign) {
        String version = PrivacyAgreementService.getPrivacyAgreementVersion(PrivacyAgreementType.USER_PRIVACY_POLICY);
        if (StringUtils.isEmpty((CharSequence)version)) {
            return false;
        }
        DynamicObject userAgreement = BusinessDataServiceHelper.newDynamicObject((String)"gai_user_agreement");
        userAgreement.set("user", (Object)userId);
        userAgreement.set("isagree", (Object)bSginOrUnSign);
        Date agreetime = new Date();
        userAgreement.set("agreetime", (Object)agreetime);
        userAgreement.set("agreetimestamp", (Object)agreetime.getTime());
        userAgreement.set("version", (Object)version);
        Object[] objs = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{userAgreement});
        return objs != null && objs.length > 0;
    }

    public static List<PrivacyAgreeRecord> getTenantPrivacyAgreeRecords() {
        StringBuilder sbSelectedFields = new StringBuilder();
        sbSelectedFields.append("tenantid,");
        sbSelectedFields.append("user,");
        sbSelectedFields.append("version,");
        sbSelectedFields.append("isagree,");
        sbSelectedFields.append("agreetime,");
        sbSelectedFields.append("agreetimestamp");
        String tenantId = RequestContext.get().getTenantId();
        DynamicObject[] records = BusinessDataServiceHelper.load((String)"gai_tenant_agreement", (String)sbSelectedFields.toString(), (QFilter[])new QFilter[]{new QFilter("tenantid", "=", (Object)tenantId)}, (String)String.format("%s desc,%s desc", "agreetime", "agreetimestamp"));
        ArrayList<PrivacyAgreeRecord> recordList = new ArrayList<PrivacyAgreeRecord>(records.length);
        for (DynamicObject record : records) {
            recordList.add(PrivacyAgreeRecord.fromDynamicObject(PrivacyAgreementType.TENANT_PRIVACY_AGREEMENT, record));
        }
        return recordList;
    }

    public static List<PrivacyAgreeRecord> getUserPolicyAgreeRecords(long userId) {
        StringBuilder sbSelectedFields = new StringBuilder();
        sbSelectedFields.append("user,");
        sbSelectedFields.append("version,");
        sbSelectedFields.append("isagree,");
        sbSelectedFields.append("agreetime,");
        sbSelectedFields.append("agreetimestamp");
        DynamicObject[] records = BusinessDataServiceHelper.load((String)"gai_user_agreement", (String)sbSelectedFields.toString(), (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userId)}, (String)String.format("%s desc,%s desc", "agreetime", "agreetimestamp"));
        ArrayList<PrivacyAgreeRecord> recordList = new ArrayList<PrivacyAgreeRecord>(records.length);
        for (DynamicObject record : records) {
            recordList.add(PrivacyAgreeRecord.fromDynamicObject(PrivacyAgreementType.USER_PRIVACY_POLICY, record));
        }
        return recordList;
    }
}

