/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.rag;

import java.util.ArrayList;
import java.util.List;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.repo.RepoChunkDataPreRule;
import kd.ai.gai.core.enuz.repo.RepoChunkEmbeddingRule;
import kd.ai.gai.core.enuz.repo.RepoChunkIdentifierType;
import kd.ai.gai.core.enuz.repo.RepoChunkStrategy;

public class RepoChunkOperateConfig {
    private RepoChunkStrategy repoChunkStrategy;
    private LLM llm;
    private int chunkMaxLength;
    private String identifierType;
    private String identifierContent;
    private List<String> preDataRule;
    private static final int chunkLowerLimit = 1;

    public RepoChunkOperateConfig(RepoChunkEmbeddingRule embeddingRule, int maxlength, RepoChunkIdentifierType identifierType, String customContent, List<RepoChunkDataPreRule> preRules) {
        this.repoChunkStrategy = embeddingRule.getChunkStrategy();
        this.llm = embeddingRule.getLlm();
        this.chunkMaxLength = maxlength > embeddingRule.getMaxSize() ? embeddingRule.getMaxSize() : (maxlength < 1 ? 1 : maxlength);
        this.identifierType = identifierType.getType();
        this.identifierContent = this.identifierType.equals(RepoChunkIdentifierType.CUSTOM.getType()) ? customContent : identifierType.getIdentifier();
        this.preDataRule = this.genPreDataRuleList(preRules);
    }

    public RepoChunkOperateConfig(RepoChunkEmbeddingRule embeddingRule, int maxlength, RepoChunkIdentifierType identifierType, List<RepoChunkDataPreRule> preRules) {
        this(embeddingRule, maxlength, identifierType, null, preRules);
    }

    public RepoChunkOperateConfig(RepoChunkEmbeddingRule embeddingRule) {
        this.repoChunkStrategy = embeddingRule.getChunkStrategy();
        this.llm = embeddingRule.getLlm();
        this.chunkMaxLength = embeddingRule.getMaxSize();
    }

    public RepoChunkStrategy getRepoChunkStrategy() {
        return this.repoChunkStrategy;
    }

    public LLM getLlm() {
        return this.llm;
    }

    public int getChunkMaxLength() {
        return this.chunkMaxLength;
    }

    public String getIdentifierType() {
        return this.identifierType;
    }

    public String getIdentifierContent() {
        return this.identifierContent;
    }

    public List<String> getPreDataRule() {
        return this.preDataRule;
    }

    public void setLlm(LLM llm) {
        this.llm = llm;
    }

    public void setRepoChunkStrategy(RepoChunkStrategy repoChunkStrategy) {
        this.repoChunkStrategy = repoChunkStrategy;
    }

    public void setChunkMaxLength(int chunkMaxLength) {
        this.chunkMaxLength = chunkMaxLength;
    }

    public void setIdentifierType(String identifierType) {
        this.identifierType = identifierType;
    }

    public void setIdentifierContent(String identifierContent) {
        this.identifierContent = identifierContent;
    }

    public void setPreDataRule(List<RepoChunkDataPreRule> preRules) {
        this.preDataRule = this.genPreDataRuleList(preRules);
    }

    private List<String> genPreDataRuleList(List<RepoChunkDataPreRule> preRules) {
        ArrayList<String> preDataRule = new ArrayList<String>();
        if (preRules != null && !preRules.isEmpty()) {
            for (RepoChunkDataPreRule preRule : preRules) {
                preDataRule.add(preRule.getVal());
            }
        }
        return preDataRule;
    }
}

