/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.rag.embedding;

import java.sql.Timestamp;
import kd.ai.gai.core.code.GaiErrorCode;
import kd.ai.gai.core.code.GaiExceptionUtil;
import kd.ai.gai.core.domain.llm.EmbeddingParam;
import kd.ai.gai.core.enuz.EmbeddingModel;
import kd.ai.gai.core.rag.embedding.IEmbedding;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public abstract class AbstractEmbeddingService
implements IEmbedding {
    private static Log LOGGER = LogFactory.getLog(AbstractEmbeddingService.class);
    protected static final String selectFields = "id,repoid,status,fileid,pageid,taskid,order,content_tag";
    protected EmbeddingModel embedding;
    private static final long LOCK_WAIT_TIME = 3000L;
    private static final String LOCK_KEY_PER = "gai_embedding_";

    protected AbstractEmbeddingService(EmbeddingModel embedding) {
        this.embedding = embedding;
    }

    protected abstract String desc();

    @Override
    public boolean preExecute(EmbeddingParam param) {
        LOGGER.info(String.format("\u3010\u77e5\u8bc6\u5e93-Embedding\u3011\u6570\u636eembedding\u5f00\u59cb\uff0cparam:%s ,", SerializationUtils.toJsonString((Object)param)));
        if (param == null || this.embedding == null) {
            throw new KDBizException(GaiExceptionUtil.buildErr(GaiErrorCode.REPO_EMBEDDING_PARAM_ERR), new Object[0]);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(EmbeddingParam embeddingParam) {
        if (embeddingParam == null) {
            throw new KDBizException(GaiExceptionUtil.buildErr(GaiErrorCode.REPO_EMBEDDING_PARAM_ERR), new Object[0]);
        }
        long fileId = embeddingParam.getFileId();
        long repoId = embeddingParam.getRepoId();
        RequestContext rc = RequestContext.get();
        String lockKey = LOCK_KEY_PER.concat(rc.getTenantCode()).concat(rc.getAccountId()).concat("_").concat(String.valueOf(fileId));
        LOGGER.info(String.format("\u3010GPT-\u77e5\u8bc6\u5e93\u3011-\u6587\u4ef6Embedding\u4efb\u52a1, \u9501Key\uff1a%s", lockKey));
        DLock lock = AbstractEmbeddingService.getLock(lockKey);
        if (!lock.tryLock(3000L)) {
            LOGGER.info(String.format("\u3010\u77e5\u8bc6\u5e93-Embedding\u3011embedding\u4efb\u52a1,\u83b7\u4efb\u52a1\u6267\u884c\u6743\u5931\u8d25\uff0c\u4e2d\u65ad\u672c\u6b21\u4efb\u52a1\uff0c\u77e5\u8bc6\u5e93:%s, FileID: %s ", repoId, fileId));
            return;
        }
        try {
            this.preExecute(embeddingParam);
            this.run(embeddingParam);
            this.postExecute(embeddingParam);
        }
        catch (Exception e) {
            try {
                LOGGER.error(String.format("\u3010\u77e5\u8bc6\u5e93-Embedding\u3011\u8c03\u7528\u6a21\u578b,\u5f02\u5e38:repoId:%s,fileId:%s ,\u8bf7\u91cd\u8bd5", repoId, fileId), (Throwable)e);
                String logMsg = String.format("traceId: %s ,errorMsg:%s", RequestContext.get().getTraceId(), e.getMessage());
                logMsg = logMsg.length() > 2000 ? logMsg.substring(0, 2000) : logMsg;
                DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_info set fstatus=?,fmodifytime=? where fid = ?", (Object[])new Object[]{"D", new Timestamp(System.currentTimeMillis()), repoId});
                DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_doc_manage set ffilestatus=?,flog=?  where fentryid=?", (Object[])new Object[]{"G", logMsg, fileId});
                DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_text_chunk set fstatus=?  where ffileid =? and fstatus !=?", (Object[])new Object[]{"D", fileId, "C"});
            }
            catch (Throwable throwable) {
                LOGGER.info("\u3010\u77e5\u8bc6\u5e93-Embedding\u3011-\u6587\u4ef6\u3010{}\u3011{}\u5b8c\u6210, \u91ca\u653e\u9501\uff1a{}", new Object[]{fileId, this.desc(), lockKey});
                lock.unlock();
                throw throwable;
            }
            LOGGER.info("\u3010\u77e5\u8bc6\u5e93-Embedding\u3011-\u6587\u4ef6\u3010{}\u3011{}\u5b8c\u6210, \u91ca\u653e\u9501\uff1a{}", new Object[]{fileId, this.desc(), lockKey});
            lock.unlock();
        }
        LOGGER.info("\u3010\u77e5\u8bc6\u5e93-Embedding\u3011-\u6587\u4ef6\u3010{}\u3011{}\u5b8c\u6210, \u91ca\u653e\u9501\uff1a{}", new Object[]{fileId, this.desc(), lockKey});
        lock.unlock();
    }

    @Override
    public void postExecute(EmbeddingParam embeddingParam) {
        long repoId = embeddingParam.getRepoId();
        boolean noSuccess = QueryServiceHelper.exists((String)"gai_repo_info", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)repoId).and(String.format("%s.%s", "doc_manage", "file_status"), "!=", (Object)"C")});
        if (noSuccess) {
            LOGGER.info(String.format("\u3010\u77e5\u8bc6\u5e93-Embedding\u3011\u77e5\u8bc6\u5e93:%s,\u6587\u4ef6\u672a\u5168\u5b8c\u6210\uff0c\u5f85\u4e0b\u6b21\u66f4\u65b0\u77e5\u8bc6\u5e93\u72b6\u6001 ", repoId));
        } else {
            DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_info set fstatus=?,fmodifytime=? where fid = ?", (Object[])new Object[]{"C", new Timestamp(System.currentTimeMillis()), repoId});
            LOGGER.info(String.format("\u3010\u77e5\u8bc6\u5e93-Embedding\u3011\u77e5\u8bc6\u5e93:%s,\u5b8c\u6210 ", repoId));
        }
    }

    protected abstract void run(EmbeddingParam var1);

    private static DLock getLock(String lockKey) {
        LOGGER.info(String.format("\u3010GPT-\u77e5\u8bc6\u5e93\u3011-embadding\u4efb\u52a1, \u9501Key\uff1a%s", lockKey));
        DLock lock = DLock.create((String)lockKey, (String)String.format("\u9501:%s,\u3010GPT-\u77e5\u8bc6\u5e93\u3011\u5206\u5757\u4efb\u52a1\u9501", lockKey));
        lock.fastMode();
        return lock;
    }
}

