/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.rag.embedding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import kd.ai.gai.core.code.GaiErrorCode;
import kd.ai.gai.core.code.GaiExceptionUtil;
import kd.ai.gai.core.domain.llm.EmbeddingParam;
import kd.ai.gai.core.domain.llm.base.Result2User;
import kd.ai.gai.core.engine.handler.EmbeddingHandler;
import kd.ai.gai.core.engine.message.EmbeddingMessage;
import kd.ai.gai.core.enuz.EmbeddingModel;
import kd.ai.gai.core.rag.embedding.AbstractEmbeddingService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class EmbeddingAsyncFixedBatchService
extends AbstractEmbeddingService {
    private static Log LOGGER = LogFactory.getLog(EmbeddingAsyncFixedBatchService.class);

    public EmbeddingAsyncFixedBatchService(EmbeddingModel embedding) {
        super(embedding);
    }

    @Override
    protected String desc() {
        return "Embedding\u5f02\u6b65\u4efb\u52a1,\u6279\u91cf\u5206\u53d1\u670d\u52a1";
    }

    @Override
    protected void run(EmbeddingParam param) {
        long fileId = param.getFileId();
        long repoId = param.getRepoId();
        StringBuilder sql = new StringBuilder();
        sql.append("select count(1) from t_gai_text_chunk ");
        sql.append("where ffileid = ? ");
        String totalCountSql = sql.toString();
        int totalCount = (Integer)DB.query((DBRoute)DBRoute.of((String)"aidb"), (String)totalCountSql, (Object[])new Object[]{fileId}, resultSet -> {
            resultSet.next();
            return resultSet.getInt(1);
        });
        if (totalCount > 0) {
            DynamicObjectCollection chunks = QueryServiceHelper.query((String)"gai_text_chunk", (String)"id,repoid,status,fileid,pageid,taskid,order,content_tag", (QFilter[])new QFilter[]{new QFilter("fileid", "=", (Object)fileId).and("status", "in", (Object)new String[]{"A", "D"})});
            if (Objects.nonNull(chunks) && chunks.size() > 0) {
                int chunkSize = chunks.size();
                int batchSize = this.embedding.getBatchSize();
                int batchTotal = chunkSize / batchSize + (chunkSize % batchSize == 0 ? 0 : 1);
                ArrayList<Long> chunkIds = new ArrayList<Long>(batchSize);
                ArrayList<String> contents = new ArrayList<String>(batchSize);
                int count = 0;
                for (int i = 1; i <= chunkSize; ++i) {
                    DynamicObject chunkInfo = (DynamicObject)chunks.get(i - 1);
                    if (!Objects.nonNull(chunkInfo)) continue;
                    long chunkId = chunkInfo.getLong("id");
                    String content = chunkInfo.getString("content_tag").trim();
                    contents.add(content);
                    chunkIds.add(chunkId);
                    if (i % batchSize != 0 && i != chunkSize) continue;
                    String process = String.format("\u6279\u6b21\uff1a%s/%s", ++count, batchTotal);
                    LOGGER.info("\u3010\u77e5\u8bc6\u5e93-Embedding\u3011\u5f00\u59cb\u5f02\u6b65\u4efb\u52a1\uff0c{} ,repoId:{},fileId:{}", new Object[]{process, repoId, fileId});
                    EmbeddingMessage message = new EmbeddingMessage();
                    message.setRepoId(repoId);
                    message.setFileId(fileId);
                    message.setLlm(this.embedding.getLlm());
                    message.setChunkIds(chunkIds);
                    message.setChunks(contents);
                    Result2User result = EmbeddingHandler.process(message);
                    String code = result.getCode();
                    if (!GaiErrorCode.OK.getCode().equals(code)) {
                        throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.REPO_EMBEDDING_ASYN_ERR, result.getErrMsg()), new Object[0]);
                    }
                    String taskId = result.getTaskId();
                    this.chunkBindingAiccTask(chunkIds, taskId);
                    LOGGER.info("\u3010\u77e5\u8bc6\u5e93-Embedding\u3011\u5f02\u6b65\u8c03\u7528embedding\u6210\u529f repoId:{},taskId:{},chunkMilvesListSize:{}", new Object[]{repoId, taskId, chunkIds.size()});
                    chunkIds.clear();
                    contents.clear();
                }
            } else {
                LOGGER.info(String.format("\u3010\u77e5\u8bc6\u5e93-Embedding\u3011Embedding\uff0c\u6587\u4ef6ID\u4e3a:%s \u5757\u4efb\u52a1\u5df2\u5b8c\u6210\uff0c\u65e0\u9700\u5411\u91cf\u5f02\u6b65\u5904\u7406\uff0crepoId:%s", fileId, repoId));
                DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_doc_manage set ffilestatus=?,fprogress=?,flog=?  where fentryid=?", (Object[])new Object[]{"C", Float.valueOf(1.0f), "success", fileId});
            }
        } else {
            String errMsg = String.format("\u3010\u77e5\u8bc6\u5e93-Embedding\u3011chunk\u4fe1\u606f\u4e3a\u7a7a\uff0c\u4efb\u52a1\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u4e2d\u5185\u5bb9\u683c\u5f0f\u662f\u5426\u6b63\u786e\uff0crepoId:%s\uff0cfileId:%s ", repoId, fileId);
            LOGGER.error(errMsg);
            String logMsg = String.format("traceId: %s ,errorMsg:%s", RequestContext.get().getTraceId(), errMsg);
            logMsg = logMsg.length() > 2000 ? logMsg.substring(0, 2000) : logMsg;
            DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_info set fstatus=? where fid = ?", (Object[])new Object[]{"D", repoId});
            DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_doc_manage set ffilestatus=?  where fentryid=?", (Object[])new Object[]{"D", fileId});
            DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_doc_manage set ffilestatus=?,flog=?  where fentryid=?", (Object[])new Object[]{"G", logMsg, fileId});
        }
    }

    private void chunkBindingAiccTask(List<Long> chunkIds, String taskId) {
        StringBuilder sql = new StringBuilder();
        sql.append("update t_gai_text_chunk set ftaskid=? ");
        sql.append("where fid in (");
        sql.append(String.join((CharSequence)",", Collections.nCopies(chunkIds.size(), "?")));
        sql.append(')');
        Object[] params = new Object[chunkIds.size() + 1];
        params[0] = taskId;
        for (int j = 0; j < chunkIds.size(); ++j) {
            params[j + 1] = chunkIds.get(j);
        }
        DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)sql.toString(), (Object[])params);
    }
}

