/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.rag.milvus;

import kd.ai.gai.core.domain.dto.Chunk;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.VectorMetricType;
import kd.ai.gai.core.rag.milvus.MilvusBaseDao;
import kd.ai.gai.core.service.embedding.EmbeddingServiceFactory;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class BaiduTao8kMilvusDao
extends MilvusBaseDao<Chunk> {
    private static Log log = LogFactory.getLog(BaiduTao8kMilvusDao.class);

    @Override
    public int getDimension() {
        return EmbeddingServiceFactory.getExecutor(LLM.BAIDU_EMBEDDING_TAO_8K, VectorMetricType.COSINE).getDimension();
    }

    @Override
    public String getCollectionName() {
        RequestContext rc = RequestContext.get();
        String collection = String.format("M_%s_%s", rc.getAccountId(), LLM.BAIDU_EMBEDDING_TAO_8K.getNumber());
        log.info("milvus collectionName\uff1a{}", (Object)collection);
        return collection;
    }

    @Override
    public String getCollectionDescription() {
        return "repo file chunk baidu tao-8k 1024 dimension vector. ";
    }
}

