/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.rag.milvus;

import io.milvus.client.MilvusServiceClient;
import io.milvus.param.ConnectParam;
import io.milvus.param.R;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.session.SystemPropertyUtils;
import org.apache.commons.lang3.StringUtils;

public class MilvusClientFactory {
    private static Log LOGGER = LogFactory.getLog(MilvusClientFactory.class);
    private static ConcurrentHashMap<String, MilvusServiceClient> milvusClientMap = new ConcurrentHashMap();

    private MilvusClientFactory() {
    }

    public static synchronized MilvusServiceClient getClient() {
        String tenantId = RequestContext.get().getTenantId();
        MilvusServiceClient milvusServiceClient = milvusClientMap.get(tenantId);
        if (milvusServiceClient == null) {
            milvusServiceClient = milvusClientMap.computeIfAbsent(tenantId, k -> new Holder().buildClient());
        } else {
            R responseR = milvusServiceClient.checkHealth();
            if (responseR != null && responseR.getStatus().intValue() != R.Status.Success.getCode()) {
                LOGGER.error("milvus client status error :{}", (Object)responseR);
                if (responseR.getStatus().intValue() == R.Status.ClientNotConnected.getCode()) {
                    LOGGER.info("milvus client reconnect start");
                    milvusServiceClient.close();
                    milvusServiceClient = milvusClientMap.computeIfAbsent(tenantId, k -> new Holder().buildClient());
                    LOGGER.info("milvus client reconnect end");
                }
            }
        }
        return milvusServiceClient;
    }

    private static class Holder {
        private Holder() {
        }

        public MilvusServiceClient buildClient() {
            LOGGER.info("milvus create client start");
            String tenantId = RequestContext.get().getTenantId();
            String milvusHost = SystemPropertyUtils.getProptyByTenant((String)"milvus.host", (String)tenantId);
            String milvusUser = SystemPropertyUtils.getProptyByTenant((String)"milvus.user", (String)tenantId);
            String milvusPasswd = SystemPropertyUtils.getProptyByTenant((String)"milvus.passwd", (String)tenantId);
            boolean encrypted = Encrypters.isEncrypted((String)milvusPasswd);
            if (encrypted) {
                milvusPasswd = Encrypters.decode((String)milvusPasswd);
            }
            if (StringUtils.isEmpty((CharSequence)milvusHost) || StringUtils.isEmpty((CharSequence)milvusUser) || StringUtils.isEmpty((CharSequence)milvusPasswd)) {
                String msg = "\u9700\u8981\u5728mc\u4e2d\u914d\u7f6e\uff1amilvus.host\u3001milvus.user\u3001milvus.passwd\u3002";
                LOGGER.error(msg);
                throw new KDBizException(msg);
            }
            int milvusPort = SystemPropertyUtils.getInteger((String)tenantId, (String)"milvus.port", (Integer)19530);
            MilvusServiceClient milvusServiceClient = new MilvusServiceClient(ConnectParam.newBuilder().withHost(milvusHost).withPort(milvusPort).withAuthorization(milvusUser, milvusPasswd).withConnectTimeout(3L, TimeUnit.MINUTES).build());
            milvusServiceClient.withTimeout(2L, TimeUnit.MINUTES);
            return milvusServiceClient;
        }
    }
}

