/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.rag.milvus;

import java.util.EnumMap;
import java.util.Map;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.VectorMetricType;
import kd.ai.gai.core.rag.milvus.AzureMilvusDao;
import kd.ai.gai.core.rag.milvus.BaiduBgeLargeZhMilvusDao;
import kd.ai.gai.core.rag.milvus.BaiduTao8kMilvusDao;
import kd.ai.gai.core.rag.milvus.BaiduV1MilvusDao;
import kd.ai.gai.core.rag.milvus.DouBaoLargeMilvusDao;
import kd.ai.gai.core.rag.milvus.DouBaoMilvusDao;
import kd.ai.gai.core.rag.milvus.KingdeeMilvusDao;
import kd.ai.gai.core.rag.milvus.KingdeeNewMilvusDao;
import kd.ai.gai.core.rag.milvus.MilvusBaseDao;
import kd.ai.gai.core.rag.milvus.MilvusClientFactory;
import kd.ai.gai.core.rag.milvus.ShengTengMilvusDao;
import kd.ai.gai.core.service.milvus.MilvusStoreManager;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.session.SystemPropertyUtils;

public class MilvusService {
    private static Log logger = LogFactory.getLog(MilvusService.class);

    private MilvusService() {
    }

    public static MilvusBaseDao getExecutor(LLM embedding, VectorMetricType metricType) {
        logger.info("get milvus getExecutor");
        switch (metricType) {
            case L2: {
                return (MilvusBaseDao)Holder.MILVUS_DAO_MAP.get((Object)embedding);
            }
            case COSINE: {
                return MilvusStoreManager.getStore(embedding, metricType);
            }
        }
        throw new KDBizException("\u4e0d\u652f\u6301\u7684Embdedding\u6a21\u578b");
    }

    public static void destroy() {
        MilvusClientFactory.getClient().close();
    }

    public static boolean enableVDB() {
        String tenantId = RequestContext.get().getTenantId();
        String enableStr = SystemPropertyUtils.getProptyByTenant((String)"ai.vdb.enable", (String)tenantId);
        logger.debug("mc config ai.vdb.enable:{}", (Object)enableStr);
        boolean enable = false;
        if (StringUtils.isNotEmpty((CharSequence)enableStr)) {
            enable = Boolean.parseBoolean(enableStr);
        }
        logger.debug("vdb enable:{}", (Object)enable);
        return enable;
    }

    private static class Holder {
        private static final Map<LLM, MilvusBaseDao> MILVUS_DAO_MAP = new EnumMap<LLM, MilvusBaseDao>(LLM.class);

        private Holder() {
        }

        static {
            logger.info("milvus azureMilvusDao init start");
            AzureMilvusDao azureMilvusDao = new AzureMilvusDao();
            azureMilvusDao.init();
            MILVUS_DAO_MAP.put(LLM.AZURE_EMBEDDING_ADA_002, azureMilvusDao);
            logger.info("milvus azureMilvusDao init end");
            logger.info("milvus baiduMilvusDao init start");
            BaiduV1MilvusDao baiduV1MilvusDao = new BaiduV1MilvusDao();
            baiduV1MilvusDao.init();
            MILVUS_DAO_MAP.put(LLM.BAIDU_EMBEDDING_V1, baiduV1MilvusDao);
            logger.info("milvus baiduMilvusDao init end");
            logger.info("milvus kingdeeMilvusDao init start");
            KingdeeMilvusDao kingdeeMilvusDao = new KingdeeMilvusDao();
            kingdeeMilvusDao.init();
            MILVUS_DAO_MAP.put(LLM.KINGDEE_EMBEDDING, kingdeeMilvusDao);
            logger.info("milvus kingdeeMilvusDao init end");
            logger.info("milvus baiduTao8k init start");
            BaiduTao8kMilvusDao baiduTao8k = new BaiduTao8kMilvusDao();
            baiduTao8k.init();
            MILVUS_DAO_MAP.put(LLM.BAIDU_EMBEDDING_TAO_8K, baiduTao8k);
            logger.info("milvus baiduTao8k init end");
            logger.info("milvus baiduBeglargeZh init start");
            BaiduBgeLargeZhMilvusDao baiduBeglargeZh = new BaiduBgeLargeZhMilvusDao();
            baiduBeglargeZh.init();
            MILVUS_DAO_MAP.put(LLM.BAIDU_EMBEDDING_BGE_LARGE_ZH, baiduBeglargeZh);
            logger.info("milvus baiduBeglargeZh init end");
            logger.info("milvus kingdee_new init start");
            KingdeeNewMilvusDao kingdeeNewMilvusDao = new KingdeeNewMilvusDao();
            kingdeeNewMilvusDao.init();
            MILVUS_DAO_MAP.put(LLM.KINGDEE_EMBEDDING_NEW, kingdeeNewMilvusDao);
            logger.info("milvus kingdee_new init end");
            logger.info("milvus shengteng init start");
            ShengTengMilvusDao shengTengMilvusDao = new ShengTengMilvusDao();
            shengTengMilvusDao.init();
            MILVUS_DAO_MAP.put(LLM.SHENGTENG_EMBEDDING, shengTengMilvusDao);
            logger.info("milvus shengteng init end");
            logger.info("milvus doubao_embedding init start");
            DouBaoMilvusDao douBaoMilvusDao = new DouBaoMilvusDao();
            douBaoMilvusDao.init();
            MILVUS_DAO_MAP.put(LLM.DOUBAO_EMBEDDING, douBaoMilvusDao);
            logger.info("milvus doubao_embedding init end");
            logger.info("milvus doubao_embedding_large init start");
            DouBaoLargeMilvusDao douBaoLargeMilvusDao = new DouBaoLargeMilvusDao();
            douBaoLargeMilvusDao.init();
            MILVUS_DAO_MAP.put(LLM.DOUBAO_EMBEDDING, douBaoLargeMilvusDao);
            logger.info("milvus doubao_embedding_large init end");
        }
    }
}

