/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.rag.parser;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class AsposeLicense {
    private static Log logger = LogFactory.getLog(AsposeLicense.class);
    public static final String KEY_ASPOSE_WORDS_LIC_PATH = "/dict/Aspose.Words.Product.Family.lic";
    public static final String KEY_ASPOSE_ENCRYPT = "d@f*g:SGVsbG8===AOR3umRGun+8y3j2mPZejSvj4HD9Dv3J3zlBr5de/DdwbZty1qEqESRa2RwYXNzd29yZA==";
    private static final String KEY_ALGORITHM = "AES";
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES/GCM/NoPadding";

    private AsposeLicense() {
    }

    public static String encrypt(String content, String encryptPass) {
        try {
            byte[] iv = new byte[12];
            SecureRandom secureRandom = new SecureRandom();
            secureRandom.nextBytes(iv);
            byte[] contentBytes = content.getBytes(StandardCharsets.UTF_8);
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            GCMParameterSpec params = new GCMParameterSpec(128, iv);
            cipher.init(1, (Key)AsposeLicense.getSecretKey(encryptPass), params);
            byte[] encryptData = cipher.doFinal(contentBytes);
            assert (encryptData.length == contentBytes.length + 16);
            byte[] message = new byte[12 + contentBytes.length + 16];
            System.arraycopy(iv, 0, message, 0, 12);
            System.arraycopy(encryptData, 0, message, 12, encryptData.length);
            return Base64.getEncoder().encodeToString(message);
        }
        catch (Exception e) {
            logger.error("\u52a0\u5bc6\u5f02\u5e38", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u52a0\u5bc6\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"CvpEncryptUtils_001", (String)"ai-cvp-common", (Object[])new Object[0]));
        }
    }

    public static String decrypt(String base64Content, String encryptPass) {
        try {
            byte[] content = Base64.getDecoder().decode(base64Content);
            if (content.length < 28) {
                throw new IllegalArgumentException();
            }
            GCMParameterSpec params = new GCMParameterSpec(128, content, 0, 12);
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            cipher.init(2, (Key)AsposeLicense.getSecretKey(encryptPass), params);
            byte[] decryptData = cipher.doFinal(content, 12, content.length - 12);
            return new String(decryptData, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            logger.error("\u89e3\u5bc6\u5f02\u5e38", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u52a0\u5bc6\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"CvpEncryptUtils_002", (String)"ai-cvp-common", (Object[])new Object[0]));
        }
    }

    private static SecretKeySpec getSecretKey(String encryptPass) throws NoSuchAlgorithmException {
        KeyGenerator kg = KeyGenerator.getInstance(KEY_ALGORITHM);
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        secureRandom.setSeed(encryptPass.getBytes());
        kg.init(128, secureRandom);
        SecretKey secretKey = kg.generateKey();
        return new SecretKeySpec(secretKey.getEncoded(), KEY_ALGORITHM);
    }

    static String decodeDefault(String text) {
        return AsposeLicense.decrypt(Encrypters.decode((String)text), Encrypters.decode((String)KEY_ASPOSE_ENCRYPT));
    }
}

