/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.rag.parser;

import com.alibaba.fastjson.JSON;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import kd.ai.gai.core.code.GaiErrorCode;
import kd.ai.gai.core.code.GaiExceptionUtil;
import kd.ai.gai.core.domain.dto.Chunk;
import kd.ai.gai.core.rag.CustomChunk;
import kd.ai.gai.core.rag.chunk.ChunkInput;
import kd.ai.gai.core.rag.parser.AbstractParser;
import kd.ai.gai.core.service.AIFileService;
import kd.ai.gai.core.service.ChunkService;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class DatabaseCustomizeChunkParser
extends AbstractParser {
    private static Log LOGGER = LogFactory.getLog(DatabaseCustomizeChunkParser.class);

    @Override
    public boolean opreate(ChunkInput file) throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(AIFileService.getAttachmentFileInputStream(file.getFilePath()), StandardCharsets.UTF_8));){
            String linJson;
            long repositoryId = file.getRepositoryId();
            long fileId = file.getFileId();
            int maxLength = file.getRepoConfig().getRepoChunkOperateConfig().getChunkMaxLength();
            ArrayList<Chunk> chunks = new ArrayList<Chunk>(10);
            int linIndex = 0;
            while ((linJson = br.readLine()) != null) {
                CustomChunk customChunk = (CustomChunk)JSON.parseObject((String)linJson, CustomChunk.class);
                ++linIndex;
                if (customChunk == null) {
                    LOGGER.warn("\u81ea\u5b9a\u4e49\u5206\u5757\u3010{}\u3011\u884c\u5185\u5bb9\u5b58\u5728\u4e3a\u7a7a,\u5ffd\u7565\u8be5\u884c\u6570\u636e", (Object)linIndex);
                    continue;
                }
                Long businessId = customChunk.getBusinessId();
                String title = customChunk.getTitle();
                String url = customChunk.getUrl();
                String source = customChunk.getSource();
                String chunkContent = customChunk.getChunk();
                if (businessId == null || StringUtils.isEmpty((String)title) || StringUtils.isEmpty((String)url) || StringUtils.isEmpty((String)source) || StringUtils.isEmpty((String)linJson)) {
                    throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.REPO_FILE_CUSTOM_ERR, String.format("JSON \u5c5e\u6027\u5185\u5bb9\u5b58\u5728\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3010%s\u3011\u884c", linIndex)), new Object[0]);
                }
                int length = chunkContent.length();
                if (length > maxLength) {
                    ErrorCode errorCode = GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.REPO_FILE_CUSTOM_ERR, String.format("\u5757\u5185\u5bb9\u5b57\u7b26\u957f\u5ea6\u3010%s\u3011\u8d85\u51fa\u3010%s\u3011\u5b57\u7b26\u957f\u5ea6\u9650\u5236", length, maxLength));
                    throw new KDBizException(errorCode, new Object[0]);
                }
                chunks.add(new Chunk(repositoryId, fileId, 1, linIndex, source, businessId, title, url, chunkContent));
                ChunkService.batchConditionInsert(chunks);
            }
            ChunkService.batchInsert(chunks);
            DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_doc_manage set ffilesource=? where fentryid=?", (Object[])new Object[]{"doc", file.getFileId()});
            boolean bl = true;
            return bl;
        }
    }
}

