/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.rag.parser;

import com.aspose.words.Document;
import com.aspose.words.FontSettings;
import com.aspose.words.IWarningCallback;
import com.aspose.words.License;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import kd.ai.gai.core.enuz.repo.RepoChunkStrategy;
import kd.ai.gai.core.rag.MergeConfig;
import kd.ai.gai.core.rag.RepoChunkOperateConfig;
import kd.ai.gai.core.rag.Sentence;
import kd.ai.gai.core.rag.chunk.ChunkInput;
import kd.ai.gai.core.rag.parser.AbstractParser;
import kd.ai.gai.core.rag.parser.AsposeFontWarningCallback;
import kd.ai.gai.core.rag.parser.AsposeLicense;
import kd.ai.gai.core.rag.split.AbstractSplitter;
import kd.ai.gai.core.service.AIFileService;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class DocParser
extends AbstractParser {
    private static Log LOGGER = LogFactory.getLog(DocParser.class);

    @Override
    public boolean opreate(ChunkInput file) throws IOException {
        this.initLicense();
        RepoChunkOperateConfig repoChunkOperateConfig = file.getRepoConfig().getRepoChunkOperateConfig();
        RepoChunkStrategy repoChunkStrategy = repoChunkOperateConfig.getRepoChunkStrategy();
        AbstractSplitter splitter = DocParser.chooseSplitter(repoChunkStrategy);
        String content = "";
        try (InputStream inputStream = AIFileService.getAttachmentFileInputStream(file.getFilePath());){
            Document wordDoc = new Document(inputStream);
            AsposeFontWarningCallback callback = new AsposeFontWarningCallback();
            wordDoc.setWarningCallback((IWarningCallback)callback);
            FontSettings fontSettings = new FontSettings();
            fontSettings.setFontsFolder("/usr/share/fonts/", true);
            fontSettings.getSubstitutionSettings().getDefaultFontSubstitution().setDefaultFontName("Arial");
            fontSettings.getSubstitutionSettings().getFontConfigSubstitution().setEnabled(true);
            wordDoc.setFontSettings(fontSettings);
            content = wordDoc.getText();
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6word\u6587\u672c\u5f02\u5e38", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6word\u6587\u672c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"DocParser_001", (String)"ai-gai-core", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)content)) {
            long fileId = file.getFileId();
            String logMsg = "word\u6587\u6863text\u6587\u672c\u533a\u57df\u5185\u5bb9\u4e3a\u7a7a";
            LOGGER.error(logMsg + ", fileId: " + fileId);
            DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_doc_manage set ffilestatus=? ,flog=? where fentryid=?", (Object[])new Object[]{"D", logMsg, fileId});
            throw new KDBizException(ResManager.loadKDString((String)"word\u6587\u6863text\u6587\u672c\u533a\u57df\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"DocParser_001", (String)"ai-gai-core", (Object[])new Object[0]));
        }
        int page = 1;
        ArrayList<Sentence> chunks = splitter.split(page, content, repoChunkOperateConfig);
        int startChunkCount = 1;
        int maxChunkLen = repoChunkOperateConfig.getChunkMaxLength();
        MergeConfig splitConfig = new MergeConfig(file.getRepositoryId(), file.getFileId(), startChunkCount, maxChunkLen);
        return splitter.mergeToDB(splitConfig, chunks);
    }

    private void initLicense() {
        ByteArrayInputStream inputStream = null;
        try {
            block42: {
                try (InputStream resourceAsStream = DocParser.class.getResourceAsStream("/dict/Aspose.Words.Product.Family.lic");
                     InputStreamReader inputStreamReader = new InputStreamReader(resourceAsStream);
                     BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                    String line;
                    StringBuilder stringBuilder = new StringBuilder();
                    while ((line = bufferedReader.readLine()) != null) {
                        stringBuilder.append(line);
                    }
                    String licStr = AsposeLicense.decodeDefault(stringBuilder.toString());
                    if (StringUtils.isNotEmpty((String)licStr)) {
                        inputStream = new ByteArrayInputStream(licStr.getBytes(StandardCharsets.UTF_8));
                        License license = new License();
                        license.setLicense((InputStream)inputStream);
                        break block42;
                    }
                    throw new KDBizException(ResManager.loadKDString((String)"doc\u3001docx\u6587\u6863\u5904\u7406\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"DocParser", (String)"ai-gai-core", (Object[])new Object[0]));
                }
            }
            this.closeResource(inputStream);
        }
        catch (Exception e) {
            try {
                LOGGER.error("aspose \u8bb8\u53ef\u52a0\u8f7d\u5f02\u5e38", (Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"doc\u3001docx\u6587\u6863\u5904\u7406\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"DocParser", (String)"ai-gai-core", (Object[])new Object[0]));
            }
            catch (Throwable throwable) {
                this.closeResource(inputStream);
                throw throwable;
            }
        }
    }

    private void closeResource(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                closeable = null;
            }
        }
    }
}

