/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.rag.parser;

import java.util.EnumMap;
import java.util.Map;
import kd.ai.gai.core.enuz.repo.RepoChunkStrategy;
import kd.ai.gai.core.enuz.repo.RepoSourceType;
import kd.ai.gai.core.rag.RepoConfig;
import kd.ai.gai.core.rag.parser.AbstractParser;
import kd.ai.gai.core.rag.parser.DocParser;
import kd.ai.gai.core.rag.parser.JsonCommunityBaseParser;
import kd.ai.gai.core.rag.parser.JsonKdCodeBaseParser;
import kd.ai.gai.core.rag.parser.PdfBaseParser;
import kd.ai.gai.core.rag.parser.PdfNonAnalysisParser;
import kd.ai.gai.core.rag.parser.TextCustomizeChunkParser;
import kd.ai.gai.core.rag.parser.TextSimpleBaseParser;
import kd.bos.exception.KDBizException;

public class FileParserFactory {
    private FileParserFactory() {
    }

    public static AbstractParser getService(RepoConfig config) {
        RepoChunkStrategy splitType = config.getRepoChunkOperateConfig().getRepoChunkStrategy();
        RepoSourceType repoSourceType = config.getRepoSourceType();
        if (RepoChunkStrategy.BASE_FIXED_LENGTH == splitType || RepoChunkStrategy.IDENTIFIER == splitType) {
            return (AbstractParser)Holder.SPLIT_SERVICE_lENGTH_MAP.get((Object)repoSourceType);
        }
        if (RepoChunkStrategy.CUSTOMIZE == splitType) {
            return (AbstractParser)Holder.SPLIT_SERVICE_CUSTOMIZE_MAP.get((Object)splitType);
        }
        throw new KDBizException("\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u89e3\u6790\u7c7b\u578b");
    }

    private static class Holder {
        private static final Map<RepoSourceType, AbstractParser> SPLIT_SERVICE_lENGTH_MAP = new EnumMap<RepoSourceType, AbstractParser>(RepoSourceType.class);
        private static final Map<RepoChunkStrategy, AbstractParser> SPLIT_SERVICE_CUSTOMIZE_MAP;

        private Holder() {
        }

        static {
            SPLIT_SERVICE_lENGTH_MAP.put(RepoSourceType.QA_TEXT, new TextSimpleBaseParser());
            SPLIT_SERVICE_lENGTH_MAP.put(RepoSourceType.QA_PDF, new PdfBaseParser());
            SPLIT_SERVICE_lENGTH_MAP.put(RepoSourceType.QA_PDF_NON_ANALYSIS, new PdfNonAnalysisParser());
            SPLIT_SERVICE_lENGTH_MAP.put(RepoSourceType.QA_COMMUNITY, new JsonCommunityBaseParser());
            SPLIT_SERVICE_lENGTH_MAP.put(RepoSourceType.GEN_CODE, new JsonKdCodeBaseParser());
            SPLIT_SERVICE_lENGTH_MAP.put(RepoSourceType.QA_DOC, new DocParser());
            SPLIT_SERVICE_lENGTH_MAP.put(RepoSourceType.QA_DOCX, new DocParser());
            SPLIT_SERVICE_CUSTOMIZE_MAP = new EnumMap<RepoChunkStrategy, AbstractParser>(RepoChunkStrategy.class);
            SPLIT_SERVICE_CUSTOMIZE_MAP.put(RepoChunkStrategy.CUSTOMIZE, new TextCustomizeChunkParser());
        }
    }
}

