/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.rag.service;

import com.alibaba.fastjson.JSON;
import io.milvus.grpc.SearchResults;
import io.milvus.response.SearchResultsWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.ai.gai.core.aop.GaiMService;
import kd.ai.gai.core.code.GaiErrorCode;
import kd.ai.gai.core.code.GaiExceptionUtil;
import kd.ai.gai.core.domain.dto.Chunk;
import kd.ai.gai.core.domain.dto.RerankChunk;
import kd.ai.gai.core.domain.dto.repo.GaiRepoSearchData;
import kd.ai.gai.core.domain.dto.repo.RepoFulltextData;
import kd.ai.gai.core.domain.dto.repo.RepoQueryParam;
import kd.ai.gai.core.domain.dto.repo.RerankerConfig;
import kd.ai.gai.core.domain.llm.base.Result4Embedding;
import kd.ai.gai.core.domain.llm.base.ResultRerank;
import kd.ai.gai.core.domain.mservice.GaiRagSearchParams;
import kd.ai.gai.core.domain.vo.RepoFileVO;
import kd.ai.gai.core.domain.vo.RepoVO;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.engine.message.RerankMessage;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.VectorMetricType;
import kd.ai.gai.core.enuz.repo.RepoServiceCallType;
import kd.ai.gai.core.enuz.repo.SearchType;
import kd.ai.gai.core.helper.GPTLicenseHelper;
import kd.ai.gai.core.rag.milvus.MilvusService;
import kd.ai.gai.core.rag.service.RepoFulltextService;
import kd.ai.gai.core.rag.service.RerankerConfigService;
import kd.ai.gai.core.service.ChunkService;
import kd.ai.gai.core.service.FilePreviewService;
import kd.ai.gai.core.service.RepoService;
import kd.ai.gai.core.service.embedding.EmbeddingServiceFactory;
import kd.ai.gai.core.service.llm.LlmService;
import kd.ai.gai.core.service.rerank.RerankService;
import kd.ai.gai.core.service.vdb.VDBResult;
import kd.ai.gai.core.service.vdb.VDBServiceManager;
import kd.ai.gai.core.service.vdb.service.VDBServiceConverter;
import kd.ai.vdb.objects.CollectionData;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;
import org.jetbrains.annotations.NotNull;

public class RagService {
    private static final Log logger = LogFactory.getLog(LlmService.class);

    public static List<GaiRepoSearchData> retrievalComponent(Context context, GaiRagSearchParams searchParams) {
        logger.info("\u3010GPT-\u63a5\u53e3\u670d\u52a1\u3011\u77e5\u8bc6\u5e93\u68c0\u7d22-\u7ec4\u4ef6\uff0c\u53c2\u6570\uff1a{}", (Object)JsonUtil.toJson(searchParams));
        if (Context.needCheckLicense(context)) {
            GPTLicenseHelper.checkLic("ai_gai_reporag", 0L);
        }
        return RagService.innerSearch(searchParams);
    }

    public static List<GaiRepoSearchData> search(RepoServiceCallType callType, GaiRagSearchParams searchParams) {
        return GaiMService.execute(String.format("%s-\u77e5\u8bc6\u5e93\u68c0\u7d22", new Object[]{callType}), searchParams, p -> RagService.innerSearch(p));
    }

    private static List<GaiRepoSearchData> innerSearch(GaiRagSearchParams params) {
        List<GaiRepoSearchData> searchData;
        String searchType;
        List<Long> repoIds = params.getRepoIds();
        if (repoIds == null || repoIds.size() <= 0) {
            throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.RAG_REPO_MS_PARAMS_ERR, "\u77e5\u8bc6\u5e93\u4e0d\u4e3a\u7a7a"), new Object[0]);
        }
        String input = params.getInput();
        int topK = params.getTopK();
        float similarity = params.getSimilarity();
        boolean enableReranker = params.isEnableReranker();
        String rerankerLLmNumber = "";
        if (kd.bos.util.StringUtils.isEmpty((String)input)) {
            throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.RAG_REPO_MS_PARAMS_ERR, "\u5f85\u68c0\u7d22\u6587\u672c\u5185\u5bb9\u4e0d\u4e3a\u7a7a"), new Object[0]);
        }
        if (input.length() > 1000) {
            throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.RAG_REPO_MS_PARAMS_ERR, "\u5f85\u68c0\u7d22\u6587\u672c\u5185\u5bb9\u9700\u8981\u57281000\u5b57\u7b26\u4ee5\u5185"), new Object[0]);
        }
        if (topK < 1 || topK > 100) {
            throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.RAG_REPO_MS_PARAMS_ERR, "TopK\u503c\u4e3a[1,100]"), new Object[0]);
        }
        if (enableReranker) {
            RerankerConfig rerankerConfig = RerankerConfigService.loadCurrentReranker();
            logger.info("\u3010GPT-\u63a5\u53e3\u670d\u52a1\u3011\u77e5\u8bc6\u5e93\u68c0\u7d22-\u542f\u7528\u91cd\u6392\u5e8f\uff0c\u68c0\u67e5\u77e5\u8bc6\u5e93\u914d\u7f6e\uff0c\u91cd\u6392\u6a21\u578b\u8bbe\u7f6e\u4fe1\u606f\uff1a{}", (Object)JsonUtil.toJson(rerankerConfig));
            boolean used = rerankerConfig.getUsed();
            if (used) {
                rerankerLLmNumber = rerankerConfig.getServiceNumber();
            } else {
                String errMsg = "\u91cd\u6392\u5e8f\u6a21\u578b\u5728\u77e5\u8bc6\u5e93\u914d\u7f6e\u4e2d\u672a\u5f00\u542f";
                logger.error("\u3010GPT-\u63a5\u53e3\u670d\u52a1\u3011\u77e5\u8bc6\u5e93\u68c0\u7d22-\u91cd\u6392\u5e8f\u5f02\u5e38,{}", (Object)errMsg);
                throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.REPO_SEARCH_ERR, errMsg), new Object[0]);
            }
        }
        if (kd.bos.util.StringUtils.isEmpty((String)(searchType = params.getSearchType()))) {
            searchType = SearchType.VECTOR.toString();
        }
        if (SearchType.HYBRID.toString().equalsIgnoreCase(searchType)) {
            if (similarity < 0.0f || similarity > 1.0f) {
                throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.RAG_REPO_MS_PARAMS_ERR, "similarity\u503c\u4e3a[0,1]"), new Object[0]);
            }
            if (!enableReranker) {
                throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.RAG_REPO_MS_PARAMS_ERR, "\u6df7\u5408\u68c0\u7d22\u5fc5\u987b\u5f00\u542fReranker\u91cd\u6392\u5e8f\u3010enableReranker:true\u3011"), new Object[0]);
            }
            boolean enableFT = RepoService.noEnableFT(repoIds);
            if (enableFT) {
                throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.RAG_REPO_MS_PARAMS_ERR, "\u6df7\u5408\u68c0\u7d22\u5fc5\u987b\u540c\u65f6\u5177\u5907\u5411\u91cf\u3001\u5168\u6587\u7d22\u5f15"), new Object[0]);
            }
            searchData = RagService.hybridSearch(repoIds, input, topK, similarity);
        } else {
            if (SearchType.VECTOR.toString().equalsIgnoreCase(searchType)) {
                if (similarity < 0.0f || similarity > 1.0f) {
                    throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.RAG_REPO_MS_PARAMS_ERR, "similarity\u503c\u4e3a[0,1]"), new Object[0]);
                }
                searchData = enableReranker ? RagService.vectorSearch(repoIds, input, topK, 0.0f) : RagService.vectorSearch(repoIds, input, topK, similarity);
            } else if (SearchType.KEYWORD.toString().equalsIgnoreCase(searchType)) {
                if (similarity < 0.0f || similarity > Float.MAX_VALUE) {
                    throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.RAG_REPO_MS_PARAMS_ERR, "similarity\u503c\u4e3a[0,1]"), new Object[0]);
                }
                boolean enableFT = RepoService.noEnableFT(repoIds);
                if (enableFT) {
                    throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.RAG_REPO_MS_PARAMS_ERR, "\u5168\u6587\u68c0\u7d22\u5fc5\u987b\u5177\u5907\u5168\u6587\u7d22\u5f15"), new Object[0]);
                }
                searchData = RagService.keywordSearch(repoIds, input, topK, similarity);
            } else {
                String errMsg = String.format("\u4e0d\u652f\u6301\u7684\u68c0\u7d22\u6a21\u5f0f\uff1a%s", searchType);
                logger.error("\u3010GPT-\u63a5\u53e3\u670d\u52a1\u3011\u77e5\u8bc6\u5e93\u68c0\u7d22-\u68c0\u7d22\u6a21\u5f0f\u53c2\u6570\u5f02\u5e38,{}", (Object)errMsg);
                throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.REPO_SEARCH_ERR, errMsg), new Object[0]);
            }
            if (enableReranker) {
                logger.info("\u3010GPT-\u63a5\u53e3\u670d\u52a1\u3011\u77e5\u8bc6\u5e93\u68c0\u7d22-\u6267\u884c\u91cd\u6392\u5e8f\u5f00\u59cb");
                return RagService.rerankerSearchDatas(rerankerLLmNumber, input, searchData, topK, similarity);
            }
            logger.warn("\u3010GPT-\u63a5\u53e3\u670d\u52a1\u3011\u77e5\u8bc6\u5e93\u68c0\u7d22-\u91cd\u6392\u5e8f\u6a21\u578b\u5728\u77e5\u8bc6\u5e93\u914d\u7f6e\u4e2d\u672a\u5f00\u542f,\u4e0d\u542f\u7528\u91cd\u6392\u6a21\u578b\u589e\u5f3a\u5904\u7406");
        }
        return searchData;
    }

    public static List<GaiRepoSearchData> hybridSearch(List<Long> repoIds, String input, int topK, float similarity) {
        RerankerConfig rerankerConfig = RerankerConfigService.loadCurrentReranker();
        logger.info("\u3010RAG-\u6df7\u5408\u68c0\u7d22\u3011Reranker-\u77e5\u8bc6\u5e93\u914d\u7f6e\uff0c\u91cd\u6392\u6a21\u578b\u8bbe\u7f6e\u4fe1\u606f\uff1a{}", (Object)JsonUtil.toJson(rerankerConfig));
        boolean used = rerankerConfig.getUsed();
        if (used) {
            ArrayList<GaiRepoSearchData> useRerankerDatas = new ArrayList<GaiRepoSearchData>();
            logger.info("\u3010RAG-\u6df7\u5408\u68c0\u7d22\u3011\u5168\u6587\u68c0\u7d22-\u5f00\u59cb.\u77e5\u8bc6\u5e93ID:{},\u8f93\u5165:{},topK:{},similarity:{}", new Object[]{JsonUtil.toJson(repoIds), input, topK, Float.valueOf(similarity)});
            List<GaiRepoSearchData> keywordSearchDatas = RagService.keywordSearch(repoIds, input, topK, 0.0f);
            logger.info("\u3010RAG-\u6df7\u5408\u68c0\u7d22\u3011\u5168\u6587\u68c0\u7d22-\u7ed3\u675f,\u77e5\u8bc6\u5e93ID:{},\u8f93\u5165:{}", (Object)JsonUtil.toJson(repoIds), (Object)input);
            logger.info("\u3010RAG-\u6df7\u5408\u68c0\u7d22\u3011\u5411\u91cf\u68c0\u7d22-\u5f00\u59cb.\u77e5\u8bc6\u5e93ID:{},\u8f93\u5165:{},topK:{},similarity:{}", new Object[]{JsonUtil.toJson(repoIds), input, topK, Float.valueOf(similarity)});
            List<GaiRepoSearchData> vectorSearchDatas = RagService.vectorSearch(repoIds, input, topK, 0.0f);
            logger.info("\u3010RAG-\u6df7\u5408\u68c0\u7d22\u3011\u5411\u91cf\u68c0\u7d22-\u7ed3\u675f,\u77e5\u8bc6\u5e93ID:{},\u8f93\u5165:{}", (Object)JsonUtil.toJson(repoIds), (Object)input);
            useRerankerDatas.addAll(keywordSearchDatas);
            useRerankerDatas.addAll(vectorSearchDatas);
            logger.info("\u3010RAG-\u6df7\u5408\u68c0\u7d22\u3011Reranker-\u5f00\u59cb.\u77e5\u8bc6\u5e93ID:{},\u8f93\u5165:{},topK:{},similarity:{}", new Object[]{JsonUtil.toJson(repoIds), input, topK, Float.valueOf(similarity)});
            String serviceNumber = rerankerConfig.getServiceNumber();
            List<GaiRepoSearchData> rerankerSearchDatas = RagService.rerankerSearchDatas(serviceNumber, input, useRerankerDatas, topK, similarity);
            logger.info("\u3010RAG-\u6df7\u5408\u68c0\u7d22\u3011Reranker-\u7ed3\u675f,\u77e5\u8bc6\u5e93ID:{},\u8f93\u5165:{}", (Object)JsonUtil.toJson(repoIds), (Object)input);
            return rerankerSearchDatas;
        }
        String errMsg = "\u91cd\u6392\u5e8f\u6a21\u578b\u5728\u3010\u77e5\u8bc6\u5e93\u914d\u7f6e\u3011\u4e2d\u672a\u5f00\u542f";
        logger.error("\u3010RAG-\u6df7\u5408\u68c0\u7d22\u3011\u6df7\u5408\u68c0\u7d22\u5f02\u5e38,{}", (Object)errMsg);
        throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.REPO_HYBRID_ERR, errMsg), new Object[0]);
    }

    public static List<GaiRepoSearchData> vectorSearch(List<Long> repoIds, String input, int topK, float similarity) {
        long repoId = repoIds.get(0);
        RepoVO repoInfo = RepoService.getRepoInfo(repoId);
        LLM embeddingModel = repoInfo.getLlm();
        VectorMetricType vectorMetricType = repoInfo.getVectorMetricType();
        logger.info("\u3010RAG-\u5411\u91cf\u68c0\u7d22\u3011\u77e5\u8bc6\u5e93ID:{},\u5411\u91cf\u6a21\u578b:{},\u8f93\u5165:{},topK:{},similarity:{}", new Object[]{JsonUtil.toJson(repoIds), embeddingModel.getNumber(), input, topK, Float.valueOf(similarity)});
        LinkedHashMap<Long, Float> useChunkInfos = RagService.vectorAlgoSimilarity(vectorMetricType, embeddingModel, repoIds, input, topK, similarity);
        ArrayList<Long> useChunkIds = new ArrayList<Long>(useChunkInfos.keySet());
        List<Chunk> chunkList = ChunkService.getByList(useChunkIds);
        ArrayList<GaiRepoSearchData> searchDatas = new ArrayList<GaiRepoSearchData>();
        if (chunkList != null && chunkList.size() > 0) {
            for (Chunk chunk : chunkList) {
                long chunkId = chunk.getId();
                Float chunkSimilarity = useChunkInfos.get(chunkId);
                searchDatas.add(RagService.buildRepoSearchData(chunk, chunkSimilarity));
            }
            logger.info("\u3010RAG-\u5411\u91cf\u68c0\u7d22\u3011\u77e5\u8bc6\u5e93ID:{}\uff0c\u8f93\u5165:{},\u68c0\u7d22\u7ed3\u679c:{}", new Object[]{JsonUtil.toJson(repoIds), input, JsonUtil.toJson(searchDatas)});
        } else {
            logger.warn("\u3010RAG-\u5411\u91cf\u68c0\u7d22\u3011\u672c\u6b21\u672a\u68c0\u7d22\u5230\u5757\u8be6\u60c5\u4fe1\u606f\u6570\u636e");
        }
        return searchDatas;
    }

    public static List<GaiRepoSearchData> keywordSearch(List<Long> repoIds, String input, int topK, float score) {
        List<RepoFulltextData> ftdatas;
        RepoQueryParam repoQueryParam = new RepoQueryParam(repoIds, input, topK);
        logger.info("\u3010RAG-\u5168\u6587\u68c0\u7d22\u3011\u68c0\u7d22\u53c2\u6570:{}", (Object)JsonUtil.toJson(repoQueryParam));
        try {
            ftdatas = RepoFulltextService.getInstance().qurey(repoQueryParam);
        }
        catch (IOException e) {
            logger.error("\u3010RAG-\u5168\u6587\u68c0\u7d22\u3011ES \u8fde\u63a5\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.REPO_FT_ERR, e.getMessage()), new Object[0]);
        }
        List<Long> useChunkIds = ftdatas.stream().map(RepoFulltextData::getChunkId).collect(Collectors.toList());
        logger.info("\u3010RAG-\u5168\u6587\u68c0\u7d22\u3011ES\u68c0\u7d22\u7ed3\u679c chunkIds:{}", (Object)JsonUtil.toJson(useChunkIds));
        List<Chunk> chunkList = ChunkService.getByList(useChunkIds);
        ArrayList<GaiRepoSearchData> searchDatas = new ArrayList<GaiRepoSearchData>();
        if (chunkList != null && chunkList.size() > 0) {
            for (RepoFulltextData ftdata : ftdatas) {
                long chunkId = ftdata.getChunkId();
                Optional<Chunk> result = chunkList.stream().filter(c -> chunkId == c.getId()).findFirst();
                if (result.isPresent()) {
                    Chunk chunk = result.get();
                    float chunkScore = ftdata.getScore();
                    if (!(chunkScore >= score)) continue;
                    searchDatas.add(RagService.buildRepoSearchData(chunk, Float.valueOf(chunkScore)));
                    continue;
                }
                logger.warn("\u3010RAG-\u5168\u6587\u68c0\u7d22\u3011\u5168\u6587\u68c0\u7d22\u672a\u627e\u5230\u5f97\u5206\u503c,\u9ed8\u8ba4\u503c:0,chunkid:{}", (Object)chunkId);
            }
            logger.info("\u3010RAG-\u5168\u6587\u68c0\u7d22\u3011\u77e5\u8bc6\u5e93ID:{}\uff0c\u8f93\u5165:{},\u68c0\u7d22\u7ed3\u679c:{}", new Object[]{JsonUtil.toJson(repoIds), input, JsonUtil.toJson(searchDatas)});
        } else {
            logger.warn("\u3010RAG-\u5168\u6587\u68c0\u7d22\u3011\u672c\u6b21\u672a\u68c0\u7d22\u5230\u5757\u8be6\u60c5\u4fe1\u606f\u6570\u636e");
        }
        return searchDatas;
    }

    @NotNull
    public static List<GaiRepoSearchData> rerankerSearchDatas(String serviceNumber, String input, List<GaiRepoSearchData> useRerankerDatas, int topK, float similarity) {
        logger.info("\u3010RAG-Reranker\u3011\u91cd\u6392\u6a21\u578b\u5904\u7406\u5f85\u8bf7\u6c42\u6570\u636e\uff1a{}", (Object)JsonUtil.toJson(useRerankerDatas));
        if (useRerankerDatas != null && useRerankerDatas.size() > 0) {
            List<RerankChunk> rerankChunkList = useRerankerDatas.stream().map(o -> new RerankChunk(String.valueOf(o.getChunkId()), o.getChunk())).collect(Collectors.toList()).stream().distinct().collect(Collectors.toList());
            if (rerankChunkList != null && rerankChunkList.size() < topK) {
                topK = rerankChunkList.size();
                logger.info("\u3010RAG-Reranker\u3011\u91cd\u6392\u6a21\u578b\u5904\u7406\u5f85\u8bf7\u6c42\u6570\u636e\uff0c\u6587\u6863\u6570\u636e\u5c11\u4e8etopK,\u6570\u636e\u53d8\u66f4\u4e3a\uff1a{}", (Object)topK);
            }
            RerankMessage rerankMessage = new RerankMessage(serviceNumber, rerankChunkList, input, topK);
            logger.info("\u3010RAG-Reranker\u3011\u91cd\u6392\u6a21\u578b-\u6570\u636e\u9884\u5904\u7406\u53bb\u91cd\u540e\u8bf7\u6c42\u6d88\u606f\u4f53\uff1a{}", (Object)JsonUtil.toJson(rerankMessage));
            ResultRerank resultRerank = RerankService.getRerankServiceInstance(serviceNumber).syncRerank(rerankMessage);
            String errorCode = resultRerank.getErrorCode();
            if (Errors.OK.getCode().equals(errorCode)) {
                logger.info("\u3010RAG-Reranker\u3011\u91cd\u6392\u6a21\u578b\u5904\u7406\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JsonUtil.toJson(resultRerank));
                List<RerankChunk> rerankChunks = resultRerank.getData();
                Map rerankMap = rerankChunks.stream().collect(Collectors.toMap(RerankChunk::getChunkId, RerankChunk::getRelevanceScore, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
                List<GaiRepoSearchData> processedData = rerankChunks.stream().map(chunk -> {
                    GaiRepoSearchData data = useRerankerDatas.stream().filter(d -> d.getChunkId() == Long.parseLong(chunk.getChunkId())).findFirst().orElse(null);
                    if (data != null && rerankMap.containsKey(chunk.getChunkId())) {
                        data.setSimilarity(((Float)rerankMap.get(chunk.getChunkId())).floatValue());
                    }
                    return data;
                }).filter(data -> data != null && data.getSimilarity() >= similarity).collect(Collectors.toList());
                logger.info("\u3010RAG-Reranker\u3011\u91cd\u6392\u6a21\u578b\u76f8\u4f3c\u5ea6\u9608\u503c:{}\u8fc7\u6ee4,\u540e\u5904\u7406\u7ed3\u679c\uff1a{}", (Object)Float.valueOf(similarity), (Object)JsonUtil.toJson(processedData));
                return processedData;
            }
            String resultErr = JsonUtil.toJson(resultRerank);
            logger.error("\u3010RAG-Reranker\u3011\u91cd\u6392\u6a21\u578b\u8c03\u7528\u5f02\u5e38\uff1a{}", (Object)resultErr);
            throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.REPO_SEARCH_ERR, resultErr), new Object[0]);
        }
        logger.info("\u3010RAG-Reranker\u3011\u91cd\u6392\u6a21\u578b\u5904\u7406\u5f85\u8bf7\u6c42\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u6267\u884c\u91cd\u6392");
        return new ArrayList<GaiRepoSearchData>(1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static GaiRepoSearchData buildRepoSearchData(Chunk chunk, Float chunkSimilarity) {
        long repositoryId = chunk.getRepositoryId();
        long chunkId = chunk.getId();
        String title = chunk.getTitle();
        String url = chunk.getUrl();
        String chunkContent = chunk.getChunk();
        Long businessId = chunk.getBusinessId();
        int pageNum = chunk.getPage();
        int order = chunk.getOrder();
        GaiRepoSearchData gaiRepoSearchData = new GaiRepoSearchData(chunkId, repositoryId, businessId, chunkContent, pageNum, order);
        RepoFileVO repoFileVO = RepoService.getFileByChunkId(chunkId);
        if (StringUtils.isEmpty((CharSequence)title) && StringUtils.isEmpty((CharSequence)url)) {
            if (repoFileVO == null) throw new KDBizException(GaiExceptionUtil.buildErr(GaiErrorCode.RAG_REPO_CHUNK_EXEIT_ERR), new Object[0]);
            String fileSource = repoFileVO.getSource();
            if ("doc".equals(fileSource) || "code".equals(fileSource)) {
                String path = repoFileVO.getPath();
                title = repoFileVO.getName();
                url = FilePreviewService.getPreviewUrl(path);
            } else {
                title = repoFileVO.getTitle();
                url = repoFileVO.getUrl();
            }
        } else {
            boolean isNextCloud = url.startsWith("{domainContextUrl}");
            if (isNextCloud) {
                String domainContextUrl = UrlService.getDomainContextUrl();
                url = url.replaceFirst("\\{domainContextUrl\\}", domainContextUrl);
            }
        }
        gaiRepoSearchData.setTitle(title);
        gaiRepoSearchData.setUrl(url);
        gaiRepoSearchData.setFileName(repoFileVO.getName());
        gaiRepoSearchData.setFilePath(repoFileVO.getPath());
        gaiRepoSearchData.setFileType(repoFileVO.getFileType());
        gaiRepoSearchData.setSimilarity(chunkSimilarity.floatValue());
        return gaiRepoSearchData;
    }

    private static LinkedHashMap<Long, Float> vectorAlgoSimilarity(VectorMetricType vectorMetricType, LLM embeddingModel, List<Long> repoIdList, String userInput, int topk, float similarity) {
        if (embeddingModel == null) {
            throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.RAG_REPO_MS_PARAMS_ERR, "\u5411\u91cf\u6a21\u578b\u4e0d\u4e3a\u7a7a"), new Object[0]);
        }
        logger.info("\u3010RAG\u3011\u67e5\u8be2\u53ef\u7528\u5757\u6570\u636e,\u53c2\u6570 llm:{},repoIds:{},input:{},topk:{},similarity:{}", new Object[]{embeddingModel.getNumber(), JSON.toJSON(repoIdList), userInput, topk, Float.valueOf(similarity)});
        Result4Embedding result4Embedding = EmbeddingServiceFactory.getExecutor(embeddingModel, vectorMetricType).embedding(Collections.singletonList(userInput));
        if (!result4Embedding.getCode().equals(Errors.OK.getCode())) {
            throw new KDBizException(new ErrorCode(result4Embedding.getCode(), result4Embedding.getErrMsg()), new Object[]{result4Embedding.getErrMsg()});
        }
        List<Float> inputVector = result4Embedding.getVectorList().get(0);
        if (inputVector == null || inputVector.isEmpty()) {
            logger.error(Errors.EMBEDDING_ERROR.getMessage());
            throw new KDBizException(Errors.EMBEDDING_ERROR, new Object[0]);
        }
        LinkedHashMap<Long, Float> useChunkInfos = new LinkedHashMap<Long, Float>();
        if (MilvusService.enableVDB()) {
            List<VDBResult> vdbResults;
            logger.info("search vdb type by bos-vdb");
            CollectionData collectionData = VDBServiceManager.getStore(embeddingModel, vectorMetricType).search(inputVector, repoIdList, topk);
            if (collectionData != null && (vdbResults = VDBServiceConverter.toSearchVDBResults(collectionData)) != null && !vdbResults.isEmpty()) {
                for (VDBResult vdbResult : vdbResults) {
                    long chunkId = vdbResult.getId();
                    float score = 1.0f;
                    if (VectorMetricType.COSINE == vectorMetricType) {
                        float milvusScore = vdbResult.getScore();
                        float f = milvusScore == 1.0f ? 1.0f : (1.0f + milvusScore) / 2.0f;
                        score = f;
                        if (!(score >= similarity)) continue;
                        useChunkInfos.put(chunkId, Float.valueOf(score));
                        continue;
                    }
                    useChunkInfos.put(chunkId, Float.valueOf(score));
                }
            }
        } else {
            logger.info("search vdb type by gai-vdb");
            SearchResults searchResults = MilvusService.getExecutor(embeddingModel, vectorMetricType).search(inputVector, repoIdList, topk);
            if (searchResults != null) {
                List ids = searchResults.getResults().getIds().getIntId().getDataList();
                logger.info("\u3010RAG\u3011:\u68c0\u7d22\u5757IDS:{}", (Object)ids);
                if (ids != null && ids.size() > 0) {
                    SearchResultsWrapper searchWrapper = new SearchResultsWrapper(searchResults.getResults());
                    List idScores = searchWrapper.getIDScore(0);
                    int size = idScores.size();
                    for (int i = 0; i < size; ++i) {
                        Long chunkId = (Long)ids.get(i);
                        SearchResultsWrapper.IDScore idScore = (SearchResultsWrapper.IDScore)idScores.get(i);
                        float score = 1.0f;
                        if (VectorMetricType.COSINE == vectorMetricType) {
                            float milvusScore = idScore.getScore();
                            float f = score = milvusScore == 1.0f ? 1.0f : (1.0f + milvusScore) / 2.0f;
                            if (!(score >= similarity)) continue;
                            useChunkInfos.put(chunkId, Float.valueOf(score));
                            continue;
                        }
                        useChunkInfos.put(chunkId, Float.valueOf(score));
                    }
                    return useChunkInfos;
                }
                logger.warn("\u3010RAG\u3011\u672c\u6b21\u672a\u68c0\u7d22\u5230\u5757\u6570\u636e");
            }
        }
        logger.info("\u3010RAG\u3011\u5757\u5411\u91cf\u5e93-\u5f53\u524d\u5e93\u8ba1\u7b97\u7c7b\u578b:{},\u5f97\u5206\u60c5\u51b5:{},", (Object)vectorMetricType, useChunkInfos);
        return useChunkInfos;
    }
}

