/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.rag.service;

import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.ai.gai.core.domain.llm.EmbeddingParam;
import kd.ai.gai.core.enuz.EmbeddingModel;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.repo.RepoChunkDataPreRule;
import kd.ai.gai.core.enuz.repo.RepoChunkEmbeddingRule;
import kd.ai.gai.core.enuz.repo.RepoChunkIdentifierType;
import kd.ai.gai.core.enuz.repo.RepoChunkStrategy;
import kd.ai.gai.core.enuz.repo.RepoPreIdentifierRule;
import kd.ai.gai.core.enuz.repo.RepoSourceType;
import kd.ai.gai.core.rag.RepoChunkOperateConfig;
import kd.ai.gai.core.rag.RepoConfig;
import kd.ai.gai.core.rag.chunk.ChunkInput;
import kd.ai.gai.core.rag.chunk.ChunkServiceImpl;
import kd.ai.gai.core.rag.embedding.EmbeddingExeServiceFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.WaitingRejectedHandler;
import kd.bos.threads.impl.ThreadPoolImpl;

public class RepoDispatchService {
    private static Log LOGGER = LogFactory.getLog(RepoDispatchService.class);
    private static final String CHUNK_POOL_NAME = "ai-gai-pool-repo-chunk";
    private static final String EMBEDDING_POOL_NAME = "ai-gai-pool-repo-embedding";
    private static final int POOL_MAX_SIZE = 10;
    private static final int POOL_CORE_SIZE = 3;
    private static final long KEEP_ALIVE_LIVE = 5L;
    private static final int MAX_FIX_QUEUESIZE = 1000000;
    private static ExecutorService CHUNK_ES = RepoDispatchService.createFixedThreadPool("ai-gai-pool-repo-chunk");
    private static ExecutorService EMBEDDING_ES = RepoDispatchService.createFixedThreadPool("ai-gai-pool-repo-embedding");
    private static ThreadPool REPO_CHUNK_POOL = new ThreadPoolImpl(CHUNK_ES, null, aBoolean -> {});
    private static ThreadPool REPO_EMBEDDING_POOL = new ThreadPoolImpl(EMBEDDING_ES, null, aBoolean -> {});
    private static final String run_msg = "running";

    private static ExecutorService createFixedThreadPool(final String poolName) {
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>(1000000);
        ThreadPoolExecutor executor = new ThreadPoolExecutor(3, 10, 5L, TimeUnit.MINUTES, queue, new ThreadFactory(){
            private AtomicInteger atomicInteger = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, poolName + "-" + this.atomicInteger.incrementAndGet());
            }
        }, (RejectedExecutionHandler)new WaitingRejectedHandler());
        return ThreadLifeCycleManager.wrapExecutorService((ExecutorService)executor);
    }

    public static boolean dispatchTask(long repoId) {
        LOGGER.info("\u3010GPT-\u77e5\u8bc6\u5e93\u3011\u542f\u52a8\u5206\u5757\u4efb\u52a1 ai-gai-pool-repo");
        try {
            DynamicObject repoInfo = BusinessDataServiceHelper.loadSingle((Object)repoId, (String)"gai_repo_info");
            if (Objects.nonNull(repoInfo)) {
                String repoStatus = repoInfo.getString("status");
                String indexMethod = repoInfo.getString("index_method");
                String strategy = repoInfo.getString("chunk_strategy");
                RepoChunkStrategy chunkStrategy = RepoChunkStrategy.parse(strategy);
                LLM llm = LLM.parse(indexMethod);
                RepoChunkEmbeddingRule splitRule = RepoChunkEmbeddingRule.parse(llm, chunkStrategy);
                RepoChunkOperateConfig repoChunkOperateConfig = chunkStrategy == RepoChunkStrategy.IDENTIFIER ? RepoDispatchService.identifierStrategyMethod(repoInfo, splitRule) : new RepoChunkOperateConfig(splitRule);
                DynamicObjectCollection docs = repoInfo.getDynamicObjectCollection("doc_manage");
                switch (repoStatus) {
                    case "A": {
                        if (!Objects.nonNull(docs) || docs.size() <= 0) break;
                        LOGGER.info("\u3010GPT-\u77e5\u8bc6\u5e93\u3011\u65b0\u5efa\u5e93\uff0crepoId:{},\u52a0\u5165\u6267\u884c\u4efb\u52a1:{}", (Object)repoId, (Object)docs.size());
                        docs.forEach(doc -> RepoDispatchService.addChunkTask(repoId, repoChunkOperateConfig, doc));
                        break;
                    }
                    case "B": {
                        LOGGER.info("\u3010GPT-\u77e5\u8bc6\u5e93\u3011repoId:{},\u4efb\u52a1\u8fd0\u884c\u4e2d", (Object)repoId);
                        break;
                    }
                    case "C": 
                    case "D": {
                        LOGGER.info(String.format("\u3010GPT-\u77e5\u8bc6\u5e93\u3011repoId:%s\uff0c\u91cd\u65b0\u5206\u914d\u4efb\u52a1", repoId));
                        for (DynamicObject doc2 : docs) {
                            String fileStatus;
                            long fileId = (Long)doc2.getPkValue();
                            switch (fileStatus = doc2.getString("file_status")) {
                                case "A": {
                                    RepoDispatchService.addChunkTask(repoId, repoChunkOperateConfig, doc2);
                                    break;
                                }
                                case "H": 
                                case "D": {
                                    RepoDispatchService.clearOldChunkAddNew(repoId, repoChunkOperateConfig, doc2, fileId);
                                    break;
                                }
                                case "K": 
                                case "G": {
                                    RepoDispatchService.excEmbeddingTask(repoId, llm, fileId);
                                    break;
                                }
                                case "I": 
                                case "B": 
                                case "F": {
                                    LOGGER.info("\u3010GPT-\u77e5\u8bc6\u5e93\u3011repoId:%s,\u6587\u4ef6:%s,\u4efb\u52a1\u5904\u4e8e\u8fd0\u884c\u4e2d\uff0c\u4e0d\u52a0\u5165\u6267\u884c\u4efb\u52a1\u961f\u5217", (Object)repoId, (Object)fileId);
                                }
                            }
                        }
                        DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_doc_manage set fprogress=?,flog=?  where fid=? and ffilestatus in (?,?,?)", (Object[])new Object[]{Float.valueOf(0.0f), run_msg, repoId, "G", "D", "H"});
                        break;
                    }
                    default: {
                        LOGGER.info(String.format("\u3010GPT-\u77e5\u8bc6\u5e93\u3011repoId:%s,\u6570\u636e\u72b6\u6001\u672a\u77e5\uff1a%s", repoId, repoStatus));
                    }
                }
                LOGGER.info("\u3010GPT-\u77e5\u8bc6\u5e93\u3011\u542f\u52a8\u5206\u5757\u4efb\u52a1-\u6b63\u5728\u66f4\u65b0\u4efb\u52a1\u4e2d ai-gai-pool-repo");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u3010GPT-\u77e5\u8bc6\u5e93\u3011\u542f\u52a8\u5206\u5757\u4efb\u52a1-\u4efb\u52a1\u542f\u52a8\u5931\u8d25 ai-gai-pool-repo \u6267\u884c\u5668\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)e.getMessage(), (Object)e);
            return false;
        }
        return true;
    }

    private static RepoChunkOperateConfig identifierStrategyMethod(DynamicObject repoInfo, RepoChunkEmbeddingRule splitRule) {
        int type;
        int maxlength = repoInfo.getInt("chunk_maxlength");
        RepoChunkIdentifierType identifierType = null;
        String identifierContent = "";
        ArrayList<RepoChunkDataPreRule> preDataRule = new ArrayList<RepoChunkDataPreRule>();
        if (repoInfo.getBoolean("checkbox_replacesymbol")) {
            preDataRule.add(RepoChunkDataPreRule.REPLACE_CONTINUOUS);
        }
        if (repoInfo.getBoolean("checkbox_deleteurl")) {
            preDataRule.add(RepoChunkDataPreRule.DELETEURL);
        }
        if ((type = repoInfo.getInt("identifiertype")) == 1) {
            String mark = repoInfo.getString("combo_presetidentifier");
            String identifier = RepoPreIdentifierRule.forVal(mark);
            identifierType = RepoChunkIdentifierType.parse(identifier);
            return new RepoChunkOperateConfig(splitRule, maxlength, identifierType, preDataRule);
        }
        if (type == 2) {
            identifierContent = repoInfo.getString("text_customidentifier");
            identifierType = RepoChunkIdentifierType.CUSTOM;
            return new RepoChunkOperateConfig(splitRule, maxlength, identifierType, identifierContent, preDataRule);
        }
        return null;
    }

    private static void excEmbeddingTask(long repoId, LLM llm, long fileId) {
        DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_doc_manage set ffilestatus=?  where fentryid=?", (Object[])new Object[]{"F", fileId});
        RepoDispatchService.addEmbeddingTask(repoId, llm, fileId);
    }

    private static void clearOldChunkAddNew(long repoId, RepoChunkOperateConfig repoChunkOperateConfig, DynamicObject doc, long fileId) {
        DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_doc_manage set ffilestatus=?  where fentryid=?", (Object[])new Object[]{"A", fileId});
        DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"delete t_gai_text_chunk where ffileid =?", (Object[])new Object[]{fileId});
        RepoDispatchService.addChunkTask(repoId, repoChunkOperateConfig, doc);
    }

    private static boolean addChunkTask(long repoId, RepoChunkOperateConfig repoChunkOperateConfig, DynamicObject doc) {
        String filePath = doc.getString("file_path");
        String fileType = doc.getString("file_type");
        String fileSource = doc.getString("file_source");
        long fileId = (Long)doc.getPkValue();
        try {
            LOGGER.info(String.format("\u3010GPT-\u77e5\u8bc6\u5e93\u3011\u52a0\u5165\u5206\u5757\u4efb\u52a1-\u5f00\u59cb repoId: %s,fileId:%s", repoId, fileId));
            RepoSourceType sourceType = RepoSourceType.parse(fileSource, fileType);
            RepoConfig repoConfig = new RepoConfig(repoChunkOperateConfig, sourceType);
            ChunkInput chunkInput = new ChunkInput(repoId, fileId, filePath, fileType, repoConfig);
            REPO_CHUNK_POOL.execute((Runnable)new ChunkTask(chunkInput), RequestContext.get());
            LOGGER.info(String.format("\u3010GPT-\u77e5\u8bc6\u5e93\u3011\u52a0\u5165\u5206\u5757\u4efb\u52a1-\u5b8c\u6210 repoId: %s,fileId:%s", repoId, fileId));
        }
        catch (Exception e) {
            LOGGER.error("\u3010\u77e5\u8bc6\u5e93-\u5206\u5757\u3011\u4efb\u52a1\u542f\u52a8\u5931\u8d25 {} \u6267\u884c\u5668\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", new Object[]{EMBEDDING_POOL_NAME, e.getMessage(), e});
            DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_info set fstatus=? where fid = ?", (Object[])new Object[]{"D", repoId});
            DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_doc_manage set ffilestatus=?  where fentryid=?", (Object[])new Object[]{"D", fileId});
            return false;
        }
        return true;
    }

    private static boolean addChunkTaskByDB(long repoId, String strategy, LLM llm, DynamicObject doc) {
        String filePath = doc.getString("file_path");
        String fileType = doc.getString("file_type");
        String fileSource = doc.getString("file_source");
        long fileId = (Long)doc.getPkValue();
        try {
            LOGGER.info(String.format("\u3010GPT-\u77e5\u8bc6\u5e93\u3011\u52a0\u5165\u5206\u5757\u4efb\u52a1-\u5f00\u59cb repoId: %s,fileId:%s", repoId, fileId));
            RepoChunkStrategy chunkStrategy = RepoChunkStrategy.parse(strategy);
            RepoChunkEmbeddingRule repoChunkEmbeddingRule = RepoChunkEmbeddingRule.parse(llm, chunkStrategy);
            RepoSourceType sourceType = RepoSourceType.parse(fileSource, fileType);
            RepoChunkOperateConfig repoChunkOperateConfig = new RepoChunkOperateConfig(repoChunkEmbeddingRule);
            RepoConfig repoConfig = new RepoConfig(repoChunkOperateConfig, sourceType);
            ChunkInput chunkInput = new ChunkInput(repoId, fileId, filePath, fileType, repoConfig);
            REPO_CHUNK_POOL.execute((Runnable)new ChunkTask(chunkInput), RequestContext.get());
            LOGGER.info(String.format("\u3010GPT-\u77e5\u8bc6\u5e93\u3011\u52a0\u5165\u5206\u5757\u4efb\u52a1-\u5b8c\u6210 repoId: %s,fileId:%s", repoId, fileId));
        }
        catch (Exception e) {
            LOGGER.error("\u3010\u77e5\u8bc6\u5e93-\u5206\u5757\u3011\u4efb\u52a1\u542f\u52a8\u5931\u8d25 {} \u6267\u884c\u5668\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", new Object[]{EMBEDDING_POOL_NAME, e.getMessage(), e});
            DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_info set fstatus=? where fid = ?", (Object[])new Object[]{"D", repoId});
            DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_doc_manage set ffilestatus=?  where fentryid=?", (Object[])new Object[]{"D", fileId});
            return false;
        }
        return true;
    }

    public static boolean addEmbeddingTask(long repoId, LLM llm, long fileId) {
        try {
            LOGGER.info(String.format("\u3010\u77e5\u8bc6\u5e93-Embedding\u3011\u542f\u52a8\u4efb\u52a1 repoId:%s,fileId:%s", repoId, fileId));
            EmbeddingParam embeddingParam = new EmbeddingParam(repoId, fileId);
            REPO_EMBEDDING_POOL.execute((Runnable)new EmbeddingTask(llm, embeddingParam), RequestContext.get());
        }
        catch (Exception e) {
            LOGGER.error("\u3010\u77e5\u8bc6\u5e93-Embedding\u3011\u4efb\u52a1\u542f\u52a8\u5931\u8d25 {} \u6267\u884c\u5668\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", new Object[]{EMBEDDING_POOL_NAME, e.getMessage(), e});
            DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_info set fstatus=? where fid = ?", (Object[])new Object[]{"D", repoId});
            DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_doc_manage set ffilestatus=?  where fentryid=?", (Object[])new Object[]{"G", fileId});
            return false;
        }
        return true;
    }

    public static boolean addEmbeddingTaskByDB(long repoId, LLM llm) {
        try {
            LOGGER.info(String.format("\u3010\u77e5\u8bc6\u5e93-Embedding\u3011\u542f\u52a8DB\u5411\u91cf\u5316\u4efb\u52a1 repoId:%s", repoId));
            DynamicObject repoInfo = BusinessDataServiceHelper.loadSingle((Object)repoId, (String)"gai_repo_info");
            DynamicObjectCollection docs = repoInfo.getDynamicObjectCollection("doc_manage");
            for (DynamicObject doc : docs) {
                String fileStatus;
                long fileId = (Long)doc.getPkValue();
                switch (fileStatus = doc.getString("file_status")) {
                    case "A": 
                    case "B": 
                    case "H": 
                    case "D": 
                    case "K": 
                    case "G": {
                        try {
                            RepoDispatchService.excEmbeddingTask(repoId, llm, fileId);
                        }
                        catch (Exception e) {
                            LOGGER.error("\u3010\u77e5\u8bc6\u5e93-Embedding\u3011\u4efb\u52a1\u542f\u52a8\u5931\u8d25 {} \u6267\u884c\u5668\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", new Object[]{EMBEDDING_POOL_NAME, e.getMessage(), e});
                            DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_info set fstatus=? where fid = ?", (Object[])new Object[]{"D", repoId});
                            DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_doc_manage set ffilestatus=?  where fentryid=?", (Object[])new Object[]{"G", fileId});
                        }
                        break;
                    }
                    case "I": 
                    case "F": {
                        LOGGER.info("\u3010GPT-\u77e5\u8bc6\u5e93\u3011repoId:%s,\u6587\u4ef6:%s,\u4efb\u52a1\u5904\u4e8e\u8fd0\u884c\u4e2d\uff0c\u4e0d\u52a0\u5165\u6267\u884c\u4efb\u52a1\u961f\u5217", (Object)repoId, (Object)fileId);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u3010\u77e5\u8bc6\u5e93-Embedding\u3011\u4efb\u52a1\u542f\u52a8\u5931\u8d25 {} \u6267\u884c\u5668\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", new Object[]{EMBEDDING_POOL_NAME, e.getMessage(), e});
            DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_info set fstatus=? where fid = ?", (Object[])new Object[]{"D", repoId});
            return false;
        }
        return true;
    }

    private static class EmbeddingTask
    implements Runnable {
        private final LLM llm;
        private final EmbeddingParam embeddingParam;

        public EmbeddingTask(LLM llm, EmbeddingParam embeddingParam) {
            this.llm = llm;
            this.embeddingParam = embeddingParam;
        }

        @Override
        public void run() {
            EmbeddingModel embedding = EmbeddingModel.parse(this.llm);
            EmbeddingExeServiceFactory.getService(embedding).execute(this.embeddingParam);
        }
    }

    private static class DispatchEmbeddingByDBTask
    implements Runnable {
        private final LLM llm;
        private final long repoId;

        public DispatchEmbeddingByDBTask(LLM llm, long repoId) {
            this.llm = llm;
            this.repoId = repoId;
        }

        @Override
        public void run() {
            EmbeddingModel embedding = EmbeddingModel.parse(this.llm);
        }
    }

    private static class ChunkTask
    implements Runnable {
        private final ChunkInput chunkInput;

        public ChunkTask(ChunkInput chunkInput) {
            this.chunkInput = chunkInput;
        }

        @Override
        public void run() {
            ChunkServiceImpl chunkService = new ChunkServiceImpl();
            chunkService.execute(this.chunkInput);
        }
    }
}

