/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.rag.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.ai.gai.core.code.GaiErrorCode;
import kd.ai.gai.core.code.GaiExceptionUtil;
import kd.ai.gai.core.domain.dto.repo.RepoFulltextData;
import kd.ai.gai.core.domain.dto.repo.RepoFulltextDeleteParam;
import kd.ai.gai.core.domain.dto.repo.RepoFulltextIndex;
import kd.ai.gai.core.domain.dto.repo.RepoQueryParam;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.enuz.es.ESDataType;
import kd.ai.gai.core.enuz.es.ESFilterType;
import kd.ai.gai.core.enuz.es.ESIndexType;
import kd.ai.gai.core.enuz.es.ESTokenizerType;
import kd.ai.gai.core.service.es.ESClientFactory;
import kd.ai.gai.core.service.es.ESFilterEntity;
import kd.ai.gai.core.service.es.ESQueryParam;
import kd.ai.gai.core.service.es.ESService;
import kd.ai.gai.core.util.GaiBeanUtils;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;

public class RepoFulltextService {
    private static final Log log = LogFactory.getLog(ESService.class);
    private static final String indexType = ESIndexType.DOC.toString();
    private static final String repoIdKey = "repoId";
    private static final String fileIdKey = "fileId";
    private static final String chunkIdKey = "chunkId";
    private static final String contentKey = "content";
    private static final String[] fulltextReturnFields = new String[]{"repoId", "fileId", "chunkId", "content"};

    private RepoFulltextService() {
    }

    public static RepoFulltextService getInstance() {
        return Holder.service;
    }

    public boolean checkAlive() throws IOException {
        String index = this.getIndex();
        log.info("repo check fullText build index :{}", (Object)index);
        boolean indexExist = ESService.getInstance().isIndexExist(ESClientFactory.getEsClient(), index);
        log.info("repo check fullText index exist:{}", (Object)indexExist);
        return indexExist;
    }

    public void initRepoIndex() {
        try {
            String index = this.getIndex();
            log.info("repo init fullText build index :{}", (Object)index);
            ESService es = ESService.getInstance();
            boolean indexExist = es.isIndexExist(ESClientFactory.getEsClient(), index);
            log.info("repo init fullText index exist:{}", (Object)indexExist);
            if (!indexExist) {
                String indexMappingJson = this.buildMappingJson();
                log.info("repo init fullText build mapping :{}", (Object)indexMappingJson);
                es.createIndex(ESClientFactory.getEsClient(), index, indexType, indexMappingJson);
                log.info("repo init fullText create index:{},indexType:{} end ", (Object)index, (Object)indexType);
            } else {
                log.info("repo init fullText index is exist,no init");
            }
        }
        catch (Exception e) {
            log.error("repo init fullText index:[], init error", (Object)this.getIndex(), (Object)e);
            throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.REPO_FT_ERR, e.getMessage()), new Object[0]);
        }
    }

    public List<RepoFulltextData> qurey(RepoQueryParam param) throws IOException {
        ESService es = ESService.getInstance();
        String index = this.getIndex();
        ArrayList<ESFilterEntity> filters = new ArrayList<ESFilterEntity>(2);
        filters.add(new ESFilterEntity(repoIdKey, param.getRepoIds(), ESFilterType.TERMS));
        filters.add(new ESFilterEntity(contentKey, param.getQuery(), ESFilterType.MATCH));
        ESQueryParam queryParam = new ESQueryParam(index, filters, fulltextReturnFields, param.getTopK());
        SearchRequest request = es.buildSearchRequest(queryParam);
        request.indicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN);
        SearchHits searchHits = es.search(ESClientFactory.getEsClient(), request);
        ArrayList<RepoFulltextData> rfts = new ArrayList<RepoFulltextData>(param.getTopK());
        for (SearchHit hit : searchHits) {
            float score = hit.getScore();
            Map source = hit.getSourceAsMap();
            rfts.add(new RepoFulltextData(Long.parseLong(String.valueOf(source.get(repoIdKey) != null ? source.get(repoIdKey) : Integer.valueOf(0))), Long.parseLong(String.valueOf(source.get(fileIdKey) != null ? source.get(fileIdKey) : Integer.valueOf(0))), Long.parseLong(String.valueOf(source.get(chunkIdKey) != null ? source.get(chunkIdKey) : Integer.valueOf(0))), (String)source.get(contentKey), score));
        }
        return rfts;
    }

    public void delRepoIndex() throws IOException {
        String index = this.getIndex();
        log.info("repo del fullText index :{}", (Object)index);
        ESService.getInstance().deleteIndex(ESClientFactory.getEsClient(), index);
        log.info("repo del fullText index end");
    }

    public boolean batchSave(List<RepoFulltextData> ftds) {
        try {
            if (ftds == null || ftds.isEmpty()) {
                log.warn("\u3010RAG\u3011\u77e5\u8bc6\u5e93\uff0cES \u6279\u91cf\u4f20\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u5199\u5165\u6570\u636e");
                return true;
            }
            log.info("\u3010RAG\u3011\u77e5\u8bc6\u5e93\uff0cES\u63d2\u5165{}\u6761\uff0c\u7b2c\u4e00\u6761\u662f{}", (Object)ftds.size(), (Object)JsonUtil.toJson(ftds.get(0)));
            String index = this.getIndex();
            ArrayList<XContentBuilder> xContentBuilders = new ArrayList<XContentBuilder>(ftds.size());
            for (RepoFulltextData ftd : ftds) {
                xContentBuilders.add(this.bildIndexDataToXContent(ftd));
            }
            return ESService.getInstance().batchInsertDoc(ESClientFactory.getEsClient(), index, xContentBuilders);
        }
        catch (Throwable throwable) {
            log.error("\u3010RAG\u3011\u77e5\u8bc6\u5e93\uff0c\u65b0\u589e\u7d22\u5f15\u6570\u636e\u5f02\u5e38\uff1a{}", (Object)throwable.getMessage(), (Object)throwable);
            throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.REPO_FT_ERR, throwable.getMessage()), new Object[0]);
        }
    }

    public long deleteByQuery(RepoFulltextDeleteParam deleteParam) {
        try {
            Object[] chunkIds;
            if (deleteParam.getRepoId() == null) {
                log.error("\u3010RAG\u3011repo deleteByQuery repid is not null");
                throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.REPO_FT_ERR, "\u77e5\u8bc6\u5e93\u5220\u9664\u5168\u6587\u672c\u6570\u636e\uff0c\u77e5\u8bc6\u5e93ID\u4e3a null"), new Object[0]);
            }
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)repoIdKey, (Object)deleteParam.getRepoId()));
            Object[] fileIds = deleteParam.getFileIds();
            if (fileIds != null) {
                boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termsQuery((String)fileIdKey, (Object[])fileIds));
            }
            if ((chunkIds = deleteParam.getChunkIds()) != null) {
                boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termsQuery((String)chunkIdKey, (Object[])chunkIds));
            }
            long delCount = ESService.getInstance().deleteByQuery(ESClientFactory.getEsClient(), this.getIndex(), indexType, (QueryBuilder)boolQueryBuilder);
            log.info("\u3010RAG\u3011repo deleteByQuery deleted=" + delCount);
            return delCount;
        }
        catch (Exception e) {
            log.error("\u3010RAG\u3011\u77e5\u8bc6\u5e93\uff0c\u5220\u9664\u67e5\u8be2\u6307\u5b9a\u6570\u636e\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.REPO_FT_ERR, e.getMessage()), new Object[0]);
        }
    }

    public String getIndex() {
        String accountId = RequestContext.get().getAccountId();
        String tenantId = RequestContext.get().getTenantId();
        String tenantCode = tenantId.replaceAll("[^a-zA-Z0-9_]", "_").replaceAll("_+", "_");
        return String.format("%s_repo_%s_%s_data", "gaisearch", tenantCode, accountId).toLowerCase();
    }

    private String buildMappingJson() {
        log.info("\u3010RAG\u3011\u77e5\u8bc6\u5e93\u6784\u5efa\u5168\u6587\u7d22\u5f15Mapping \u5f00\u59cb");
        RepoFulltextIndex[] repoFulltextIndices = new RepoFulltextIndex[]{new RepoFulltextIndex(repoIdKey, ESDataType.LONG, ESTokenizerType.IKMAXWORD), new RepoFulltextIndex(fileIdKey, ESDataType.LONG, ESTokenizerType.IKMAXWORD), new RepoFulltextIndex(chunkIdKey, ESDataType.LONG, ESTokenizerType.IKMAXWORD), new RepoFulltextIndex(contentKey, ESDataType.STRING, ESTokenizerType.IKMAXWORD), new RepoFulltextIndex("contentType", ESDataType.STRING, ESTokenizerType.IKMAXWORD), new RepoFulltextIndex("title", ESDataType.STRING, ESTokenizerType.IKMAXWORD), new RepoFulltextIndex("desc", ESDataType.STRING, ESTokenizerType.IKMAXWORD)};
        String mappingIndex = ESService.getInstance().buildMappingIndex(indexType, repoFulltextIndices);
        log.info("\u3010RAG\u3011\u77e5\u8bc6\u5e93\u6784\u5efa\u5168\u6587\u7d22\u5f15Mapping \u5b8c\u6210\uff0c\u4fe1\u606f\uff1a{}", (Object)mappingIndex);
        return mappingIndex;
    }

    private XContentBuilder bildIndexDataToXContent(RepoFulltextData data) throws Throwable {
        if (data == null) {
            throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.REPO_FT_ERR, "\u6570\u636e\u4e3a\u7a7a"), new Object[0]);
        }
        Map<String, Object> element = GaiBeanUtils.processElement(data);
        XContentBuilder xContentBuilder = XContentFactory.jsonBuilder().startObject();
        Set<Map.Entry<String, Object>> entries = element.entrySet();
        for (Map.Entry<String, Object> next : entries) {
            xContentBuilder.field(next.getKey(), next.getValue());
        }
        return xContentBuilder.endObject();
    }

    private static class Holder {
        private static RepoFulltextService service = new RepoFulltextService();

        private Holder() {
        }
    }
}

