/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.rag.service;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.Constant;
import kd.ai.gai.core.aop.GaiMService;
import kd.ai.gai.core.code.GaiErrorCode;
import kd.ai.gai.core.code.GaiExceptionUtil;
import kd.ai.gai.core.domain.dto.repo.GaiEmbeddingData;
import kd.ai.gai.core.domain.dto.repo.GaiRepoFileData;
import kd.ai.gai.core.domain.mservice.GaiRepoAddFileParams;
import kd.ai.gai.core.domain.mservice.GaiRepoCreateParams;
import kd.ai.gai.core.domain.vo.RepoDataInfo;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.repo.RepoChunkDataPreRule;
import kd.ai.gai.core.enuz.repo.RepoChunkEmbeddingRule;
import kd.ai.gai.core.enuz.repo.RepoChunkStrategy;
import kd.ai.gai.core.enuz.repo.RepoPreIdentifierRule;
import kd.ai.gai.core.enuz.repo.RepoServiceCallType;
import kd.ai.gai.core.rag.service.RepoDispatchService;
import kd.ai.gai.core.service.AiccService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;

public class RepoService {
    private static final Log logger = LogFactory.getLog(RepoService.class);
    private static final long max_file_size = 0x6400000L;
    private static final String repos_file_id = "doc_manage.id";
    private static final String repos_file_name = "doc_manage.file_name";
    private static final String repos_file_status = "doc_manage.file_status";
    private static final String repos_file_path = "doc_manage.file_path";
    private static final String repo_file_select_field = String.join((CharSequence)",", "doc_manage.id", "doc_manage.file_name", "doc_manage.file_status", "doc_manage.file_path");
    private static final String repo_select_field = String.join((CharSequence)",", "id", "number", "name", "isfulltext", "useorg", "repo_source", "desc", "status", "index_method", "type", "modifytime");
    private static final String preset = "preset";
    private static final String custom = "custom";

    public static RepoDataInfo createRepo(RepoServiceCallType callType, GaiRepoCreateParams params) {
        return GaiMService.execute(String.format("%s-\u521b\u5efa\u95ee\u7b54\u77e5\u8bc6\u5e93", new Object[]{callType}), params, p -> {
            RequestContext rc = RequestContext.get();
            long currUserId = rc.getCurrUserId();
            String repoName = params.getName();
            String repoType = params.getType();
            long useOrg = params.getUseOrg();
            String indexMethod = params.getIndexMethod();
            String desc = params.getDesc();
            String chunkStrategy = params.getChunkStrategy();
            List<GaiRepoCreateParams.RepoFileParam> fileInfos = params.getFileInfos();
            if (StringUtils.isEmpty((String)chunkStrategy)) {
                chunkStrategy = RepoChunkStrategy.BASE_FIXED_LENGTH.getType();
            }
            GaiRepoCreateParams.IdentifierStrategyContent identifierStrategyContent = params.getIdentifierStrategyContent();
            int chunkMaxLenth = 0;
            String identifierType = "";
            String identifierContent = "";
            String[] preDataRule = null;
            if (identifierStrategyContent != null) {
                chunkMaxLenth = identifierStrategyContent.getChunkMaxLenth();
                identifierType = identifierStrategyContent.getIdentifierType();
                identifierContent = identifierStrategyContent.getIdentifierContent();
                preDataRule = identifierStrategyContent.getPreDataRule();
            }
            indexMethod = RepoService.indexMethodModify(indexMethod);
            RepoService.checkMustParams(repoName, repoType, useOrg, fileInfos, chunkStrategy, indexMethod, chunkMaxLenth, identifierType, identifierContent);
            DynamicObject repoInfo = BusinessDataServiceHelper.newDynamicObject((String)"gai_repo_info");
            String repoNumber = CodeRuleServiceHelper.getNumber((String)repoInfo.getDataEntityType().getName(), (DynamicObject)repoInfo, null);
            long repoId = ORM.create().genLongId("gai_repo_info");
            repoInfo.set("id", (Object)repoId);
            repoInfo.set("name", (Object)repoName);
            repoInfo.set("number", (Object)repoNumber);
            repoInfo.set("useorg", (Object)useOrg);
            repoInfo.set("type", (Object)repoType);
            repoInfo.set("chunk_strategy", (Object)chunkStrategy);
            repoInfo.set("creator", (Object)currUserId);
            repoInfo.set("desc", (Object)desc);
            repoInfo.set("enable", (Object)"1");
            repoInfo.set("index_method", (Object)indexMethod);
            repoInfo.set("status", (Object)"A");
            repoInfo.set("repo_source", (Object)"ms");
            repoInfo.set("file_total", (Object)(fileInfos != null ? fileInfos.size() : 0));
            if (chunkStrategy.equals(RepoChunkStrategy.IDENTIFIER.getType())) {
                repoInfo.set("chunk_maxlength", (Object)chunkMaxLenth);
                if (identifierType.equals(custom)) {
                    repoInfo.set("text_customidentifier", (Object)identifierContent);
                    repoInfo.set("identifiertype", (Object)2);
                } else if (identifierType.equals(preset)) {
                    String identifierVal = RepoPreIdentifierRule.forIdentifier(identifierContent);
                    repoInfo.set("combo_presetidentifier", (Object)identifierVal);
                    repoInfo.set("identifiertype", (Object)1);
                }
                if (preDataRule != null) {
                    RepoService.matchPreRules(preDataRule, repoInfo);
                }
            }
            DynamicObjectCollection docs = repoInfo.getDynamicObjectCollection("doc_manage");
            logger.info("\u3010GPT-\u5fae\u670d\u52a1\u670d\u52a1\u3011\u521b\u5efa\u95ee\u7b54\u77e5\u8bc6\u5e93-\u5165\u5e93\u5f00\u59cb\uff0crepoId:{}", (Object)repoId);
            for (GaiRepoCreateParams.RepoFileParam f : fileInfos) {
                DynamicObject doc = docs.addNew();
                doc.set("file_name", (Object)f.getFileName());
                doc.set("file_type", (Object)f.getFileType());
                doc.set("file_path", (Object)f.getFilePath());
                doc.set("file_size", (Object)f.getFileSize());
                doc.set("file_status", (Object)"A");
                String currenFileSource = RepoService.getFileSource(repoType, f.getFileType());
                doc.set("file_source", (Object)currenFileSource);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{repoInfo});
            logger.info("\u3010GPT-\u5fae\u670d\u52a1\u670d\u52a1\u3011\u521b\u5efa\u95ee\u7b54\u77e5\u8bc6\u5e93-\u5165\u5e93\u5b8c\u6210\uff0crepoId:{}", (Object)repoId);
            boolean start = RepoDispatchService.dispatchTask(repoId);
            if (!start) {
                DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_info set fstatus=? where fid = ?", (Object[])new Object[]{"D", repoId});
                throw new KDBizException(GaiExceptionUtil.buildErr(GaiErrorCode.RAG_REPO_TASK_ERR), new Object[0]);
            }
            DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_info set fstatus=? where fid = ?", (Object[])new Object[]{"B", repoId});
            logger.info("\u3010GPT-\u5fae\u670d\u52a1\u670d\u52a1\u3011\u95ee\u7b54\u77e5\u8bc6\u5e93\uff0crepoId:{}-\u4efb\u52a1\u542f\u52a8\u6210\u529f", (Object)repoId);
            return new RepoDataInfo(repoId, repoNumber, repoName);
        });
    }

    private static String indexMethodModify(String indexMethod) {
        List<GaiEmbeddingData> useableEmbeddings = RepoService.getGaiUseableEmbedding();
        if (useableEmbeddings.isEmpty()) {
            GaiExceptionUtil.throwGaiException(GaiErrorCode.RAG_REPO_EMBEDDING_LLM_ERR);
        }
        if (StringUtils.isEmpty((String)indexMethod)) {
            indexMethod = useableEmbeddings.get(0).getNumber();
        } else {
            boolean isvalid = false;
            for (GaiEmbeddingData modelData : useableEmbeddings) {
                if (!modelData.getNumber().equals(indexMethod)) continue;
                isvalid = true;
                break;
            }
            if (!isvalid) {
                indexMethod = useableEmbeddings.get(0).getNumber();
            }
        }
        return indexMethod;
    }

    private static void matchPreRules(String[] preRules, DynamicObject repoInfo) {
        for (String preRule : preRules) {
            if (RepoChunkDataPreRule.REPLACE_CONTINUOUS.getVal().equals(preRule)) {
                repoInfo.set("checkbox_replacesymbol", (Object)true);
            }
            if (!RepoChunkDataPreRule.DELETEURL.getVal().equals(preRule)) continue;
            repoInfo.set("checkbox_deleteurl", (Object)true);
        }
    }

    public static List<GaiRepoFileData> queryRepoFilesInfo(RepoServiceCallType callType, long repoId) {
        return GaiMService.execute(String.format("%s-\u67e5\u8be2\u77e5\u8bc6\u5e93\u6587\u4ef6\u5217\u8868\u4fe1\u606f", new Object[]{callType}), repoId, p -> {
            List files;
            DynamicObjectCollection repoObjs = QueryServiceHelper.query((String)"gai_repo_info", (String)repo_file_select_field, (QFilter[])new QFilter[]{new QFilter("id", "=", p)});
            if (repoObjs != null && repoObjs.size() > 0) {
                files = new ArrayList(repoObjs.size());
                for (DynamicObject repoObj : repoObjs) {
                    Long fileId = repoObj.getLong(repos_file_id);
                    String name = repoObj.getString(repos_file_name);
                    String path = repoObj.getString(repos_file_path);
                    String status = repoObj.getString(repos_file_status);
                    GaiRepoFileData repoFileDTO = new GaiRepoFileData(fileId, name, path, status);
                    files.add(repoFileDTO);
                }
            } else {
                files = Collections.emptyList();
            }
            return files;
        });
    }

    public static List<GaiEmbeddingData> queryIndexMethod(RepoServiceCallType callType) {
        return GaiMService.execute(String.format("%s-\u67e5\u8be2\u77e5\u8bc6\u5e93\u7d22\u53ef\u7528\u5f15\u65b9\u5f0f", new Object[]{callType}), null, o -> {
            LLM[] llms = LLM.values();
            List<String> instanceList = AiccService.getAiccInstanceList();
            ArrayList<GaiEmbeddingData> list = new ArrayList<GaiEmbeddingData>(llms.length);
            for (LLM llm : llms) {
                if (!llm.isActive() || llm.getModelType() != LLM.ModelType.EMBEDDING || !instanceList.contains(llm.getNumber())) continue;
                list.add(new GaiEmbeddingData(llm.getNumber(), llm.getName()));
            }
            return list;
        });
    }

    public static boolean addRepoFiles(RepoServiceCallType callType, GaiRepoAddFileParams params) {
        return GaiMService.execute(String.format("%s-\u65b0\u589e\u77e5\u8bc6\u5e93\u6587\u4ef6", new Object[]{callType}), params, p -> {
            long repoId = params.getRepoId();
            List<GaiRepoCreateParams.RepoFileParam> fileInfos = params.getFileInfos();
            DynamicObject repoObj = QueryServiceHelper.queryOne((String)"gai_repo_info", (String)repo_select_field, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)repoId)});
            RepoService.checkExistAndRunning(repoObj);
            StringBuilder msg = new StringBuilder();
            String repoType = repoObj.getString("type");
            RepoService.checkMustFilesParams(msg, repoType, fileInfos);
            String status = repoObj.getString("status");
            if ("B".equals(status)) {
                logger.info("\u3010\u77e5\u8bc6\u5e93\u3011\u4efb\u52a1\u8fd0\u884c\u4e2d\uff0c\u8bf7\u5b8c\u6210\u540e\u518d\u64cd\u4f5c\u3002");
                GaiExceptionUtil.throwGaiException(GaiErrorCode.RAG_REPO_RUNNING_ERR);
            }
            int size = fileInfos.size();
            long[] ids = ORM.create().genLongIds("gai_repo_info", size);
            String sql = "INSERT INTO T_GAI_REPO_DOC_MANAGE (FID,FENTRYID,FFILENAME,FFILESTATUS,FFILEPATH,FFILESIZE,FFILETYPE,FCREATEDATE,FFILESOURCE) VALUES (?,?,?,?,?,?,?,?,?)";
            for (int i = 0; i < fileInfos.size(); ++i) {
                GaiRepoCreateParams.RepoFileParam fileParam = fileInfos.get(i);
                RepoService.insertOneFile(repoId, repoType, ids[i], sql, fileParam);
            }
            boolean start = RepoDispatchService.dispatchTask(repoId);
            DynamicObject repo = QueryServiceHelper.queryOne((String)"gai_repo_info", (String)"file_total", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)repoId)});
            int repoFileTotal = repo.getInt("file_total");
            if (start) {
                DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_info set fstatus=?,ffiletotal=? where fid = ?", (Object[])new Object[]{"B", repoFileTotal + size, repoId});
            } else {
                DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_info set fstatus=?,ffiletotal=? where fid = ?", (Object[])new Object[]{"D", repoFileTotal + size, repoId});
                GaiExceptionUtil.throwGaiException(GaiErrorCode.RAG_REPO_TASK_ERR);
            }
            return Boolean.TRUE;
        });
    }

    public static boolean deleteRepoById(RepoServiceCallType callType, long repoId) {
        return GaiMService.execute(String.format("%s-\u5220\u9664\u77e5\u8bc6\u5e93", new Object[]{callType}), repoId, p -> {
            DynamicObject repoObj = QueryServiceHelper.queryOne((String)"gai_repo_info", (String)repo_select_field, (QFilter[])new QFilter[]{new QFilter("id", "=", p)});
            RepoService.checkExistAndRunning(repoObj);
            boolean del = "dev".equalsIgnoreCase(repoObj.getString("repo_source"));
            kd.ai.gai.core.service.RepoService.delRepoChunkAndVectorByIds(new Object[]{p}, del);
            MainEntityType repoEntityType = EntityMetadataCache.getDataEntityType((String)"gai_repo_info");
            DeleteServiceHelper.delete((IDataEntityType)repoEntityType, (Object[])new Object[]{p});
            return Boolean.TRUE;
        });
    }

    private static void checkMustParams(String repoName, String repoType, long useOrg, List<GaiRepoCreateParams.RepoFileParam> fileInfos, String chunkStrategy, String indexMethod, int chunkMaxLength, String identifierType, String identifierContent) {
        StringBuilder msg = new StringBuilder();
        if (StringUtils.isEmpty((String)repoName)) {
            msg.append("repoName,");
        }
        if (StringUtils.isEmpty((String)repoType)) {
            msg.append("type,");
        }
        if (!(StringUtils.isEmpty((String)chunkStrategy) || RepoChunkStrategy.BASE_FIXED_LENGTH.getType().equals(chunkStrategy) || RepoChunkStrategy.CUSTOMIZE.getType().equals(chunkStrategy) || RepoChunkStrategy.IDENTIFIER.getType().equals(chunkStrategy))) {
            msg.append("chunkStrategy,");
        }
        ArrayList<String> propList = new ArrayList<String>();
        propList.add("number");
        Map orgInfo = OrgUnitServiceHelper.getOrgProperty((long)useOrg, propList);
        if (orgInfo == null || orgInfo.isEmpty()) {
            msg.append("useOrg,");
        }
        if (RepoChunkStrategy.IDENTIFIER.getType().equals(chunkStrategy)) {
            RepoService.checkIdentifierParams(msg, indexMethod, chunkMaxLength, identifierType, identifierContent);
        }
        RepoService.checkMustFilesParams(msg, repoType, fileInfos);
    }

    private static void checkIdentifierParams(StringBuilder msg, String indexMethod, int chunkMaxLength, String identifierType, String identifierContent) {
        if (!identifierType.equals(preset) && !identifierType.equals(custom)) {
            msg.append("identifierType,");
            return;
        }
        for (RepoChunkEmbeddingRule rule : RepoChunkEmbeddingRule.VALUE) {
            if (rule.getChunkStrategy() != RepoChunkStrategy.IDENTIFIER || !indexMethod.equals(rule.getLlm().getNumber())) continue;
            if (chunkMaxLength <= rule.getMaxSize() && chunkMaxLength >= rule.getMinSize()) break;
            msg.append(String.format("[\u4e0d\u652f\u6301\u7684chunkMaxLength\uff0c\u5bf9\u4e8e %s \uff0cchunkMaxLength\u53d6\u503c\u8303\u56f4\u9700\u5728 %d \u548c %d \u4e4b\u95f4],", indexMethod, rule.getMinSize(), rule.getMaxSize()));
            break;
        }
        if (identifierType.equals(preset)) {
            boolean isvaild = false;
            for (RepoPreIdentifierRule rule : RepoPreIdentifierRule.VALUES) {
                if (!rule.getIdentifier().equals(identifierContent)) continue;
                isvaild = true;
                break;
            }
            if (!isvaild) {
                msg.append("[\u6ca1\u6709\u5bf9\u5e94\u7684\u9884\u7f6e\u6807\u8bc6\u7b26\u4e0eidentifierContent\u5339\u914d],");
            }
        } else if (identifierContent.length() > 20) {
            msg.append("[\u81ea\u5b9a\u4e49\u6807\u8bc6\u7b26identifierContent\u957f\u5ea6\u9700\u5c0f\u4e8e20],");
        }
    }

    private static void checkMustFilesParams(StringBuilder msg, String repoType, List<GaiRepoCreateParams.RepoFileParam> fileInfos) {
        if (fileInfos == null || fileInfos.isEmpty()) {
            msg.append("fileInfos,");
        } else {
            boolean outOfRange = fileInfos.stream().anyMatch(f -> f.getFileSize() > 0x6400000L || f.getFileSize() <= 0L);
            if (outOfRange) {
                msg.append("\u6587\u4ef6\u5927\u5c0f\u4e0d\u6ee1\u8db3\uff1a\u5927\u4e8e0MB\u6216\u5c0f\u4e8e\u7b49\u4e8e100MB \u8981\u6c42,");
            }
            if ("kd_code_gen".equals(repoType)) {
                boolean typefail = fileInfos.stream().allMatch(f -> f.getFileType().contains("json"));
                if (typefail) {
                    msg.append("\u4ee3\u7801\u751f\u6210\u77e5\u8bc6\u5e93\uff0c\u6587\u4ef6\u7c7b\u578b\u5fc5\u987b\u90fd\u4e3ajson,");
                }
            } else {
                boolean typefail = fileInfos.stream().allMatch(f -> Arrays.asList(Constant.RepoInfo.handle_file_type).contains(f.getFileType()));
                if (!typefail) {
                    msg.append("\u95ee\u7b54\u77e5\u8bc6\u5e93\uff0c\u6587\u4ef6\u7c7b\u578b\u5fc5\u987b\u4e3a\uff1atext,pdf,json,doc,docx");
                }
            }
        }
        if (StringUtils.isNotEmpty((String)msg.toString())) {
            msg.append("\u53c2\u6570\u4e0d\u5408\u89c4");
            GaiExceptionUtil.throwGaiException(GaiErrorCode.RAG_REPO_PARAMS_ERR, msg.toString());
        }
    }

    private static void insertOneFile(long repoId, String repoType, long id, String sql, GaiRepoCreateParams.RepoFileParam fileParam) {
        String currenFileSource = RepoService.getFileSource(repoType, fileParam.getFileType());
        DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)sql, (Object[])new Object[]{repoId, id, fileParam.getFileName(), "A", fileParam.getFilePath(), fileParam.getFileSize(), fileParam.getFileType(), new Timestamp(System.currentTimeMillis()), currenFileSource});
    }

    private static void checkExistAndRunning(DynamicObject repoObj) {
        if (repoObj != null) {
            String status = repoObj.getString("status");
            if ("B".equals(status)) {
                logger.info("\u3010\u77e5\u8bc6\u5e93\u3011\u4efb\u52a1\u8fd0\u884c\u4e2d\uff0c\u8bf7\u5b8c\u6210\u540e\u518d\u64cd\u4f5c\u3002");
                GaiExceptionUtil.throwGaiException(GaiErrorCode.RAG_REPO_RUNNING_ERR);
            }
        } else {
            GaiExceptionUtil.throwGaiException(GaiErrorCode.RAG_REPO_EXEIT_ERR);
        }
    }

    private static List<GaiEmbeddingData> getGaiUseableEmbedding() {
        LLM[] llms = LLM.values();
        List<String> instanceList = AiccService.getAiccInstanceList();
        ArrayList<GaiEmbeddingData> list = new ArrayList<GaiEmbeddingData>(llms.length);
        for (LLM llm : llms) {
            if (!llm.isActive() || llm.getModelType() != LLM.ModelType.EMBEDDING || !instanceList.contains(llm.getNumber())) continue;
            list.add(new GaiEmbeddingData(llm.getNumber(), llm.getName()));
        }
        return list;
    }

    private static String getFileSource(String repoType, String fileType) {
        String currenFileSource = "kd_code_gen".equals(repoType) ? "code" : ("qa".equals(repoType) && fileType.contains("json") ? "html" : "doc");
        return currenFileSource;
    }
}

