/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.rag.split;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import kd.ai.gai.core.domain.dto.Chunk;
import kd.ai.gai.core.rag.MergeConfig;
import kd.ai.gai.core.rag.RepoChunkOperateConfig;
import kd.ai.gai.core.rag.Sentence;
import kd.ai.gai.core.rag.split.AbstractSplitter;
import kd.ai.gai.core.service.ChunkService;

public class IdentifierSplitter
extends AbstractSplitter {
    private static final int lowerLimit = 50;
    private static final int defaultLength = 100;

    @Override
    public ArrayList<Sentence> split(int page, String content, RepoChunkOperateConfig repoChunkOperateConfig) {
        ArrayList<Sentence> chunks = new ArrayList<Sentence>();
        content = IdentifierSplitter.dataPreprocessWithRule(content, repoChunkOperateConfig);
        String[] chunksArray = content.split(repoChunkOperateConfig.getIdentifierContent());
        LinkedList<String> preChunks = new LinkedList<String>(Arrays.asList(chunksArray));
        int max = repoChunkOperateConfig.getChunkMaxLength();
        if (max < 50) {
            max = 50;
        }
        for (String prechunk : preChunks) {
            int headindex = 0;
            for (int tailindex = max; tailindex < prechunk.length(); tailindex += max) {
                String curStr = prechunk.substring(headindex, tailindex);
                if (!IdentifierSplitter.uselessDataFilter(curStr)) {
                    chunks.add(new Sentence(page, curStr, IdentifierSplitter.isComplete(curStr)));
                }
                headindex = tailindex;
            }
            if (headindex != 0) {
                String curStr = prechunk.substring(headindex);
                if (IdentifierSplitter.uselessDataFilter(curStr)) continue;
                chunks.add(new Sentence(page, curStr, IdentifierSplitter.isComplete(curStr)));
                continue;
            }
            if (IdentifierSplitter.uselessDataFilter(prechunk)) continue;
            chunks.add(new Sentence(page, prechunk, IdentifierSplitter.isComplete(prechunk)));
        }
        return chunks;
    }

    @Override
    public LinkedList<Chunk> merge(MergeConfig mergeConfig, List<Sentence> sentences) {
        LinkedList<Chunk> chunks = new LinkedList<Chunk>();
        if (sentences != null && !sentences.isEmpty()) {
            long repositoryId = mergeConfig.getRepositoryId();
            long fileId = mergeConfig.getFileId();
            int perPage = sentences.get(0).getPage();
            int startCount = mergeConfig.getStartChunkOrder();
            for (int i = 0; i < sentences.size(); ++i) {
                Sentence sentence = sentences.get(i);
                String sentenceContent = sentence.getContent();
                boolean complete = sentence.isComplete();
                Chunk chunk = new Chunk(repositoryId, fileId, perPage, startCount, sentenceContent, complete);
                chunks.add(chunk);
                if (i >= sentences.size() - 1) continue;
                int nextSentencePage = sentences.get(i + 1).getPage();
                if (perPage != nextSentencePage) {
                    perPage = nextSentencePage;
                    startCount = 1;
                    continue;
                }
                ++startCount;
            }
        }
        return chunks;
    }

    @Override
    public boolean mergeToDB(MergeConfig mergeConfig, List<Sentence> sentences) {
        LinkedList<Chunk> chunks = new LinkedList<Chunk>();
        if (sentences != null && !sentences.isEmpty()) {
            long repositoryId = mergeConfig.getRepositoryId();
            long fileId = mergeConfig.getFileId();
            int perPage = sentences.get(0).getPage();
            int startCount = mergeConfig.getStartChunkOrder();
            for (int i = 0; i < sentences.size(); ++i) {
                Sentence sentence = sentences.get(i);
                String sentenceContent = sentence.getContent();
                boolean complete = sentence.isComplete();
                Chunk chunk = new Chunk(repositoryId, fileId, perPage, startCount, sentenceContent, complete);
                chunks.add(chunk);
                if (i < sentences.size() - 1) {
                    int nextSentencePage = sentences.get(i + 1).getPage();
                    if (perPage != nextSentencePage) {
                        perPage = nextSentencePage;
                        startCount = 1;
                    } else {
                        ++startCount;
                    }
                }
                ChunkService.batchConditionInsert(chunks);
            }
        }
        if (!chunks.isEmpty()) {
            ChunkService.insert(chunks);
        }
        return true;
    }
}

