/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.rag.split;

import java.util.EnumMap;
import java.util.Map;
import kd.ai.gai.core.enuz.repo.RepoChunkStrategy;
import kd.ai.gai.core.enuz.repo.SpliteType;
import kd.ai.gai.core.rag.split.AbstractSplitter;
import kd.ai.gai.core.rag.split.IdentifierSplitter;
import kd.ai.gai.core.rag.split.SentenceSplitter;
import kd.bos.exception.KDBizException;

public class SplitFactory {
    public static AbstractSplitter getSplit(SpliteType spliteType) {
        AbstractSplitter spliter = (AbstractSplitter)Holder.SPLIT_SERVICES.get((Object)spliteType);
        if (spliter != null) {
            return spliter;
        }
        throw new KDBizException("\u4e0d\u652f\u6301\u7684\u5207\u5272\u7c7b\u578b");
    }

    public static AbstractSplitter getSplit(RepoChunkStrategy repoChunkStrategy) {
        AbstractSplitter spliter = null;
        if (repoChunkStrategy.getType().equals(RepoChunkStrategy.IDENTIFIER.getType())) {
            spliter = SplitFactory.getSplit(SpliteType.IDENTIFIER);
        } else if (repoChunkStrategy.getType().equals(RepoChunkStrategy.BASE_FIXED_LENGTH.getType()) || repoChunkStrategy.getType().equals(RepoChunkStrategy.CUSTOMIZE.getType())) {
            spliter = SplitFactory.getSplit(SpliteType.SENTENCE);
        }
        if (spliter != null) {
            return spliter;
        }
        throw new KDBizException("\u4e0d\u652f\u6301\u7684\u5207\u5272\u7c7b\u578b");
    }

    private static class Holder {
        private static final Map<SpliteType, AbstractSplitter> SPLIT_SERVICES = new EnumMap<SpliteType, AbstractSplitter>(SpliteType.class);

        private Holder() {
        }

        static {
            SPLIT_SERVICES.put(SpliteType.SENTENCE, new SentenceSplitter());
            SPLIT_SERVICES.put(SpliteType.IDENTIFIER, new IdentifierSplitter());
        }
    }
}

