/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.repo.exp;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.fileservice.BatchDownloadRequest;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class ExportFileRepoTask {
    private static final Log logger = LogFactory.getLog(ExportFileRepoTask.class);
    private static final String REPOFILE_FILE_PREFIX = "REPO_FILE";
    private String targetFileName;
    private String targetDirectory;
    private List<Object> pkIds;
    private ExportResult result;
    private Map<Long, String> mapAttachmentsPath = new LinkedHashMap<Long, String>();
    private Map<Long, String> mapAttachmentsFileName = new HashMap<Long, String>();

    public ExportFileRepoTask(String targetFileName, String targetDirectory, List<Object> pkIds) {
        this.targetFileName = targetFileName;
        this.targetDirectory = targetDirectory;
        this.pkIds = pkIds;
    }

    public ExportResult export() {
        this.result = new ExportResult();
        this.exportData();
        this.exportAttachments();
        return this.result;
    }

    private void exportAttachments() {
        if (this.mapAttachmentsPath.isEmpty()) {
            return;
        }
        try {
            FileService fs = FileServiceFactory.getAttachmentFileService();
            BatchDownloadRequest.Dir attaDir = new BatchDownloadRequest.Dir("attachments");
            BatchDownloadRequest.File[] attaFiles = new BatchDownloadRequest.File[this.mapAttachmentsPath.size()];
            int i = 0;
            for (Map.Entry<Long, String> entry : this.mapAttachmentsFileName.entrySet()) {
                BatchDownloadRequest.File file;
                Long entryPkId = entry.getKey();
                String fileName = entry.getValue();
                fileName = String.format("%s_%s", entryPkId, fileName);
                String filePath = this.mapAttachmentsPath.get(entryPkId);
                attaFiles[i] = file = new BatchDownloadRequest.File(fileName, filePath);
                ++i;
            }
            attaDir.setFiles(attaFiles);
            String attaZipKey = "repo_info_entry_attachments";
            BatchDownloadRequest downloadRequest = new BatchDownloadRequest(attaZipKey);
            downloadRequest.setDirs(new BatchDownloadRequest.Dir[]{attaDir});
            String attaZipFilePath = String.format("%s%s.zip", this.targetDirectory, attaZipKey);
            try (OutputStream out = Files.newOutputStream(Paths.get(attaZipFilePath, new String[0]), new OpenOption[0]);){
                fs.batchDownload(downloadRequest, out, null);
                this.result.setAttachmentFilePath(attaZipKey + ".zip");
            }
            catch (Exception ex) {
                logger.error("\u5bfc\u51fa\u6587\u6863\u77e5\u8bc6\u5e93\u7684\u9644\u4ef6\u5931\u8d25\u3002", (Throwable)ex);
            }
        }
        catch (Exception ex) {
            logger.error("\u5bfc\u51fa\u6587\u6863\u77e5\u8bc6\u5e93\u7684\u9644\u4ef6\u5931\u8d25\u3002", (Throwable)ex);
        }
    }

    private void exportData() {
        StringBuilder sbFields = new StringBuilder();
        sbFields.append("id,number,name,status,enable,desc,metric_type,index_method,string_total_num,file_total,type,repo_source,chunk_strategy,isfulltext,chunk_maxlength,identifiertype,combo_presetidentifier,text_customidentifier,checkbox_replacesymbol,checkbox_deleteurl,");
        sbFields.append("doc_manage.id,doc_manage.file_name,doc_manage.file_status,doc_manage.hit_num,doc_manage.file_path,doc_manage.file_size,doc_manage.file_type,doc_manage.create_date,doc_manage.string_num,doc_manage.url,doc_manage.file_source,doc_manage.title,doc_manage.progress,doc_manage.log");
        String filePath = String.format("%s%s", this.targetDirectory, this.targetFileName);
        DynamicObjectCollection allDatas = QueryServiceHelper.query((String)"gai_repo_info", (String)sbFields.toString(), (QFilter[])new QFilter[]{new QFilter("id", "in", this.pkIds)});
        if (allDatas.isEmpty()) {
            return;
        }
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(filePath));){
            String[] fields = sbFields.toString().split(",");
            long prePkId = 0L;
            bufferedWriter.write(sbFields.toString());
            bufferedWriter.newLine();
            for (int i = 0; i < allDatas.size(); ++i) {
                DynamicObject row = (DynamicObject)allDatas.get(i);
                long id = row.getLong("id");
                if (i == 0) {
                    for (String field : fields) {
                        bufferedWriter.write(row.get(field).getClass().getName());
                        bufferedWriter.write(",");
                    }
                    bufferedWriter.newLine();
                }
                for (String field : fields) {
                    if (id != prePkId || field.startsWith("doc_manage")) {
                        bufferedWriter.write(row.get(field).toString());
                    }
                    bufferedWriter.write(",");
                }
                long entryId = row.getLong("doc_manage.id");
                String attrFilePath = row.getString("doc_manage.file_path");
                String attrFileName = row.getString("doc_manage.file_name");
                this.mapAttachmentsPath.put(entryId, attrFilePath);
                this.mapAttachmentsFileName.put(entryId, attrFileName);
                prePkId = id;
                bufferedWriter.newLine();
            }
            bufferedWriter.flush();
        }
        catch (Exception ex) {
            logger.error("\u5199\u5165\u6587\u4ef6\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)ex);
        }
        this.result.setRepoFilePath(this.targetFileName);
    }

    public static class ExportResult {
        private String repoFilePath;
        private String attachmentFilePath;

        public String getRepoFilePath() {
            return this.repoFilePath;
        }

        public void setRepoFilePath(String repoFilePath) {
            this.repoFilePath = repoFilePath;
        }

        public String getAttachmentFilePath() {
            return this.attachmentFilePath;
        }

        public void setAttachmentFilePath(String attachmentFilePath) {
            this.attachmentFilePath = attachmentFilePath;
        }
    }
}

