/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.repo.exp;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import kd.ai.gai.core.repo.entity.FileRepoChunkExportData;
import kd.ai.gai.core.repo.entity.FileRepoExportChunkDataParam;
import kd.ai.gai.core.repo.entity.FileRepoExportVectorDataParam;
import kd.ai.gai.core.repo.entity.FileRepoVectorExportData;
import kd.ai.gai.core.repo.entity.QueryDataResult;
import kd.ai.gai.core.repo.exp.ExpStatusEnum;
import kd.ai.gai.core.repo.exp.ExportFileRepoTask;
import kd.ai.gai.core.repo.exp.GetPropertyAction;
import kd.ai.gai.core.repo.exp.RepoExpCallbackListener;
import kd.ai.gai.core.repo.helper.GaiFileRepoDataServiceHelper;
import kd.ai.gai.core.trace.util.CommonUtil;
import kd.bos.context.RequestContextCreator;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.zip.ZipFile;
import kd.bos.zip.exception.ZipException;
import kd.bos.zip.model.ZipParameters;
import org.apache.commons.io.FileUtils;

public class GaiRepoExpUtils {
    private static Log logger = LogFactory.getLog(GaiRepoExpUtils.class);
    private static final ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"ai-gai-repo-export-threadPool", (int)2, (String)"gai");
    private static final String REPOATTACHMENT_FILE_PREFIX = "REPO_ATTACHMENT";
    private static final String REPOFILE_FILE_PREFIX = "REPO_FILE";
    private static final String REPOCHUNK_FILE_PREFIX = "REPO_CHUNK";
    private static final String REPOVECTOR_FILE_PREFIX = "REPO_VECTOR";
    private static final String REPO_FILE_LIST_PREFIX = "filelist";
    private static final Long DEFAULT_QUERY_PAGE_SIZE = 500L;

    public static void execute(Runnable runnable) {
        threadPool.execute(runnable, RequestContextCreator.createForThreadPool());
    }

    public static String writeRepoZipFile(Long repoId, String repoNumber, RepoExpCallbackListener callbackListener) {
        String zipFilePath = null;
        try {
            String zipDirectory = GaiRepoExpUtils.getZipTmpFileDirectory(repoNumber);
            logger.info("\u3010\u77e5\u8bc6\u5e93\u5bfc\u51fa- RepoId:{},Number:{}\u3011\u3002\u5f00\u59cb\u5bfc\u51fa\u77e5\u8bc6\u5e93\u914d\u7f6e\u6587\u4ef6");
            callbackListener.updateStatus(ExpStatusEnum.START_EXPORT_REPO_CONFIG, 1);
            callbackListener.updateStatus(ExpStatusEnum.FINISH_EXPORT_REPO_CONFIG, 10);
            logger.info("\u3010\u77e5\u8bc6\u5e93\u5bfc\u51fa- RepoId:{},Number:{}\u3011\u3002\u5b8c\u6210\u5bfc\u51fa\u77e5\u8bc6\u5e93\u914d\u7f6e\u6587\u4ef6");
            logger.info("\u3010\u77e5\u8bc6\u5e93\u5bfc\u51fa- RepoId:{},Number:{}\u3011\u3002\u5f00\u59cb\u5bfc\u51fa\u77e5\u8bc6\u5e93\u6570\u636e\u6587\u4ef6");
            callbackListener.updateStatus(ExpStatusEnum.START_EXPORT_REPO_FILE, 10);
            long start = System.currentTimeMillis();
            ExportFileRepoTask.ExportResult exportResult = GaiRepoExpUtils.writeRepoFile(zipDirectory, repoId, repoNumber);
            String repoFileName = exportResult.getRepoFilePath();
            String repoAttachmentFileName = exportResult.getAttachmentFilePath();
            long finishRepoDataTime = System.currentTimeMillis();
            logger.info("\u3010\u77e5\u8bc6\u5e93\u5bfc\u51fa- RepoId:{},Number:{}\u3011\u3002\u5b8c\u6210\u5bfc\u51fa\u77e5\u8bc6\u5e93\u6570\u636e\u6587\u4ef6\uff0c\u5171\u8017\u65f6 {} \u6beb\u79d2", new Object[]{finishRepoDataTime - start, repoId, repoNumber});
            callbackListener.updateStatus(ExpStatusEnum.FINISH_EXPORT_REPO_FILE, 40);
            logger.info("\u3010\u77e5\u8bc6\u5e93\u5bfc\u51fa- RepoId:{},Number:{}\u3011\u3002\u5f00\u59cb\u5bfc\u51fa\u77e5\u8bc6\u5e93\u6587\u672c\u5757\u6587\u4ef6", (Object)repoId, (Object)repoNumber);
            callbackListener.updateStatus(ExpStatusEnum.START_EXPORT_REPO_CHUNK_FILE, 40);
            String repoChunkFileName = GaiRepoExpUtils.writeRepoChunkFile(zipDirectory, repoId, repoNumber);
            long finishRepoChunkTime = System.currentTimeMillis();
            logger.info("\u3010\u77e5\u8bc6\u5e93\u5bfc\u51fa- RepoId:{},Number:{}\u3011\u3002\u5b8c\u6210\u5bfc\u51fa\u77e5\u8bc6\u5e93\u6587\u672c\u5757\u6587\u4ef6\uff0c\u5171\u8017\u65f6 {} \u6beb\u79d2", new Object[]{finishRepoChunkTime - finishRepoDataTime, repoId, repoNumber});
            callbackListener.updateStatus(ExpStatusEnum.FINISH_EXPORT_REPO_CHUNK_FILE, 60);
            logger.info("\u3010\u77e5\u8bc6\u5e93\u5bfc\u51fa- RepoId:{},Number:{}\u3011\u3002\u5f00\u59cb\u5bfc\u51fa\u77e5\u8bc6\u5e93\u5411\u91cf\u6587\u4ef6", (Object)repoId, (Object)repoNumber);
            callbackListener.updateStatus(ExpStatusEnum.START_EXPORT_REPO_VECTOR_FILE, 60);
            String repoVectorFileName = GaiRepoExpUtils.writeRepoVectorFile(zipDirectory, repoId, repoNumber);
            long finishRepoVectorTime = System.currentTimeMillis();
            logger.info("\u3010\u77e5\u8bc6\u5e93\u5bfc\u51fa- RepoId:{},Number:{}\u3011\u3002\u5b8c\u6210\u5bfc\u51fa\u77e5\u8bc6\u5e93\u5411\u91cf\u6587\u4ef6\uff0c\u5171\u8017\u65f6 {} \u6beb\u79d2", new Object[]{finishRepoVectorTime - finishRepoChunkTime, repoId, repoNumber});
            callbackListener.updateStatus(ExpStatusEnum.FINISH_EXPORT_REPO_VECTOR_FILE, 85);
            logger.info("\u3010\u77e5\u8bc6\u5e93\u5bfc\u51fa- RepoId:{},Number:{}\u3011\u3002\u5f00\u59cb\u6253\u5305\u77e5\u8bc6\u5e93zip\u6587\u4ef6", (Object)repoId, (Object)repoNumber);
            GaiRepoExpUtils.writeFileList(zipDirectory, repoFileName, repoAttachmentFileName, repoChunkFileName, repoVectorFileName);
            callbackListener.updateStatus(ExpStatusEnum.START_EXPORT_REPO_FILE_PACKAGE, 89);
            zipFilePath = GaiRepoExpUtils.genZipFile(zipDirectory, repoNumber);
            callbackListener.updateStatus(ExpStatusEnum.FINISH_EXPORT_REPO_FILE_PACKAGE, 100);
            long finishPackageTime = System.currentTimeMillis();
            logger.info("\u3010\u77e5\u8bc6\u5e93\u5bfc\u51fa- RepoId:{},Number:{}\u3011\u3002\u5b8c\u6210\u5bfc\u6253\u5305\u77e5\u8bc6\u5e93zip\u6587\u4ef6\uff0c\u5171\u8017\u65f6 {} \u6beb\u79d2", new Object[]{finishPackageTime - finishRepoVectorTime, repoId, repoNumber});
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u77e5\u8bc6\u5e93\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f={}", (Object)CommonUtil.getStackTrace(e));
            throw new KDBizException(e.getMessage());
        }
        return zipFilePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String genZipFile(String zipDirectory, String repoNumber) throws ZipException, FileNotFoundException {
        File zipFile = GaiRepoExpUtils.zipFromAppDir(new File(zipDirectory));
        FileInputStream is = null;
        String zipFilePath = null;
        try {
            is = new FileInputStream(zipFile);
            FileService fs = FileServiceFactory.getAttachmentFileService();
            String zipFileName = GaiRepoExpUtils.genFileName(repoNumber, ".zip");
            String zipFileUploadPath = GaiRepoExpUtils.genFilePath(repoNumber, zipFileName);
            zipFilePath = fs.upload(new FileItem(zipFileName, zipFileUploadPath, (InputStream)is));
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }
        }
        return zipFilePath;
    }

    private static String writeFileList(String zipDirectory, String repoFileName, String repoAttachmentFileName, String repoChunkFileName, String repoVectorFileName) throws IOException {
        String fileName = String.format("%s.json", REPO_FILE_LIST_PREFIX);
        JSONObject data = new JSONObject();
        data.put(REPOCHUNK_FILE_PREFIX, (Object)repoChunkFileName);
        data.put(REPOVECTOR_FILE_PREFIX, (Object)repoVectorFileName);
        data.put(REPOFILE_FILE_PREFIX, (Object)repoFileName);
        data.put(REPOATTACHMENT_FILE_PREFIX, (Object)repoAttachmentFileName);
        ByteArrayInputStream is = new ByteArrayInputStream(JSONObject.toJSONString((Object)data).getBytes(StandardCharsets.UTF_8));
        File destFile = FileUtils.getFile((String[])new String[]{String.format("%s%s", zipDirectory, fileName)});
        if (!destFile.exists()) {
            FileUtils.touch((File)destFile);
        }
        FileUtils.copyInputStreamToFile((InputStream)is, (File)destFile);
        return destFile.getAbsolutePath();
    }

    private static ExportFileRepoTask.ExportResult writeRepoFile(String zipDirectory, Long repoId, String repoNumber) {
        String fileName = GaiRepoExpUtils.genFileName(REPOFILE_FILE_PREFIX, ".csv");
        ArrayList<Object> pkIds = new ArrayList<Object>();
        pkIds.add(repoId);
        ExportFileRepoTask task = new ExportFileRepoTask(fileName, zipDirectory, pkIds);
        return task.export();
    }

    private static String writeRepoChunkFile(String zipDirectory, Long repoId, String repoNumber) throws IOException {
        String fileName = GaiRepoExpUtils.genFileName(REPOCHUNK_FILE_PREFIX, ".txt");
        OutputStreamWriter fileWriter = null;
        try {
            File file = FileUtils.getFile((String[])new String[]{String.format("%s%s", zipDirectory, fileName)});
            if (!file.exists()) {
                FileUtils.touch((File)file);
            }
            fileWriter = new FileWriter(file, true);
            Long pageSize = DEFAULT_QUERY_PAGE_SIZE;
            Long startNumber = 1L;
            Long page = 1L;
            logger.info("\u3010\u77e5\u8bc6\u5e93\u5bfc\u51fa\u3011\u3002\u67e5\u8be2\u77e5\u8bc6\u5e93\u6587\u672c\u5757\u6587\u4ef6\uff0c\u5f00\u59cb\uff1a{}\uff0c\u67e5\u8be2\u6761\u6570\uff1a{}", (Object)startNumber, (Object)pageSize);
            QueryDataResult<List<FileRepoChunkExportData>> result = GaiRepoExpUtils.queryRepoChunkData(repoId, pageSize, 1L);
            Long totalNum = result.getTotalNum();
            logger.info("\u3010\u77e5\u8bc6\u5e93\u5bfc\u51fa\u3011\u3002\u5f00\u67e5\u8be2\u77e5\u8bc6\u5e93\u6587\u672c\u5757\u6587\u4ef6\uff0c\u5171\u67e5\u8be2\u6761\u6570\uff1a{}", (Object)totalNum);
            List<FileRepoChunkExportData> listData = result.getData();
            GaiRepoExpUtils.writeFileRepoChunkExportDataList((FileWriter)fileWriter, listData);
            if (totalNum > pageSize) {
                Long readTotal = pageSize;
                while (readTotal < totalNum) {
                    Long l = page;
                    Long l2 = page = Long.valueOf(page + 1L);
                    startNumber = pageSize * (page - 1L) + 1L;
                    logger.info("\u3010\u77e5\u8bc6\u5e93\u5bfc\u51fa\u3011\u3002\u5199\u5165\u77e5\u8bc6\u5e93\u6587\u672c\u5757\u6587\u4ef6\uff0c\u7b2c\uff1a{}\u9875\uff0c\u5f00\u59cb\uff1a{}\uff0c\u6761\u6570\uff1a{}", new Object[]{page, startNumber, pageSize});
                    QueryDataResult<List<FileRepoChunkExportData>> streamResult = GaiRepoExpUtils.queryRepoChunkData(repoId, pageSize, startNumber);
                    readTotal = readTotal + pageSize;
                    List<FileRepoChunkExportData> streamData = streamResult.getData();
                    GaiRepoExpUtils.writeFileRepoChunkExportDataList((FileWriter)fileWriter, streamData);
                }
            }
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Exception e) {
            throw new KDBizException("\u5bfc\u51fa\u77e5\u8bc6\u5e93\u6587\u672c\u5757\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f=" + e.getMessage());
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }
        }
        return fileName;
    }

    private static void writeFileRepoChunkExportDataList(FileWriter fileWriter, List<FileRepoChunkExportData> listData) throws IOException {
        for (FileRepoChunkExportData data : listData) {
            fileWriter.write(Base64.getEncoder().encodeToString(JSONObject.toJSONString((Object)data).getBytes(StandardCharsets.UTF_8)) + "\n");
        }
    }

    private static String writeRepoVectorFile(String zipDirectory, Long repoId, String repoNumber) throws IOException {
        String fileName = GaiRepoExpUtils.genFileName(REPOVECTOR_FILE_PREFIX, ".txt");
        OutputStreamWriter fileWriter = null;
        try {
            List<Long> chunks;
            File file = FileUtils.getFile((String[])new String[]{String.format("%s%s", zipDirectory, fileName)});
            if (!file.exists()) {
                FileUtils.touch((File)file);
            }
            fileWriter = new FileWriter(String.format("%s%s", zipDirectory, fileName), true);
            long pageSize = DEFAULT_QUERY_PAGE_SIZE;
            long startNumber = 1L;
            logger.info("\u3010\u77e5\u8bc6\u5e93\u5bfc\u51fa\u3011,\u67e5\u8be2\u5411\u91cf\u6570\u636e,\u5f00\u59cb\uff1a{}\uff0c\u67e5\u8be2\u6761\u6570\uff1a{}", (Object)startNumber, (Object)pageSize);
            QueryDataResult<FileRepoVectorExportData> result = GaiRepoExpUtils.queryRepoVectorData(repoId, pageSize, startNumber);
            FileRepoVectorExportData fileRepoVectorExportData = result.getData();
            if (fileRepoVectorExportData != null && (chunks = fileRepoVectorExportData.getChunkIds()) != null) {
                int firstCount = chunks.size();
                logger.info("\u3010\u77e5\u8bc6\u5e93\u5bfc\u51fa\u3011,\u7b2c\u4e00\u6b21\u67e5\u8be2\u5411\u91cf\u6570\u636e\u6761\u6570\uff1a{}\u6761", (Object)firstCount);
                if (firstCount != 0) {
                    GaiRepoExpUtils.writeFileRepoVectorExportData((FileWriter)fileWriter, fileRepoVectorExportData);
                }
                if (fileRepoVectorExportData.getChunkIds().size() != 0) {
                    int count = 0;
                    do {
                        logger.info("\u3010\u77e5\u8bc6\u5e93\u5bfc\u51fa\u3011,\u67e5\u8be2\u5411\u91cf\u6570\u636e,\u5f00\u59cb\uff1a{}\uff0c\u67e5\u8be2\u6761\u6570\uff1a{}", (Object)(startNumber += pageSize), (Object)pageSize);
                        QueryDataResult<FileRepoVectorExportData> streamResult = GaiRepoExpUtils.queryRepoVectorData(repoId, pageSize, startNumber);
                        logger.info("\u3010\u77e5\u8bc6\u5e93\u5bfc\u51fa\u3011,\u67e5\u8be2\u5411\u91cf\u6570\u636e,\u5171\u67e5\u8be2\u6761\u6570\uff1a{}", (Object)count);
                        if (streamResult.getData().getChunkIds() == null) continue;
                        count = streamResult.getData().getChunkIds().size();
                        FileRepoVectorExportData streamData = streamResult.getData();
                        GaiRepoExpUtils.writeFileRepoVectorExportData((FileWriter)fileWriter, streamData);
                    } while (count != 0);
                }
            }
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u77e5\u8bc6\u5e93\u5411\u91cf\u51fa\u73b0\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f={}", (Object)CommonUtil.getStackTrace(e));
            throw new KDBizException("\u5bfc\u51fa\u77e5\u8bc6\u5e93\u5411\u91cf\u51fa\u73b0\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f=" + e.getMessage());
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }
        }
        return fileName;
    }

    private static void writeFileRepoVectorExportData(FileWriter fileWriter, FileRepoVectorExportData data) throws IOException {
        String base = Base64.getEncoder().encodeToString(JSONObject.toJSONString((Object)data).getBytes(StandardCharsets.UTF_8));
        fileWriter.write(base + "\n");
    }

    private static String genFileName(String prefix, String fileType) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String fileName = prefix + "_" + sdf.format(new Date()) + fileType;
        return fileName;
    }

    private static String genFilePath(String repoNumber, String fileName) {
        String pathName = "/repo/" + repoNumber + "/" + fileName;
        return pathName;
    }

    private static File zipFromAppDir(File originDir) throws ZipException {
        File tmpdir = new File(AccessController.doPrivileged(new GetPropertyAction("java.io.tmpdir")));
        String dirName = originDir.getName();
        String tmpZipPath = tmpdir.getAbsolutePath() + File.separator + dirName + ".zip";
        ZipFile zFile = new ZipFile(tmpZipPath);
        zFile.setCharset(Charset.forName("GBK"));
        ZipParameters zipParameters = new ZipParameters();
        zipParameters.setIncludeRootFolder(false);
        zFile.addFolder(originDir, zipParameters);
        return zFile.getFile();
    }

    private static String getZipTmpFileDirectory(String repoNumber) throws IOException {
        File tmpdir = new File(AccessController.doPrivileged(new GetPropertyAction("java.io.tmpdir")));
        String directory = tmpdir.getAbsolutePath() + File.separator + repoNumber + File.separator + System.currentTimeMillis() + File.separator;
        File dic = FileUtils.getFile((String[])new String[]{directory});
        if (!dic.exists()) {
            Files.createDirectories(dic.toPath(), new FileAttribute[0]);
        }
        return directory;
    }

    private static QueryDataResult<List<FileRepoChunkExportData>> queryRepoChunkData(Long repoId, Long pageSize, Long startNum) {
        FileRepoExportChunkDataParam exportDataParam = new FileRepoExportChunkDataParam(repoId, startNum, pageSize);
        return GaiFileRepoDataServiceHelper.queryExportChunkData(exportDataParam);
    }

    private static QueryDataResult<FileRepoVectorExportData> queryRepoVectorData(Long repoId, Long pageSize, Long startNum) {
        FileRepoExportVectorDataParam exportDataParam = new FileRepoExportVectorDataParam(repoId, startNum, pageSize);
        return GaiFileRepoDataServiceHelper.queryExportVectorData(exportDataParam);
    }
}

