/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.repo.exp;

import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import kd.ai.gai.core.repo.entity.FileRepoChunkExportData;
import kd.ai.gai.core.repo.entity.FileRepoVectorExportData;
import kd.ai.gai.core.repo.exp.ExpStatusEnum;
import kd.ai.gai.core.repo.exp.GetPropertyAction;
import kd.ai.gai.core.repo.exp.ImportFileRepoTask;
import kd.ai.gai.core.repo.exp.RepoExpCallbackListener;
import kd.ai.gai.core.repo.exp.ZipUtil;
import kd.ai.gai.core.repo.helper.GaiFileRepoDataServiceHelper;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.context.RequestContextCreator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class GaiRepoImpUtils {
    private static Log logger = LogFactory.getLog(GaiRepoImpUtils.class);
    private RepoExpCallbackListener listener;
    private final String FILE_LIST_NAME = "filelist.json";
    private static final ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"ai-gai-repo-import-threadPool", (int)2, (String)"gai");

    public static void execute(Runnable runnable) {
        threadPool.execute(runnable, RequestContextCreator.createForThreadPool());
    }

    public GaiRepoImpUtils(RepoExpCallbackListener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importRepoFile(String fileUrl) {
        logger.info("\u3010\u77e5\u8bc6\u5e93\u5bfc\u5165\u3011\u3002\u5f00\u59cb\u4e0b\u8f7dzip\u6587\u4ef6\uff0c\u6587\u4ef6URL\uff1a{}", (Object)fileUrl);
        this.listener.updateStatus(ExpStatusEnum.START_IMPORT_REPO_ZIP_PARSER, 1);
        TempFileCacheDownloadable downLoad = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        InputStream inStream = null;
        String zipDirectory = null;
        try {
            String[] queryParams = new URL(fileUrl).getQuery().split("&");
            HashMap<String, String> downloadFileParams = new HashMap<String, String>(0);
            for (String queryParam : queryParams) {
                String[] p = queryParam.split("=");
                downloadFileParams.put(p[0], p[1]);
            }
            TempFileCacheDownloadable.Content content = downLoad.get((String)downloadFileParams.get("configKey"), (String)downloadFileParams.get("id"));
            inStream = content.getInputStream();
            logger.info("\u3010\u77e5\u8bc6\u5e93\u5bfc\u5165\u3011\u3002\u5f00\u59cb\u89e3\u538bzip\u6587\u4ef6");
            zipDirectory = this.unzipFile(inStream);
            logger.info("\u3010\u77e5\u8bc6\u5e93\u5bfc\u5165\u3011\u3002\u5b8c\u6210zip\u6587\u4ef6\u89e3\u538b\uff0c\u89e3\u538b\u4e34\u65f6\u76ee\u5f55\uff1a{}", (Object)zipDirectory);
            this.listener.updateStatus(ExpStatusEnum.FINISH_IMPORT_REPO_ZIP_PARSER, 10);
        }
        catch (Exception e) {
            this.listener.operationResult(Boolean.FALSE, String.format("\u89e3\u6790\u4e0a\u4f20\u6587\u4ef6\u65f6\u51fa\u73b0\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f=%s", e.getMessage()));
            return;
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        try {
            logger.info("\u3010\u77e5\u8bc6\u5e93\u5bfc\u5165\u3011\u3002\u5f00\u59cb\u89e3\u6790\u6570\u636e\u6587\u4ef6\u5e76\u5bfc\u5165");
            this.readAndParserFile(zipDirectory);
            logger.info("\u3010\u77e5\u8bc6\u5e93\u5bfc\u5165\u3011\u3002\u5b8c\u6210\u89e3\u6790\u6570\u636e\u6587\u4ef6\u5e76\u5bfc\u5165");
        }
        catch (IOException e) {
            logger.error("\u89e3\u6790\u6587\u4ef6\u5217\u8868\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f=", (Object)e.getMessage());
            this.listener.operationResult(Boolean.FALSE, String.format("\u5bfc\u5165\u77e5\u8bc6\u5e93\u51fa\u73b0\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f=%s", e.getMessage()));
        }
        catch (KDBizException ex) {
            this.listener.operationResult(Boolean.FALSE, String.format("\u5bfc\u5165\u77e5\u8bc6\u5e93\u51fa\u73b0\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f=%s", ex.getMessage()));
        }
    }

    public String unzipFile(InputStream is) throws IOException {
        String zipDirectory = this.getZipTmpFileDirectory();
        File zipFile = new File(zipDirectory + System.currentTimeMillis() + ".zip");
        FileUtils.copyInputStreamToFile((InputStream)is, (File)zipFile);
        File zipDic = new File(zipDirectory);
        ZipUtil.unzipFile(zipFile, zipDic);
        Files.delete(zipFile.toPath());
        return zipDirectory;
    }

    private String getZipTmpFileDirectory() {
        File tmpdir = new File(AccessController.doPrivileged(new GetPropertyAction("java.io.tmpdir")));
        return tmpdir.getAbsolutePath() + File.separator + "repoimport" + File.separator + System.currentTimeMillis() + File.separator;
    }

    public void readAndParserFile(String zipDirectory) throws IOException {
        String fileInfo = FileUtils.readFileToString((File)new File(zipDirectory + "filelist.json"), (String)"utf-8");
        JSONObject fileItem = JSONObject.parseObject((String)fileInfo);
        if (fileItem != null) {
            String repoChunkFile = fileItem.getString("REPO_CHUNK");
            String repoVectorFile = fileItem.getString("REPO_VECTOR");
            String repoFileName = fileItem.getString("REPO_FILE");
            String repoAttachmentName = fileItem.getString("REPO_ATTACHMENT");
            String chunkFilePath = String.format("%s%s", zipDirectory, repoChunkFile);
            String vectorFilePath = String.format("%s%s", zipDirectory, repoVectorFile);
            this.listener.updateStatus(ExpStatusEnum.START_IMPORT_REPO_CONFIG, 10);
            this.listener.updateStatus(ExpStatusEnum.FINISH_IMPORT_REPO_CONFIG, 12);
            this.listener.updateStatus(ExpStatusEnum.START_IMPORT_REPO_FILE, 12);
            String repoFile = String.format("%s%s", zipDirectory, repoFileName);
            String attachmentZipFile = String.format("%s%s", zipDirectory, repoAttachmentName);
            logger.info("\u3010\u77e5\u8bc6\u5e93\u5bfc\u5165\u3011\u3002\u5f00\u59cb\u5bfc\u5165\u77e5\u8bc6\u5e93\u6587\u4ef6");
            long start = System.currentTimeMillis();
            this.importRepoDataFile(repoFile, attachmentZipFile);
            long finishRepoFileTime = System.currentTimeMillis();
            logger.info("\u3010\u77e5\u8bc6\u5e93\u5bfc\u5165\u3011\u3002\u5b8c\u6210\u5bfc\u5165\u77e5\u8bc6\u5e93\u6587\u4ef6\uff0c\u5171\u8017\u65f6 {} \u6beb\u79d2", (Object)(finishRepoFileTime - start));
            this.listener.updateStatus(ExpStatusEnum.FINISH_IMPORT_REPO_FILE, 24);
            logger.info("\u3010\u77e5\u8bc6\u5e93\u5bfc\u5165\u3011\u3002\u5f00\u59cb\u5bfc\u5165\u77e5\u8bc6\u5e93\u6587\u672c\u5757\u6587\u4ef6");
            this.listener.updateStatus(ExpStatusEnum.START_IMPORT_REPO_CHUNK_FILE, 24);
            this.importChunkFile(chunkFilePath);
            long finishRepoChunk = System.currentTimeMillis();
            logger.info("\u3010\u77e5\u8bc6\u5e93\u5bfc\u5165\u3011\u3002\u5b8c\u6210\u5bfc\u5165\u77e5\u8bc6\u5e93\u6587\u672c\u5757\u6587\u4ef6\uff0c\u5171\u8017\u65f6 {} \u6beb\u79d2", (Object)(finishRepoChunk - finishRepoFileTime));
            this.listener.updateStatus(ExpStatusEnum.FINISH_IMPORT_REPO_CHUNK_FILE, 70);
            logger.info("\u3010\u77e5\u8bc6\u5e93\u5bfc\u5165\u3011\u3002\u5f00\u59cb\u5bfc\u5165\u77e5\u8bc6\u5e93\u5411\u91cf\u6587\u4ef6");
            this.listener.updateStatus(ExpStatusEnum.START_IMPORT_REPO_VECTOR_FILE, 70);
            this.importVectorFile(vectorFilePath);
            long finishVectorTime = System.currentTimeMillis();
            logger.info("\u3010\u77e5\u8bc6\u5e93\u5bfc\u5165\u3011\u3002\u5b8c\u6210\u5bfc\u5165\u77e5\u8bc6\u5e93\u5411\u91cf\u6587\u4ef6\uff0c\u5171\u8017\u65f6 {} \u6beb\u79d2", (Object)(finishVectorTime - finishRepoChunk));
            this.listener.updateStatus(ExpStatusEnum.FINISH_IMPORT_REPO_VECTOR_FILE, 100);
        }
    }

    private void importVectorFile(String filePath) {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(filePath));
            String line = null;
            String data = null;
            FileRepoVectorExportData fileRepoVectorExportData = null;
            while ((line = br.readLine()) != null) {
                data = new String(Base64.getDecoder().decode(line));
                if (StringUtils.isEmpty((CharSequence)data)) continue;
                fileRepoVectorExportData = (FileRepoVectorExportData)JSONObject.parseObject((String)data, FileRepoVectorExportData.class);
                GaiFileRepoDataServiceHelper.importVectorData(fileRepoVectorExportData);
            }
        }
        catch (Exception e) {
            throw new KDBizException("\u5bfc\u5165\u77e5\u8bc6\u5e93\u6587\u672c\u5757\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f=" + e.getMessage());
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }
        }
    }

    private void importChunkFile(String filePath) {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(filePath));
            String line = null;
            String data = null;
            ArrayList<FileRepoChunkExportData> chunkExportDataList = new ArrayList<FileRepoChunkExportData>(0);
            while ((line = br.readLine()) != null) {
                data = new String(Base64.getDecoder().decode(line));
                if (StringUtils.isEmpty((CharSequence)data)) continue;
                FileRepoChunkExportData fileRepoChunkExportData = (FileRepoChunkExportData)JSONObject.parseObject((String)data, FileRepoChunkExportData.class);
                chunkExportDataList.add(fileRepoChunkExportData);
            }
            br.close();
            int pageNum = 100;
            if (!chunkExportDataList.isEmpty()) {
                int total = chunkExportDataList.size();
                logger.info("\u3010\u77e5\u8bc6\u5e93\u5bfc\u5165\u3011\u3002\u6309\u6279\u6b21\u5bfc\u5165\u77e5\u8bc6\u5e93\u6587\u672c\u5757\u6587\u4ef6\uff0c\u5171\uff1a{}\u6761\uff0c\u6bcf\u6279\u6b21\u5bfc\u5165\uff1a{}\u6761", (Object)total, (Object)pageNum);
                if (total <= pageNum) {
                    GaiFileRepoDataServiceHelper.importChunkData(chunkExportDataList);
                } else {
                    List<FileRepoChunkExportData> subList;
                    int endIndex;
                    int startIndex;
                    int pageCount = total / pageNum;
                    for (int page = 1; page <= pageCount; ++page) {
                        startIndex = (page - 1) * pageNum;
                        endIndex = (page - 1) * pageNum + pageNum;
                        subList = chunkExportDataList.subList(startIndex, endIndex);
                        logger.info("\u3010\u77e5\u8bc6\u5e93\u5bfc\u5165\u3011\u3002\u6309\u6279\u6b21\u5bfc\u5165\u77e5\u8bc6\u5e93\u6587\u672c\u5757\u6587\u4ef6\uff0c\u6279\u6b21\u53f7\uff1a{},\u5f00\u59cb\u884c\uff1a{}\uff0c\u7ed3\u675f\u884c\uff1a{}", new Object[]{page, startIndex, endIndex});
                        GaiFileRepoDataServiceHelper.importChunkData(subList);
                    }
                    int less = total % pageNum;
                    if (less != 0) {
                        startIndex = pageCount * pageNum;
                        endIndex = total;
                        subList = chunkExportDataList.subList(startIndex, endIndex);
                        logger.info("\u3010\u77e5\u8bc6\u5e93\u5bfc\u5165\u3011\u3002\u6309\u6279\u6b21\u5bfc\u5165\u77e5\u8bc6\u5e93\u6587\u672c\u5757\u6587\u4ef6\uff0c\u6279\u6b21\u53f7\uff1a{},\u5f00\u59cb\u884c\uff1a{}\uff0c\u7ed3\u675f\u884c\uff1a{}", new Object[]{pageCount + 1, startIndex, endIndex});
                        GaiFileRepoDataServiceHelper.importChunkData(subList);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new KDBizException("\u5bfc\u5165\u77e5\u8bc6\u5e93\u6587\u672c\u5757\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f=" + e.getMessage());
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    br = null;
                }
            }
        }
    }

    private void importRepoDataFile(String repoFilePath, String attachmentsZipPath) {
        ImportFileRepoTask task = new ImportFileRepoTask(repoFilePath, attachmentsZipPath);
        task.importData();
    }

    private void importRepoConfigFile(String zipDirectory) {
    }
}

